/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.mongo;

import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MsgStateEnum;
import com.digiwin.athena.aim.domain.message.repository.MessageMapper;
import com.digiwin.athena.aim.infrastructure.mongo.AbstractMongoMessageMapper;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MongoMessageMapper
extends AbstractMongoMessageMapper
implements MessageMapper {
    public List<MessageDO> selectMsgSummaryBySubTypeCategory(MessageDO condition) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId()).and("subTypeCategory").is((Object)condition.getSubTypeCategory());
        if (null != condition.getImportance()) {
            criteria.and("importance").is((Object)condition.getImportance());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"})});
        AggregationResults result = this.msgMongoTemplate.aggregate(aggregation, this.getCollectionName(condition), MessageDO.class);
        return result.getMappedResults();
    }

    public long deleteReadMsg(MessageDO condition) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId()).and("state").is((Object)MsgStateEnum.READ.getState());
        if (null != condition.getImportance()) {
            criteria.and("importance").is((Object)condition.getImportance());
        }
        if (null != condition.getSubTypeCategory()) {
            criteria.and("subTypeCategory").is((Object)condition.getSubTypeCategory());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        DeleteResult result = this.msgMongoTemplate.remove(query, this.getCollectionName(condition));
        return result.getDeletedCount();
    }

    public long changeStateToRead(MessageDO condition) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId()).andOperator(new Criteria[]{new Criteria().orOperator(new Criteria[]{Criteria.where((String)"state").is((Object)MsgStateEnum.UNREAD.getState()), Criteria.where((String)"state").is(null)})});
        if (null != condition.getImportance()) {
            criteria.and("importance").is((Object)condition.getImportance());
        }
        if (null != condition.getSubTypeCategory()) {
            criteria.and("subTypeCategory").is((Object)condition.getSubTypeCategory());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("state", (Object)MsgStateEnum.READ.getState()).set("modifyDate", (Object)LocalDateTime.now());
        UpdateResult result = this.msgMongoTemplate.updateMulti(query, (UpdateDefinition)update, this.getCollectionName(condition));
        return result.getModifiedCount();
    }

    public List<Map> selectUnreadCountGroupBySubTypeCategory(MessageDO condition) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId());
        if (null != condition.getImportance()) {
            criteria.and("importance").is((Object)condition.getImportance());
        }
        criteria.and("state").is((Object)MsgStateEnum.UNREAD.getState());
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"subTypeCategory"}).count().as("unreadCount"), Aggregation.project((String[])new String[]{"unreadCount"}).and("subTypeCategory").previousOperation()});
        AggregationResults results = this.msgMongoTemplate.aggregate(aggregation, this.getCollectionName(condition), Map.class);
        return results.getMappedResults();
    }

    public List<MessageDO> selectLatestGroupBySubTypeCategory(MessageDO condition) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId());
        if (null != condition.getImportance()) {
            criteria.and("importance").is((Object)condition.getImportance());
        }
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"gid"}), Aggregation.group((String[])new String[]{"subTypeCategory"}).first("gid").as("gid").first("userId").as("userId").first("tenantId").as("tenantId").first("type").as("type").first("subType").as("subType").first("subTypeCategory").as("subTypeCategory").first("category").as("category").first("importance").as("importance").first("source").as("source").first("state").as("state").first("title").as("title").first("content").as("content").first("sendDate").as("sendDate").first("createDate").as("createDate"), Aggregation.project(MessageDO.class)});
        AggregationResults results = this.msgMongoTemplate.aggregate(aggregation, this.getCollectionName(condition), MessageDO.class);
        return results.getMappedResults();
    }

    public List<MessageDO> selectWorkNewsMsgSummary(MessageDO condition) {
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId());
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"})});
        AggregationResults result = this.msgMongoTemplate.aggregate(aggregation, this.getCollectionName(condition), MessageDO.class);
        return result.getMappedResults();
    }

    public MessageDO insert(MessageDO messageDO) {
        String collectionName = this.getCollectionName(messageDO);
        LocalDateTime createDate = LocalDateTime.now();
        messageDO.setCreateDate(createDate);
        messageDO.setModifyDate(createDate);
        messageDO.setHasReadDetail(Boolean.FALSE);
        this.createCollectionNecessary(collectionName, null);
        return (MessageDO)this.msgMongoTemplate.insert((Object)messageDO, collectionName);
    }

    public long selectUnreadCount(MessageDO condition) {
        if (StringUtils.isEmpty((Object)condition.getTenantId())) {
            return 0L;
        }
        Criteria criteria = Criteria.where((String)"userId").is((Object)condition.getUserId()).and("state").is((Object)MsgStateEnum.UNREAD.getState());
        if (null != condition.getImportance()) {
            criteria.and("importance").is((Object)condition.getImportance());
        }
        if (!StringUtils.isEmpty((Object)condition.getChannelType())) {
            Criteria channelTypeCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"channelType").is((Object)condition.getChannelType()), Criteria.where((String)"channelType").exists(false)});
            criteria.andOperator(new Criteria[]{channelTypeCriteria});
        }
        return this.countByCondition(this.getCollectionName(condition), criteria, 2000L, new String[]{"createDate"});
    }
}

