/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.semc.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.infrastructure.semc.SemcService;
import com.digiwin.athena.aim.infrastructure.semc.dto.GetSsoUrlReq;
import com.digiwin.athena.aim.infrastructure.semc.dto.GetSsoUrlResp;
import com.digiwin.athena.aim.infrastructure.semc.dto.QueryBlackWhiteListResp;
import com.digiwin.athena.aim.infrastructure.semc.dto.QueryTemplateListResp;
import com.digiwin.athena.aim.infrastructure.semc.dto.QueryTemplateRelResp;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.util.List;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SemcServiceImpl
implements SemcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SemcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    public String queryMessageChannel(String tenantId) {
        ResponseEntity respEntity;
        String url = this.envProperties.getSemcUri() + "/semc/message/channel/queryChannel" + "?tenantId=" + tenantId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        }
        catch (BusinessException ex) {
            log.error("query message channel error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
            return null;
        }
        if (respEntity.getStatusCodeValue() == HttpStatus.OK.value() && null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
            return (String)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        log.error("query message channel fail. status:{}, url:{}, param:{}, result:{}", new Object[]{respEntity.getStatusCodeValue(), url, JsonUtils.objectToString((Object)httpEntity), respEntity.getBody()});
        return null;
    }

    public List<QueryTemplateListResp> queryTemplateList(String channelFlag, String eventId, String remark, String tenantId) {
        ResponseEntity respEntity;
        String url = this.envProperties.getSemcUri() + "/semc/message/channel/queryTemplateList";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        reqObject.put((Object)"channelFlag", (Object)channelFlag);
        reqObject.put((Object)"eventId", (Object)eventId);
        reqObject.put((Object)"remark", (Object)remark);
        reqObject.put((Object)"tenantId", (Object)tenantId);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            log.info("start query template list. url:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        }
        catch (BusinessException ex) {
            log.error("query template list error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
            throw BusinessException.create((String)("query template list error:" + ex.getMessage() + ", param:" + JsonUtils.objectToString((Object)httpEntity)));
        }
        if (respEntity.getStatusCodeValue() == HttpStatus.OK.value() && null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
            return (List)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        log.error("query template list fail. status:{}, url:{}, param:{}, result:{}", new Object[]{respEntity.getStatusCodeValue(), url, JsonUtils.objectToString((Object)httpEntity), respEntity.getBody()});
        throw BusinessException.create((String)("query template list fail. param:" + JsonUtils.objectToString((Object)httpEntity) + ", result:" + respEntity));
    }

    public QueryTemplateRelResp queryRelPerson(String tenantId, String eventId, String channelFlag, String templateId, String language) {
        ResponseEntity respEntity;
        String url = this.envProperties.getSemcUri() + "/semc/message/channel/queryRelPerson";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        reqObject.put((Object)"tenantId", (Object)tenantId);
        reqObject.put((Object)"templateId", (Object)templateId);
        reqObject.put((Object)"channelFlag", (Object)channelFlag);
        reqObject.put((Object)"eventId", (Object)eventId);
        reqObject.put((Object)"language", (Object)language);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            log.info("start semc query rel person list. url:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        }
        catch (BusinessException ex) {
            log.error("query semc rel person error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
            throw BusinessException.create((String)("query rel person error:" + ex.getMessage() + ", param:" + JsonUtils.objectToString((Object)httpEntity)));
        }
        if (respEntity.getStatusCodeValue() == HttpStatus.OK.value() && null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
            return (QueryTemplateRelResp)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        log.error("query semc rel person fail. status:{}, url:{}, param:{}, result:{}", new Object[]{respEntity.getStatusCodeValue(), url, JsonUtils.objectToString((Object)httpEntity), respEntity.getBody()});
        throw BusinessException.create((String)("query rel person fail. param:" + JsonUtils.objectToString((Object)httpEntity) + ", result:" + respEntity));
    }

    public List<QueryBlackWhiteListResp> queryBlackWhiteUserList(String tenantId, Integer type, String key) {
        ResponseEntity respEntity;
        key = StringUtils.isBlank((String)key) ? "" : key;
        StringBuilder stringBuilder = new StringBuilder(this.envProperties.getSemcUri()).append("/semc/message/blackwhite/queryUserList");
        StringBuilder url = type == null ? stringBuilder.append("?type=&key=").append(key).append("&tenantId=").append(tenantId) : stringBuilder.append("?type=").append("&key=").append(key).append("&tenantId=").append(tenantId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        JSONObject reqObject = JSONObject.fromObject((Object)this);
        HttpEntity httpEntity = new HttpEntity((Object)reqObject, (MultiValueMap)headers);
        try {
            log.info("start query blackWhite user list. url:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        }
        catch (BusinessException ex) {
            log.error("query blackWhite user list error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
            throw BusinessException.create((String)("query blackWhite user list error:" + ex.getMessage() + ", param:" + JsonUtils.objectToString((Object)httpEntity)));
        }
        if (respEntity.getStatusCodeValue() == HttpStatus.OK.value() && null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
            return (List)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        log.error("query blackWhite user list fail. status:{}, url:{}, param:{}, result:{}", new Object[]{respEntity.getStatusCodeValue(), url, JsonUtils.objectToString((Object)httpEntity), respEntity.getBody()});
        throw BusinessException.create((String)("query blackWhite user list fail. param:" + JsonUtils.objectToString((Object)httpEntity) + ", result:" + respEntity));
    }

    public GetSsoUrlResp getSsoUrl(GetSsoUrlReq req) {
        ResponseEntity respEntity;
        String url = this.envProperties.getSemcUri() + "/tenant/semc/applink/getSsoUrl";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        headers.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        try {
            log.info("start semc getSsoUrlt. url:{}, param:{}", (Object)url, (Object)JsonUtils.objectToString((Object)httpEntity));
            respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        }
        catch (BusinessException ex) {
            log.error("getSsoUrl error. url:{}, param:{}", new Object[]{url, JsonUtils.objectToString((Object)httpEntity), ex});
            return null;
        }
        if (respEntity.getStatusCodeValue() == HttpStatus.OK.value() && null != respEntity.getBody() && ((BaseResultDTO)respEntity.getBody()).isOK()) {
            return (GetSsoUrlResp)((BaseResultDTO)respEntity.getBody()).getResponse();
        }
        log.error("getSsoUrl fail. status:{}, url:{}, param:{}, result:{}", new Object[]{respEntity.getStatusCodeValue(), url, JsonUtils.objectToString((Object)httpEntity), respEntity.getBody()});
        return null;
    }
}

