/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.infrastructure.trans.impl;

import com.digiwin.athena.aim.app.env.EnvProperties;
import com.digiwin.athena.aim.infrastructure.trans.TranslateService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TranslateServiceImpl
implements TranslateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslateServiceImpl.class);
    public static final String TRANSLATE_TW_TO_CN = "zh2Hans";
    public static final String TRANSLATE_CN_TO_TW = "zh2Hant";
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    private static final String DAP_TRANSLATE_PATH = "/restful/service/translater/IDWTranslateService/translate";

    public String translateText(String text, String locale) {
        if (StringUtils.isBlank((CharSequence)text) || "en_US".equals(locale)) {
            return text;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("content", text);
        if ("zh_CN".equals(locale)) {
            requestMap.put("convertTypes", Collections.singletonList(TRANSLATE_TW_TO_CN));
        } else if ("zh_TW".equals(locale)) {
            requestMap.put("convertTypes", Collections.singletonList(TRANSLATE_CN_TO_TW));
        }
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getTransUri()).append(DAP_TRANSLATE_PATH);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                JSONObject data = ((JSONObject)respEntity.getBody()).getJSONObject("response").getJSONObject("data");
                if (Objects.nonNull(data)) {
                    return "zh_CN".equals(locale) ? data.getString(TRANSLATE_TW_TO_CN) : data.getString(TRANSLATE_CN_TO_TW);
                }
                log.error("translate text return empty, url:{}, text:{}", (Object)url, (Object)text);
                return text;
            }
            log.error("translate text fail, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), respEntity.getBody()});
            return text;
        }
        catch (Exception ex) {
            log.error("translate text error, url:{}", (Object)url, (Object)ex);
            return text;
        }
    }
}

