/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.util;

import com.digiwin.athena.appcore.util.TimeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final String DATE_TIME_NORMAL_FORMATTER = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_NORMAL_FORMATTER = "yyyy-MM-dd";
    public static final String DATE_NORMAL_FORMATTER_YYYYMMDD = "yyyyMMdd";
    public static final String DATE_NORMAL_FORMATTER_YYYYMM = "yyyyMM";
    public static final String DATE_NORMAL_FORMATTER_YYYY_MM = "yyyy-MM";
    public static final String TIME_NORMAL_FORMATTER = "HH:mm:ss";
    public static final String DATE_TIME_FORMATTER = "yyyyMMddHHmmss";
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String DAY = "day";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String SECOND = "second";
    public static final String WEEK = "week";

    public static String getNowTime() {
        return DateUtils.getNowTime(null);
    }

    public static String getNowTime(String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String addDate(String dateStr, String pattern, int step, String type) {
        if (dateStr == null) {
            return dateStr;
        }
        Date date1 = TimeUtils.parseDate((String)dateStr, (String)pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        switch (type) {
            case "year": {
                cal.add(1, step);
                break;
            }
            case "month": {
                cal.add(2, step);
                break;
            }
            case "week": {
                cal.add(4, step);
                break;
            }
            case "day": {
                cal.add(5, step);
                break;
            }
            case "hour": {
                cal.add(10, step);
                break;
            }
            case "minute": {
                cal.add(12, step);
                break;
            }
            case "second": {
                cal.add(13, step);
                break;
            }
        }
        return TimeUtils.format((Date)cal.getTime(), (String)pattern);
    }

    public static int compare(Date beginDate, Date endDate) {
        long endTime;
        int ret = 1;
        long beginTime = beginDate.getTime();
        if (beginTime > (endTime = endDate.getTime())) {
            ret = 2;
        }
        if (beginTime == endTime) {
            ret = 1;
        }
        if (beginTime < endTime) {
            ret = 0;
        }
        return ret;
    }

    public static boolean validateDate(String dateParam, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            Date date = formatter.parse(dateParam);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String calDateDifference(Date nowDate, Date endDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = endDate.getTime() - nowDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f";
    }

    public static String DateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = sdf.format(date);
        return dateString;
    }

    public static Date StringToDate(String dateTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(dateTime);
            return date;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date strToDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d = null;
        try {
            d = sdf.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return d;
    }

    public static String getCurrentDateYM() {
        Date currentDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String formattedDate = sdf.format(currentDate);
        return formattedDate;
    }

    public static String getCurrentDateYMD() {
        Date currentDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formattedDate = sdf.format(currentDate);
        return formattedDate;
    }

    public static String getCurrentDateYYYYMM() {
        Date currentDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String formattedDate = sdf.format(currentDate);
        return formattedDate;
    }

    public static String getDateFormat(String input, String nowFormat, String targetFormat) {
        String output = "";
        try {
            SimpleDateFormat formatIn = new SimpleDateFormat(nowFormat);
            Date date = formatIn.parse(input);
            SimpleDateFormat formatOut = new SimpleDateFormat(targetFormat);
            output = formatOut.format(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return output;
    }

    public static Date getNewDate(Date date, int ... number) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (number.length > 0) {
            calendar.set(1, calendar.get(1) + number[0]);
            if (number.length > 1) {
                calendar.set(2, calendar.get(2) + number[1]);
                if (number.length > 2) {
                    calendar.set(5, calendar.get(5) + number[2]);
                    if (number.length > 3) {
                        calendar.set(11, calendar.get(11) + number[3]);
                        if (number.length > 4) {
                            calendar.set(12, calendar.get(12) + number[4]);
                            if (number.length > 5) {
                                calendar.set(13, calendar.get(13) + number[5]);
                            }
                        }
                    }
                }
            }
        }
        return calendar.getTime();
    }
}

