/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.common;

import com.digiwin.athena.ania.common.ServiceException;
import java.io.Serializable;
import java.util.Map;

public class ResultBean<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer status = 200;
    private Integer errorCode;
    private String errorMessage;
    private String lang;
    private Object response;
    private Map<String, Object> ext;
    private String token;
    private Integer code = 0;
    private T data;

    public ResultBean() {
    }

    public ResultBean(Integer status, Integer errorCode, String errorMessage) {
        this.status = status;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ResultBean(ServiceException e) {
        this.errorCode = e.getCode();
        this.errorMessage = e.getMessage();
        this.lang = e.getLang();
    }

    public static ResultBean success(Object obj) {
        ResultBean resultBean = new ResultBean();
        resultBean.setResponse(obj);
        resultBean.setData(obj);
        return resultBean;
    }

    public static <T> ResultBean<T> success() {
        return new ResultBean();
    }

    public static <T> ResultBean<T> successful(T obj) {
        ResultBean resultBean = new ResultBean();
        resultBean.setData(obj);
        resultBean.setResponse(obj);
        return resultBean;
    }

    public static <T> ResultBean<T> success(Integer code, T t) {
        ResultBean result = new ResultBean();
        result.setCode(code);
        result.setData(t);
        result.setResponse(t);
        return result;
    }

    public static <T> ResultBean<T> fail(String msg) {
        ResultBean result = new ResultBean();
        result.setErrorCode(Integer.valueOf(500));
        result.setErrorMessage(msg);
        return result;
    }

    public boolean succeeded() {
        return 0 == this.code;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getLang() {
        return this.lang;
    }

    public Object getResponse() {
        return this.response;
    }

    public Map<String, Object> getExt() {
        return this.ext;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public void setExt(Map<String, Object> ext) {
        this.ext = ext;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultBean)) {
            return false;
        }
        ResultBean other = (ResultBean)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$errorCode = this.getErrorCode();
        Integer other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)this$errorCode).equals(other$errorCode)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        Object this$response = this.getResponse();
        Object other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        Map this$ext = this.getExt();
        Map other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResultBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)$errorCode).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        Object $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        Map $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResultBean(status=" + this.getStatus() + ", errorCode=" + this.getErrorCode() + ", errorMessage=" + this.getErrorMessage() + ", lang=" + this.getLang() + ", response=" + this.getResponse() + ", ext=" + this.getExt() + ", token=" + this.getToken() + ", code=" + this.getCode() + ", data=" + this.getData() + ")";
    }
}

