/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.common.enums;

import com.digiwin.athena.ania.common.enums.CardTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public enum TaskTypeEnum {
    NOTICE(1, "\u901a\u77e5", "\u901a\u77e5", ""),
    CONCERT(2, "\u534f\u5546", "\u5354\u5546", ""),
    COLLECT(3, "\u6536\u96c6", "\u6536\u96c6", ""),
    MEETING(4, "\u4f1a\u8bae\u8bb0\u5f55", "\u6703\u8b70\u8a18\u9304", ""),
    COLLECT_TASK(5, "\u6536\u96c6\u8868\u5355\u4efb\u52a1", "\u6536\u96c6\u8868\u55ae\u4efb\u52d9", ""),
    GP_INPUT(6, "\u8868\u5355\u586b\u62a5", "\u8868\u55ae\u586b\u5831", ""),
    GP_SUBMIT(7, "\u8868\u5355\u7533\u8bf7", "\u8868\u55ae\u7533\u8acb", ""),
    COLLECT_CONFERENCELIST_TASK(8, "\u6536\u96c6\u4f1a\u52a1\u540d\u5355", "\u6536\u96c6\u6703\u52d9\u540d\u55ae", ""),
    CONFERENCE_INFO_CONFIRM_TASK(9, "\u4f1a\u52a1\u4fe1\u606f\u786e\u8ba4", "\u6703\u52d9\u4fe1\u606f\u78ba\u8a8d", ""),
    COLLECT_VISIT_METHODS(10, "\u62dc\u8bbf\u65b9\u5f0f", "\u62dc\u8a2a\u65b9\u5f0f", ""),
    MEAL_VOUCHER_ISSUANCE(11, "\u9910\u5238\u6d3e\u53d1", "\u9910\u5238\u6d3e\u767c", ""),
    CONFERENCE_SIGNIN_TASK(12, "\u6536\u96c6\u7b7e\u5230\u60c5\u51b5", "\u6536\u96c6\u7c3d\u5230\u60c5\u6cc1", ""),
    MEETINGPENDING(13, "\u4f1a\u8bae\u8ffd\u8e2a\u5f85\u529e", "\u6703\u8b70\u8a18\u9304", "\u6703\u8b70\u8ffd\u8e64\u5f85\u8fa6");

    private final int type;
    private final String cn;
    private final String tw;
    private final String en;

    public static boolean isValid(String name) {
        TaskTypeEnum typeEnum = TaskTypeEnum.getTypeEnum((String)name);
        return Objects.nonNull(typeEnum);
    }

    public static TaskTypeEnum getTypeEnum(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        for (TaskTypeEnum type : TaskTypeEnum.values()) {
            if (!type.cn.equals(name) && !type.tw.equals(name)) continue;
            return type;
        }
        return null;
    }

    public static List<String> getCardTypes(List<Integer> taskTypes) {
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isEmpty(taskTypes)) {
            for (CardTypeEnum cardTypeEnum : CardTypeEnum.values()) {
                result.add(cardTypeEnum.getCode());
            }
            return result;
        }
        for (Integer selectTaskType : taskTypes) {
            result.addAll(TaskTypeEnum.getCardTypesByTaskType((Integer)selectTaskType));
        }
        return result;
    }

    private static List<String> getCardTypesByTaskType(Integer selectTaskType) {
        ArrayList<String> cardTypes = new ArrayList<String>();
        for (CardTypeEnum value : CardTypeEnum.values()) {
            if (!value.getTaskType().equals(selectTaskType)) continue;
            cardTypes.add(value.getCode());
        }
        return cardTypes;
    }

    public static String getTaskTypeName(int taskType, String language) {
        for (TaskTypeEnum taskTypeEnum : TaskTypeEnum.values()) {
            if (taskTypeEnum.getType() != taskType) continue;
            if (LocalsEnum.isTw((String)language)) {
                return taskTypeEnum.getTw();
            }
            return taskTypeEnum.getCn();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public String getCn() {
        return this.cn;
    }

    public String getTw() {
        return this.tw;
    }

    public String getEn() {
        return this.en;
    }

    private TaskTypeEnum(int type, String cn, String tw, String en) {
        this.type = type;
        this.cn = cn;
        this.tw = tw;
        this.en = en;
    }
}

