/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="assistance")
public class AssistanceAccountConfig {
    private String account;
    private Map<String, String> customerAccIdMap;

    public String getCustomerAccIdByAssistanceCode(String assistanceCode) {
        if (StringUtils.isNotBlank((CharSequence)assistanceCode)) {
            return (String)this.customerAccIdMap.get(assistanceCode);
        }
        return null;
    }

    public String getAssistanceCodeByCustomerAccId(String customerAccId) {
        for (Map.Entry entry : this.customerAccIdMap.entrySet()) {
            if (!customerAccId.equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public List<String> getAllServiceAccId() {
        return new ArrayList<String>(this.customerAccIdMap.values());
    }

    public List<String> getAllAssistanceCode() {
        ArrayList<String> assistanceCodes = new ArrayList<String>();
        for (Map.Entry entry : this.customerAccIdMap.entrySet()) {
            assistanceCodes.add((String)entry.getKey());
        }
        return assistanceCodes;
    }

    public String getAccount() {
        return this.account;
    }

    public Map<String, String> getCustomerAccIdMap() {
        return this.customerAccIdMap;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public void setCustomerAccIdMap(Map<String, String> customerAccIdMap) {
        this.customerAccIdMap = customerAccIdMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssistanceAccountConfig)) {
            return false;
        }
        AssistanceAccountConfig other = (AssistanceAccountConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        Map this$customerAccIdMap = this.getCustomerAccIdMap();
        Map other$customerAccIdMap = other.getCustomerAccIdMap();
        return !(this$customerAccIdMap == null ? other$customerAccIdMap != null : !((Object)this$customerAccIdMap).equals(other$customerAccIdMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssistanceAccountConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        Map $customerAccIdMap = this.getCustomerAccIdMap();
        result = result * 59 + ($customerAccIdMap == null ? 43 : ((Object)$customerAccIdMap).hashCode());
        return result;
    }

    public String toString() {
        return "AssistanceAccountConfig(account=" + this.getAccount() + ", customerAccIdMap=" + this.getCustomerAccIdMap() + ")";
    }
}

