/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.digiwin.athena.ania.dto.AthenaUserDto;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;

public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateInterceptor.class);
    @Autowired
    private IamHelper iamHelper;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders headers = request.getHeaders();
        AppAuthContext appAuthContext = AppAuthContextHolder.getContext();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        if (!StringUtils.isEmpty((Object)securityToken)) {
            headers.add("security-token", securityToken);
        }
        if (StringUtils.isEmpty((Object)appAuthContext.getProxyToken())) {
            if (authoredUser != null) {
                if (!headers.containsKey((Object)"digi-middleware-auth-user")) {
                    headers.add("digi-middleware-auth-user", authoredUser.getToken());
                }
                if (!headers.containsKey((Object)"token")) {
                    headers.add("token", authoredUser.getToken());
                }
            }
        } else {
            if (!headers.containsKey((Object)"digi-middleware-auth-user")) {
                headers.add("digi-middleware-auth-user", appAuthContext.getProxyToken());
            }
            if (!headers.containsKey((Object)"token")) {
                headers.add("token", appAuthContext.getProxyToken());
            }
        }
        if (!headers.containsKey((Object)"traceId") && MDC.get((String)"traceId") != null) {
            headers.add("traceId", MDC.get((String)"traceId"));
        }
        if (!headers.containsKey((Object)"locale")) {
            headers.add("locale", LocaleContextHolder.getLocale().toString());
        }
        if (!headers.containsKey((Object)"lang")) {
            headers.add("lang", LocaleContextHolder.getLocale().toString());
        }
        if (!headers.containsKey((Object)"routerKey")) {
            String routerKey = MDC.get((String)"routerKey");
            if (!StringUtils.isEmpty((Object)routerKey)) {
                headers.add("routerKey", routerKey);
            } else if (AppAuthContextHolder.getContext().getProxyAuthoredUser() != null) {
                headers.add("routerKey", AppAuthContextHolder.getContext().getProxyAuthoredUser().getTenantId());
            } else if (authoredUser != null) {
                headers.add("routerKey", authoredUser.getTenantId());
            }
        }
        if (!headers.containsKey((Object)"routerKey")) {
            AthenaUserDto user;
            String userToken = headers.getFirst("digi-middleware-auth-user");
            if (StringUtils.isEmpty((Object)userToken)) {
                userToken = headers.getFirst("token");
            }
            if (Objects.nonNull(user = this.iamHelper.getUserInfo(userToken))) {
                headers.add("routerKey", user.getTenantId());
            }
        }
        if (!headers.containsKey((Object)"digi-dap-service-chain-info")) {
            headers.add("digi-dap-service-chain-info", MDC.get((String)"digi-dap-service-chain-info"));
        }
        return execution.execute(request, body);
    }
}

