/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import com.digiwin.athena.ania.util.MdcUtil;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SseInterceptor.class);
    private Function<String, String> getTenantFunction;

    public SseInterceptor(Map<String, Function> functions) {
        this.getTenantFunction = functions.get("routerKey");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        Request.Builder requestBuilder = originalRequest.newBuilder();
        if (null == originalRequest.header("routerKey")) {
            String routerKey = MdcUtil.getRouterKey();
            if (StringUtils.isEmpty((CharSequence)routerKey)) {
                String token = originalRequest.header("digi-middleware-auth-user");
                routerKey = (String)this.getTenantFunction.apply(token);
            }
            requestBuilder.header("routerKey", routerKey);
        }
        Request request = requestBuilder.build();
        return chain.proceed(request);
    }
}

