/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@WebFilter(filterName="webSecurityFilter", urlPatterns={"/v3/api-docs", "/swagger-ui/*", "/actuator/*"})
public class WebSecurityFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WebSecurityFilter.class);
    @Value(value="${rest-url.appToken}")
    private String appToken;
    private static final Set<String> interceptSet = new HashSet();
    private static final Set<String> chainSet = new HashSet();

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String contextPath = request.getContextPath();
        String requestUrl = request.getRequestURI();
        requestUrl = requestUrl.replaceAll("/+", "/");
        if (StrUtil.isNotBlank((CharSequence)contextPath)) {
            requestUrl = requestUrl.substring(contextPath.length());
        }
        if (interceptSet.contains(requestUrl)) {
            this.checkAuth(request);
        }
        if (requestUrl.startsWith("/actuator") && !chainSet.contains(requestUrl)) {
            this.checkAuth(request);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void checkAuth(HttpServletRequest request) {
        String asaToken = request.getParameter("asaToken");
        String referrer = request.getHeader("Referer");
        if (StrUtil.isNotBlank((CharSequence)referrer) && !referrer.contains(this.appToken)) {
            throw BusinessException.create((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
        }
        if (StrUtil.isBlank((CharSequence)referrer) && (StrUtil.isBlank((CharSequence)asaToken) || !asaToken.equals(this.appToken))) {
            throw BusinessException.create((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
        }
    }

    static {
        interceptSet.add("/v3/api-docs");
        interceptSet.add("/swagger-ui.html");
        interceptSet.add("/swagger-ui/*");
        chainSet.add("/actuator/health");
        chainSet.add("/actuator/healthcheck");
        chainSet.add("/actuator/prometheus");
    }
}

