/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.configuration.mqtt;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.configuration.mqtt.MqttProperties;
import com.digiwin.athena.ania.util.IdSnowflake;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqttClientFactory {
    private static final Logger log = LoggerFactory.getLogger(MqttClientFactory.class);

    @Bean
    public MqttClient mqttClient(MqttProperties props) throws MqttException {
        if (StrUtil.isBlank((CharSequence)props.getServerName())) {
            return null;
        }
        log.info("Mqtt broker is {}", (Object)props.getBroker());
        MqttClient client = new MqttClient(props.getBroker(), props.getClientId() + IdSnowflake.snowflakeIdStr(), (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setUserName(props.getUsername());
        options.setPassword(props.getPassword().toCharArray());
        options.setAutomaticReconnect(true);
        options.setMaxInflight(300);
        client.connect(options);
        return client;
    }
}

