/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ania.common.BizException;
import com.digiwin.athena.ania.common.ErrorCodeConstant;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.dto.HisConversationMessageDto;
import com.digiwin.athena.ania.entity.im.ImSendMsgResult;
import com.digiwin.athena.ania.service.message.HisConversationMessageService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ania/gpt/message"})
public class HisAssistantMessageController {
    private static final Logger log = LoggerFactory.getLogger(HisAssistantMessageController.class);
    @Resource
    private HisConversationMessageService hisConversationMessageService;
    @Resource
    private MessageUtils messageUtils;

    @PostMapping(value={"/dialogue/latelyMessage"})
    public ResultBean<List<HisConversationMessageDto>> latelyMessage(@RequestBody Map<String, Object> mapParam, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        int num = MapUtils.getIntValue(mapParam, (Object)"num", (int)10);
        if (num > 50) {
            log.error("\u67e5\u8be2\u5386\u53f2\u6d88\u606f\u8bf7\u67e5\u8be2\u66f4\u5c11\u6761\u6570");
            throw BizException.getBizException((Integer)ErrorCodeConstant.ERROR_MAX_MESSAGE, (String)this.messageUtils.getMessage("error.max.message"), (String)LocaleContextHolder.getLocale().toString());
        }
        try {
            return ResultBean.successful((Object)this.hisConversationMessageService.latelyMessage(mapParam, user, num));
        }
        catch (Exception ex) {
            log.error("latelyMessage is error", (Throwable)ex);
            return new ResultBean(Integer.valueOf(414), Integer.valueOf(414), ex.getMessage());
        }
    }

    @PostMapping(value={"/dialogue/queryMessageById"})
    public ResultBean<List<HisConversationMessageDto>> queryMessageById(@RequestBody Map<String, Object> mapParam, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        try {
            List msgidServers = (List)mapParam.get("msgidServers");
            if (CollectionUtils.isEmpty((Collection)msgidServers)) {
                throw BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            if (msgidServers.size() > 50) {
                throw BizException.getDefaultBizException((Integer)ErrorCodeConstant.ERROR_MAX_MESSAGE, (String)this.messageUtils.getMessage("error.max.message"));
            }
            return ResultBean.successful((Object)this.hisConversationMessageService.queryMessagesByIds(msgidServers, user));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new ResultBean(Integer.valueOf(414), Integer.valueOf(414), ex.getMessage());
        }
    }

    @PostMapping(value={"/sendMessage"})
    public ResultBean<ImSendMsgResult> sendMessage(@RequestBody Map<String, Object> mapParam, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        log.info("HisAssistantMessageController.sendMessage mapParam:{}", (Object)JSON.toJSONString(mapParam));
        return this.hisConversationMessageService.sendMessage(mapParam, authoredUser);
    }
}

