/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import com.digiwin.athena.ania.knowledge.server.dto.HisAssistantChatDto;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.service.chat.SseEmitterHisChatComponent;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ania/history/assistant"})
public class HistoryAssistantController {
    private static final Logger log = LoggerFactory.getLogger(HistoryAssistantController.class);
    @Resource
    private SseEmitterHisChatComponent sseEmitterHisChatComponent;

    @PostMapping(value={"/chat"}, produces={"application/json"})
    public Object chat(@RequestBody(required=false) HisAssistantChatDto question, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        log.info("HistoryAssistantController.chat: {}", (Object)BaseUseUtils.toJsonString((Object)question));
        try {
            SseEventParams sseEventParams = new SseEventParams();
            String language = LanguageUtils.processSseLanguage();
            sseEventParams.setLanguage(language);
            sseEventParams.setQuestion(question);
            sseEventParams.setUser(authoredUser);
            sseEventParams.setTraceId(MdcUtil.getPtxOrTraceId());
            return this.sseEmitterHisChatComponent.chatAction(sseEventParams);
        }
        catch (BusinessException e) {
            log.error("HistoryAssistantController.chat is BusinessException", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getDescription());
        }
        catch (Exception e) {
            log.error("HistoryAssistantController.chat is error", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"An error occurred while processing your request");
        }
    }
}

