/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.BizException;
import com.digiwin.athena.ania.common.ErrorCodeConstant;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.configuration.YunXinConfig;
import com.digiwin.athena.ania.dto.ImConversationMsgDto;
import com.digiwin.athena.ania.dto.agora.ReceiveMessageDTO;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.entity.im.ImSessionMsgLog;
import com.digiwin.athena.ania.entity.im.ImSingleChatDelete;
import com.digiwin.athena.ania.entity.im.ImSingleChatQuery;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.YunXinImHelper;
import com.digiwin.athena.ania.mapper.mongo.MessageMongoMapper;
import com.digiwin.athena.ania.service.message.HisConversationMessageService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.ImCheckSumBuilder;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/gpt/message"})
public class MessageController {
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Resource
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private YunXinConfig yunXinConfig;
    @Autowired
    private YunXinImHelper yunXinImHelper;
    @Resource
    private MessageUtils messageUtils;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Resource
    private HisConversationMessageService hisConversationMessageService;
    @Value(value="${yunxin.ccSwitch:true}")
    private boolean ccSwitch;
    @Autowired
    private MessageMongoMapper messageMongoMapper;

    @GetMapping(value={"/im/delete/message"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="t", value="t", required=true, dataType="String", paramType="Header")})
    public JSONObject deleteMessage(String accId, int num, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        ArrayList<ImSessionMsgLog> deleteList = new ArrayList<ImSessionMsgLog>();
        try {
            String customerAccId = this.yunXinConfig.getCustomerAccId();
            ImSingleChatQuery query = new ImSingleChatQuery();
            query.setFrom(accId);
            query.setTo(customerAccId);
            query.setReverse(Boolean.valueOf(false));
            if (num > 100) {
                query.setLimit(100);
            } else if (num < 1) {
                query.setLimit(1);
            } else {
                query.setLimit(num);
            }
            query.setBeginTime(0L);
            query.setEndTime(System.currentTimeMillis());
            List imSessionMsgLogs = this.yunXinImHelper.singleChatQuery(query);
            if (CollectionUtils.isEmpty((Collection)imSessionMsgLogs)) {
                log.info("====\u804a\u5929\u8bb0\u5f55\u4e3a\u7a7a,accId:{}", (Object)accId);
            }
            for (ImSessionMsgLog log : imSessionMsgLogs) {
                String to = Objects.equals(log.getFrom(), accId) ? customerAccId : accId;
                ImSingleChatDelete delete = new ImSingleChatDelete();
                delete.setFrom(log.getFrom());
                delete.setTo(to);
                delete.setMsgId(log.getMsgid());
                delete.setMsgSendTime(log.getSendtime());
                this.yunXinImHelper.singleChatDelete(delete);
                deleteList.add(log);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JSONObject().fluentPut("result", deleteList);
    }

    @PostMapping(value={"/dialogue/receive"})
    public JSONObject receive(HttpServletRequest request) {
        log.debug("ptxid:");
        log.info("\u8c03\u7528\u94fe\u4fe1\u606f:{}", (Object)MDC.get((String)"PtxId"));
        if (this.ccSwitch) {
            JSONObject result = new JSONObject();
            try {
                String requestBody = this.getRequestBody(request, Boolean.valueOf(false));
                log.info("MessageController.receive requestBody:{}", (Object)requestBody);
                if (StringUtils.isNotBlank((CharSequence)requestBody)) {
                    ImConversationMsgDto message = (ImConversationMsgDto)JSON.parseObject((String)requestBody, ImConversationMsgDto.class);
                    log.info("MessageController.receive message:{}", (Object)message);
                    HttpHeaders headers = new HttpHeaders();
                    if (StringUtils.isNotBlank((CharSequence)message.getExt())) {
                        Map extMap = (Map)JSONUtil.toBean((String)message.getExt(), Map.class);
                        headers = new HttpHeaders();
                        if (extMap.containsKey("routerKey")) {
                            String routerKey = String.valueOf(extMap.get("routerKey"));
                            headers.add("routerKey", routerKey);
                        }
                        if (extMap.containsKey("token")) {
                            String authToken = String.valueOf(extMap.get("token"));
                            headers.add("token", authToken);
                        }
                    }
                    HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
                    headers.setContentType(MediaType.APPLICATION_JSON);
                    log.info("MessageController.receive entity:{}", (Object)JSONObject.toJSONString((Object)entity));
                    ResponseEntity reqResult = this.restTemplate.postForEntity(this.envProperties.getAniaUri() + "/gpt/message/receiveYXCCMsg", (Object)entity, String.class, new Object[0]);
                    log.info("MessageController.receive reqResult:{}", (Object)JSONObject.toJSONString((Object)reqResult));
                }
                result.put("code", (Object)200);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                result.put("code", (Object)414);
            }
            return result;
        }
        log.info("\u4e91\u4fe1 \u6d88\u606f\u6284\u9001\u5df2\u5173\u95ed");
        return null;
    }

    @PostMapping(value={"/receiveYXCCMsg"})
    public JSONObject receiveYXCCMsg(@RequestBody JSONObject requestBody) {
        JSONObject result = new JSONObject();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("messageStr", JSONObject.toJSONString((Object)requestBody));
            messageMap.put("context", JSONObject.toJSONString((Object)AppAuthContextHolder.getContext()));
            paramMap.put("message", JSONObject.toJSONString(messageMap));
            paramMap.put("amqp_deliveryTag", new Long(1L));
            this.rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
            this.rabbitTemplate.convertAndSend(this.rabbitTemplate.getExchange(), this.yunXinConfig.getMsgQueueName(), paramMap, new CorrelationData(UUID.randomUUID().toString()));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            result.put("code", (Object)414);
        }
        return result;
    }

    @PostMapping(value={"/receiveAgora"})
    public JSONObject receiveAgora(@RequestBody ReceiveMessageDTO message) {
        if (this.ccSwitch) {
            JSONObject result = new JSONObject();
            try {
                if (message.getPayload().getExt().get("appName") != null && "ania".equals(message.getPayload().getExt().get("appName"))) {
                    String messageStr = JSONObject.toJSONString((Object)message);
                    log.info("MessageController.receiveAgora msg:{}", (Object)messageStr);
                    HttpHeaders headers = new HttpHeaders();
                    HttpEntity entity = null;
                    if (Objects.nonNull(message.getPayload()) && Objects.nonNull(message.getPayload().getExt())) {
                        headers = new HttpHeaders();
                        if (message.getPayload().getExt().containsKey("routerKey")) {
                            String routerKey = String.valueOf(message.getPayload().getExt().get("routerKey"));
                            headers.add("routerKey", routerKey);
                        }
                        if (message.getPayload().getExt().containsKey("token")) {
                            String authToken = String.valueOf(message.getPayload().getExt().get("token"));
                            headers.add("token", authToken);
                        }
                    }
                    entity = new HttpEntity((Object)message, (MultiValueMap)headers);
                    headers.setContentType(MediaType.APPLICATION_JSON);
                    log.info("MessageController.receiveAgora entity:{}", (Object)JSONObject.toJSONString((Object)entity));
                    ResponseEntity reqResult = this.restTemplate.postForEntity(this.envProperties.getAniaUri() + "/gpt/message/receiveAgoraCCMsg", (Object)entity, String.class, new Object[0]);
                    log.info("MessageController.receiveAgora reqResult:{}", (Object)JSONObject.toJSONString((Object)reqResult));
                }
                result.put("code", (Object)200);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                result.put("code", (Object)414);
            }
            return result;
        }
        log.info("agora \u6d88\u606f\u6284\u9001\u5df2\u5173\u95ed");
        return null;
    }

    @PostMapping(value={"/receiveAgoraCCMsg"})
    public ResultBean receiveAgoraCCMsg(@RequestBody ReceiveMessageDTO message) {
        try {
            if (message.getPayload().getExt().get("appName") != null && "ania".equals(message.getPayload().getExt().get("appName"))) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                HashMap<String, String> messageMap = new HashMap<String, String>();
                messageMap.put("messageStr", JSONObject.toJSONString((Object)message));
                messageMap.put("context", JSONObject.toJSONString((Object)AppAuthContextHolder.getContext()));
                paramMap.put("message", JSONObject.toJSONString(messageMap));
                paramMap.put("amqp_deliveryTag", new Long(1L));
                this.rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
                this.rabbitTemplate.convertAndSend(this.rabbitTemplate.getExchange(), this.yunXinConfig.getMsgQueueName(), paramMap, new CorrelationData(UUID.randomUUID().toString()));
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new ResultBean(Integer.valueOf(500), Integer.valueOf(500), "");
        }
        return ResultBean.success(null);
    }

    @PostMapping(value={"/dialogue/receiveOpenFire/message/plugin/chat"})
    public JSONObject receiveOpenFire(@RequestBody String postData) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        log.info("Received POST data: " + postData);
        JSONObject result = new JSONObject();
        try {
            log.info("MessageController.receiveOpenFire postData:{}", (Object)postData);
            if (StringUtils.isNotBlank((CharSequence)postData)) {
                JSONObject message = (JSONObject)JSON.parseObject((String)postData, JSONObject.class);
                log.info("MessageController.receiveOpenFire message:{}", (Object)message);
                HttpHeaders headers = new HttpHeaders();
                if (Objects.nonNull(message.getString("msgExt"))) {
                    JSONObject extMap = new JSONObject();
                    extMap = message.getString("msgExt").startsWith("\"") ? JSONObject.parseObject((String)message.getString("msgExt").substring(1, message.getString("msgExt").length() - 1).replace("\\", "")) : JSONObject.parseObject((String)message.getString("msgExt"));
                    headers = new HttpHeaders();
                    if (extMap.containsKey((Object)"routerKey")) {
                        String routerKey = String.valueOf(extMap.get((Object)"routerKey"));
                        headers.add("routerKey", routerKey);
                    }
                    if (extMap.containsKey((Object)"token")) {
                        String authToken = String.valueOf(extMap.get((Object)"token"));
                        headers.add("token", authToken);
                    }
                }
                HttpEntity entity = new HttpEntity((Object)postData, (MultiValueMap)headers);
                headers.setContentType(MediaType.APPLICATION_JSON);
                log.info("MessageController.receiveOpenFire entity:{}", (Object)JSONObject.toJSONString((Object)entity));
                headers.setContentType(MediaType.APPLICATION_JSON);
                log.info("MessageController.receive entity:{}", (Object)JSONObject.toJSONString((Object)entity));
                ResponseEntity reqResult = this.restTemplate.postForEntity(this.envProperties.getAniaUri() + "/gpt/message/receiveYXCCMsg", (Object)entity, String.class, new Object[0]);
                log.info("MessageController.receive reqResult:{}", (Object)JSONObject.toJSONString((Object)reqResult));
            }
            result.put("code", (Object)200);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            result.put("code", (Object)414);
        }
        stopWatch.stop();
        log.info("\u8017\u65f6\uff1a{}", (Object)stopWatch.getTotalTimeSeconds());
        return result;
    }

    @PostMapping(value={"/dialogue/latelyMessage"})
    public ResultBean latelyMessage(@RequestBody Map<String, Object> mapParam, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        Integer num = (Integer)mapParam.get("num");
        if (num > 50) {
            log.error("\u67e5\u8be2\u5386\u53f2\u6d88\u606f\u8bf7\u67e5\u8be2\u66f4\u5c11\u6761\u6570");
            throw BizException.getBizException((Integer)ErrorCodeConstant.ERROR_MAX_MESSAGE, (String)this.messageUtils.getMessage("error.max.message"), (String)LocaleContextHolder.getLocale().toString());
        }
        try {
            return ResultBean.success((Integer)0, (Object)this.hisConversationMessageService.latelyMessage(mapParam, user, num.intValue()));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new ResultBean(Integer.valueOf(414), Integer.valueOf(414), ex.getMessage());
        }
    }

    @PostMapping(value={"/dialogue/queryMessageById"})
    public ResultBean queryMessageById(@RequestBody Map mapParam, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        try {
            List msgidServers = (List)mapParam.get("msgidServers");
            if (CollectionUtils.isEmpty((Collection)msgidServers)) {
                throw BizException.getDefaultBizException((Integer)ErrorCodeConstant.PARAM_MISSING_ERROR, (String)this.messageUtils.getMessage("error.message.common.param-missing"));
            }
            if (msgidServers.size() > 50) {
                throw BizException.getDefaultBizException((Integer)ErrorCodeConstant.ERROR_MAX_MESSAGE, (String)this.messageUtils.getMessage("error.max.message"));
            }
            return ResultBean.successful((Object)this.hisConversationMessageService.queryMessagesByIds(msgidServers, user));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return new ResultBean(Integer.valueOf(414), Integer.valueOf(414), ex.getMessage());
        }
    }

    @PostMapping(value={"/sendMessage"})
    public ResultBean sendMessage(@RequestBody Map mapParam, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser, HttpServletRequest request) {
        log.info("HisAssistantMessageController.sendMessage mapParam:{}", (Object)JSON.toJSONString((Object)mapParam));
        return this.hisConversationMessageService.sendMessage(mapParam, authoredUser);
    }

    @PostMapping(value={"/testAddImMessageLogs"})
    public ResultBean testAddImMessageLogs(@RequestBody Map mapParam, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        int num = Integer.valueOf(mapParam.get("num").toString());
        ImMessageLog imMessageLog = new ImMessageLog();
        imMessageLog.setFromAccount("pressure_102");
        imMessageLog.setFromUserId("qcuser007");
        JSONObject msgBody = new JSONObject();
        msgBody.put("dmcId", (Object)"0800ad7d-dd73-4529-b593-431247ea4b25");
        msgBody.put("msgType", (Object)"FILE");
        msgBody.put("type", (Object)"reply");
        msgBody.put("content", (Object)"\u91d1\u96e8\u4e13\u6848\u6210\u679c\u5c55\u793a.docx");
        msgBody.put("dmcId", (Object)"0800ad7d-dd73-4529-b593-431247ea4b25");
        msgBody.put("jjj", (Object)"346457654745634");
        msgBody.put("jjjjs", (Object)"\u4e2d\u534e\u6c11\u65cf\u4f1f\u5927\u590d\u5174");
        imMessageLog.setMsgBody(msgBody);
        imMessageLog.setMsgExt(msgBody);
        imMessageLog.setMsgidClient("d41c108c-fb88-4cc2-9286-ec0d7e80a4f6");
        imMessageLog.setMsgidServer("d41c108c-fb88-4cc2-9286-ec0d7e80a4f6");
        imMessageLog.setToAccount("paas_11813");
        imMessageLog.setMsgType("CUSTOM");
        for (int i = 0; i < num; ++i) {
            imMessageLog.setMsgTimestamp(Long.valueOf(new Date().getTime()));
            this.messageMongoMapper.message(imMessageLog);
        }
        return ResultBean.success(null);
    }

    private byte[] readBody(HttpServletRequest request) throws IOException {
        if (request.getContentLength() > 0) {
            byte[] body = new byte[request.getContentLength()];
            IOUtils.readFully((InputStream)request.getInputStream(), (byte[])body);
            return body;
        }
        return ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    private String getRequestBody(HttpServletRequest request, Boolean checked) throws IOException {
        byte[] body = this.readBody(request);
        if (ArrayUtils.isEmpty((byte[])body)) {
            return null;
        }
        String requestBody = new String(body, StandardCharsets.UTF_8);
        if (Objects.equals(Boolean.TRUE, checked)) {
            String curTime = request.getHeader("CurTime");
            String verifyMD5 = ImCheckSumBuilder.getMD5((String)requestBody);
            String verifyChecksum = ImCheckSumBuilder.getCheckSum((String)"", (String)verifyMD5, (String)curTime);
            String oldCheckSum = request.getHeader("CheckSum");
            BaseUseUtils.businessException((!Objects.equals(oldCheckSum, verifyChecksum) ? 1 : 0) != 0, (String)"\u4e0d\u662f\u539f\u59cb\u6d88\u606f");
        }
        return requestBody;
    }
}

