/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller.conversation;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.dto.ConversationReceiveDto;
import com.digiwin.athena.ania.dto.conversation.ChatMessageQueryDto;
import com.digiwin.athena.ania.dto.conversation.ConversationEventDto;
import com.digiwin.athena.ania.dto.conversation.ConversationMsgListVo;
import com.digiwin.athena.ania.dto.conversation.ConversationMsgQueryDto;
import com.digiwin.athena.ania.dto.conversation.ConversationReadDto;
import com.digiwin.athena.ania.dto.conversation.ConversationSearchDto;
import com.digiwin.athena.ania.dto.conversation.MessageQueryDto;
import com.digiwin.athena.ania.dto.conversation.MessageSearchLatelyDto;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.service.conversation.ConversationFeedBackService;
import com.digiwin.athena.ania.service.conversation.ConversationMessageService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.ania.service.message.ConversationMessageSearchService;
import com.digiwin.athena.ania.vo.ChatMessageListVo;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ania/assistant/message"})
public class ConversationMessageController {
    private static final Logger log = LoggerFactory.getLogger(ConversationMessageController.class);
    @Resource
    private ConversationService conversationService;
    @Resource
    private ConversationFeedBackService conversationFeedBackService;
    @Resource
    private ConversationMessageSearchService conversationMessageSearchService;
    @Resource
    private ConversationMessageService conversationMessageService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u5bf9\u8bdd\u6d88\u606f(\u63d0\u4f9b\u7ed9\u5916\u90e8\u4f7f\u7528)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<ConversationMsgListVo> list(@Validated @RequestBody ConversationMsgQueryDto queryDto) {
        return ResultBean.success((Object)this.conversationMessageService.list(queryDto));
    }

    @PostMapping(value={"/scroll"})
    @ApiOperation(value="\u83b7\u53d6\u5bf9\u8bdd\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<ChatMessageListVo> scroll(@RequestBody(required=false) ChatMessageQueryDto messageQuery, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        log.info("ConversationMessageController.scroll.start: {}", (Object)JSON.toJSONString((Object)messageQuery));
        ResultBean result = this.conversationMessageService.queryMessage(messageQuery, authoredUser);
        log.info("ConversationMessageController.scroll.end");
        return result;
    }

    @PostMapping(value={"/getByMessageIds"})
    @ApiOperation(value="\u6279\u91cf\u83b7\u53d6\u5bf9\u8bdd\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<ChatMessageListVo> getByMessageIds(@RequestBody(required=false) MessageQueryDto messageQuery, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        return ResultBean.success((Object)this.conversationMessageService.queryMessage(messageQuery, authoredUser));
    }

    @PostMapping(value={"/assess"})
    @ApiOperation(value="\u5bf9\u8bdd\u56de\u590d\u6d88\u606f\u8bc4\u4ef7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean assess() {
        return ResultBean.success();
    }

    @PostMapping(value={"/notice"})
    @ApiOperation(value="\u901a\u77e5\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean notice() {
        return ResultBean.success();
    }

    @PostMapping(value={"/report"})
    @ApiOperation(value="\u70b9\u8d5e/\u70b9\u8e29/\u53d6\u6d88\u70b9\u8d5e/\u53d6\u6d88\u70b9\u8e29")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean report(@Validated @RequestBody ConversationEventDto dto) {
        this.conversationFeedBackService.report(dto);
        return ResultBean.success();
    }

    @PostMapping(value={"/send"})
    @ApiOperation(value="\u63a8\u9001\u5bf9\u8bdd\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<ConversationMessage> add(@Validated @RequestBody ConversationReceiveDto dto) {
        log.info("ConversationMessageController.add.start: {}", (Object)JSON.toJSONString((Object)dto));
        ConversationMessage message = this.conversationMessageService.conversationReceive(dto);
        log.info("ConversationMessageController.add.end");
        return ResultBean.success((Integer)0, (Object)message);
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u63a8\u9001\u6d88\u606f\u6a21\u7cca\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean messageSearch(@RequestBody ConversationSearchDto dto) {
        return ResultBean.success((Object)this.conversationMessageSearchService.search(dto));
    }

    @PostMapping(value={"/read"})
    @ApiOperation(value="\u5df2\u8bfb\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean<Boolean> read(@Validated @RequestBody ConversationReadDto dto, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser authoredUser) {
        log.info("conversation.message.read dto:{},", (Object)JSONUtil.toJsonStr((Object)dto));
        return ResultBean.successful((Object)this.conversationService.read(dto, authoredUser));
    }

    @PostMapping(value={"/search/lately"})
    @ApiOperation(value="\u63a8\u9001\u6d88\u606f\u6a21\u7cca\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="authToken", value="authToken", required=true, dataType="String", paramType="Header")})
    public ResultBean latelySearchMessage(@RequestBody MessageSearchLatelyDto dto) {
        return ResultBean.success((Object)this.conversationMessageSearchService.latelySearchMessage(dto));
    }
}

