/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.controller.router;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="router")
@RequestMapping(value={"/ania/router"})
public class RouterController {
    private static final Logger log = LoggerFactory.getLogger(RouterController.class);
    @Autowired
    private EnvProperties envProperties;
    @Resource
    private IamHelper iamHelper;
    private static final String REDIRECT_LOGIN_URL_TEMPLATE = "%s?token=%s&channelSource=%s&sourceType=%s";
    private static final String MOBILE_REDIRECT_URL_TEMPLATE = "%s?token=%s";
    private static final String HOME_PAGE_REDIRECT_TEMPLATE = "%s";

    @Operation(method="routingDistribution", description="\u8def\u7531\u5206\u53d1")
    @GetMapping(value={"/routingDistribution"})
    public ResponseEntity<?> routingJudgment(HttpServletRequest request, String code, String assistantCode, String appId, String tenantId, HttpServletResponse response) throws IOException {
        log.info("RouterController.routingJudgment.param code:{},tenantId:{},appId:{}", new Object[]{code, tenantId, appId});
        String userAgent = request.getHeader("User-Agent");
        String requestUrl = String.valueOf(request.getRequestURL());
        request.getParameter("userId");
        if (userAgent != null && (userAgent.contains("Windows") || userAgent.contains("Macintosh"))) {
            this.handlePcLogin(request, code, tenantId, appId, assistantCode, response);
        } else if (userAgent != null && userAgent.contains("Mobile")) {
            String url = this.handleMobileTask(request, code, tenantId, appId, assistantCode, response);
            response.sendRedirect(url);
        }
        return null;
    }

    private ResponseEntity<?> handlePcLogin(HttpServletRequest request, String code, String tenantId, String appId, String assistantCode, HttpServletResponse response) throws IOException {
        String token;
        ResponseEntity respEntity = this.iamHelper.getJsonObjectResponseEntity(code, tenantId, appId);
        if (Objects.nonNull(respEntity) && respEntity.getStatusCode() == HttpStatus.OK && respEntity.getBody() != null && StringUtils.isNotEmpty((String)(token = ((JSONObject)respEntity.getBody()).getString("token")))) {
            String redirectUrl = HttpUtil.urlWithForm((String)String.format(REDIRECT_LOGIN_URL_TEMPLATE, this.envProperties.getAniaWebUri(), token, "nana", "weCom"), (String)request.getQueryString(), (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)false);
            response.sendRedirect(redirectUrl);
            log.info("Authorization successful, redirecting to details.");
            return null;
        }
        this.redirectToHomePage(response, this.envProperties.getAniaWebUri() + "/login/login-error?errorType=2");
        return null;
    }

    private void redirectToHomePage(HttpServletResponse response, String uri) throws IOException {
        String homePageUrl = String.format(HOME_PAGE_REDIRECT_TEMPLATE, uri);
        response.sendRedirect(homePageUrl);
        log.info("Authorization failed, redirecting to home page.");
    }

    private String handleMobileTask(HttpServletRequest request, String code, String tenantId, String appId, String assistantCode, HttpServletResponse response) throws IOException {
        String token;
        ResponseEntity respEntity = this.iamHelper.getJsonObjectResponseEntity(code, tenantId, appId);
        if (respEntity.getStatusCode() == HttpStatus.OK && respEntity.getBody() != null && StringUtils.isNotEmpty((String)(token = ((JSONObject)respEntity.getBody()).getString("token")))) {
            String redirectUrl = String.format(MOBILE_REDIRECT_URL_TEMPLATE, this.envProperties.getMobileUri(), token);
            response.sendRedirect(redirectUrl);
            log.info("Authorization successful, redirecting to details.");
            return null;
        }
        this.redirectToHomePage(response, this.envProperties.getMobileUri());
        return null;
    }
}

