/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.dto.command;

import com.digiwin.athena.ania.common.ResultBean;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;

public class CommandChainDto
implements Serializable {
    @ApiModelProperty(value="\u6307\u4ee4\u94feID")
    private String id;
    @ApiModelProperty(value="\u52a9\u7406ID\u96c6\u5408")
    @NotEmpty(message="Assistant Empty")
    private @NotEmpty(message="Assistant Empty") List<String> assistants;
    @ApiModelProperty(value="\u540d\u79f0")
    @NotBlank(message="Name Blank")
    private @NotBlank(message="Name Blank") String name;
    @ApiModelProperty(value="\u52a9\u7406ID\u96c6\u5408")
    @NotEmpty(message="Commands Empty")
    private @NotEmpty(message="Commands Empty") List<String> commands;

    public ResultBean<?> check() {
        if (this.commands.size() > 20) {
            return ResultBean.fail((String)"\u6307\u4ee4\u6570\u91cf\u8d85\u8fc7\u6700\u592720\u9650\u5236");
        }
        List indexList = this.commands.stream().map(text -> StringUtils.isBlank((CharSequence)text) ? 0 : text.length()).collect(Collectors.toList());
        int minNum = (Integer)Collections.min(indexList);
        if (minNum == 0) {
            return ResultBean.fail((String)"\u5185\u5bb9\u4e3a\u7a7a");
        }
        int maxNum = (Integer)Collections.max(indexList);
        if (maxNum > 50) {
            return ResultBean.fail((String)"\u5185\u5bb9\u8d85\u8fc7\u5b57\u7b26\u957f\u5ea6\u6700\u592750\u9650\u5236");
        }
        List collect = this.commands.stream().distinct().collect(Collectors.toList());
        if (collect.size() != this.commands.size()) {
            return ResultBean.fail((String)"\u5185\u5bb9\u91cd\u590d");
        }
        return ResultBean.success();
    }

    public String getId() {
        return this.id;
    }

    public List<String> getAssistants() {
        return this.assistants;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAssistants(List<String> assistants) {
        this.assistants = assistants;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandChainDto)) {
            return false;
        }
        CommandChainDto other = (CommandChainDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List this$assistants = this.getAssistants();
        List other$assistants = other.getAssistants();
        if (this$assistants == null ? other$assistants != null : !((Object)this$assistants).equals(other$assistants)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$commands = this.getCommands();
        List other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandChainDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List $assistants = this.getAssistants();
        result = result * 59 + ($assistants == null ? 43 : ((Object)$assistants).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    public String toString() {
        return "CommandChainDto(id=" + this.getId() + ", assistants=" + this.getAssistants() + ", name=" + this.getName() + ", commands=" + this.getCommands() + ")";
    }
}

