/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.dto.conversation;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.athena.ania.dto.conversation.ConversationMsgListVo;
import com.digiwin.athena.ania.dto.conversation.ConversationMsgQueryDto;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConversationMsgListVo {
    private List<Message> messages;
    private Boolean hasMore = false;
    private String firstMessageId;
    private String lastMessageId;

    public static ConversationMsgListVo map(ConversationMsgQueryDto dto, List<ConversationMessage> conversationMessages) {
        ConversationMsgListVo vo = new ConversationMsgListVo();
        if (CollectionUtils.isNotEmpty(conversationMessages) && conversationMessages.size() > dto.getLimit()) {
            conversationMessages.remove(dto.getLimit());
            vo.setHasMore(Boolean.valueOf(true));
        }
        if (CollUtil.isNotEmpty(conversationMessages)) {
            ConversationMessage first = conversationMessages.get(0);
            ConversationMessage last = conversationMessages.get(conversationMessages.size() - 1);
            vo.setFirstMessageId(first.getMessageId());
            vo.setLastMessageId(last.getMessageId());
            List messageList = conversationMessages.stream().map(Message::new).collect(Collectors.toList());
            vo.setMessages(messageList);
        }
        return vo;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Boolean getHasMore() {
        return this.hasMore;
    }

    public String getFirstMessageId() {
        return this.firstMessageId;
    }

    public String getLastMessageId() {
        return this.lastMessageId;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public void setFirstMessageId(String firstMessageId) {
        this.firstMessageId = firstMessageId;
    }

    public void setLastMessageId(String lastMessageId) {
        this.lastMessageId = lastMessageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversationMsgListVo)) {
            return false;
        }
        ConversationMsgListVo other = (ConversationMsgListVo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$messages = this.getMessages();
        List other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Boolean this$hasMore = this.getHasMore();
        Boolean other$hasMore = other.getHasMore();
        if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
            return false;
        }
        String this$firstMessageId = this.getFirstMessageId();
        String other$firstMessageId = other.getFirstMessageId();
        if (this$firstMessageId == null ? other$firstMessageId != null : !this$firstMessageId.equals(other$firstMessageId)) {
            return false;
        }
        String this$lastMessageId = this.getLastMessageId();
        String other$lastMessageId = other.getLastMessageId();
        return !(this$lastMessageId == null ? other$lastMessageId != null : !this$lastMessageId.equals(other$lastMessageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversationMsgListVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Boolean $hasMore = this.getHasMore();
        result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
        String $firstMessageId = this.getFirstMessageId();
        result = result * 59 + ($firstMessageId == null ? 43 : $firstMessageId.hashCode());
        String $lastMessageId = this.getLastMessageId();
        result = result * 59 + ($lastMessageId == null ? 43 : $lastMessageId.hashCode());
        return result;
    }

    public String toString() {
        return "ConversationMsgListVo(messages=" + this.getMessages() + ", hasMore=" + this.getHasMore() + ", firstMessageId=" + this.getFirstMessageId() + ", lastMessageId=" + this.getLastMessageId() + ")";
    }
}

