/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.eventbus.agile.scriber;

import com.digiwin.athena.ania.eventbus.agile.event.AgileDataLogEvent;
import com.digiwin.athena.ania.service.agile.AgileDataMessageLogEventService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgileDataLogEventSubscriber {
    private static final Logger log = LoggerFactory.getLogger(AgileDataLogEventSubscriber.class);
    @Autowired
    private AgileDataMessageLogEventService agileDataMessageLogEventService;

    @Subscribe
    public void subscriber(AgileDataLogEvent event) {
        try {
            AppAuthContextHolder.clearContext();
            this.agileDataMessageLogEventService.processLog(event);
        }
        catch (Exception ex) {
            log.error("AgileDataLogEventSubscriber.subscriber error event:{}", (Object)JsonUtils.objectToString((Object)event), (Object)ex);
        }
        finally {
            AppAuthContextHolder.clearContext();
        }
    }
}

