/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.helper.im.ImTypeHandlerStrategy;
import com.digiwin.athena.ania.util.DateUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class AgileDataHelper {
    private static final Logger log = LoggerFactory.getLogger(AgileDataHelper.class);
    private static final String GUIDE_SENTENCE = "\u4f60\u7684\u95ee\u9898\u6570\u636e\u52a9\u7406\u5a1c\u5a1c\u6682\u4e0d\u652f\u6301\u89e3\u51b3\uff0c\u8bf7\u5207\u6362\u5230\u5bf9\u5e94\u52a9\u7406\u518d\u8be2\u95ee";
    private static final String ATZURL = "/api/ai/agileData/snapData/processMessage";
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ImTypeHandlerStrategy imTypeHandlerStrategy;
    @Value(value="${openfire.msgDomain}")
    private String msgDomain;

    public void processMessage(UserMessageActionContext userMessageActionContext) {
        JSONObject msgBody = userMessageActionContext.getImMessageLog().getMsgBody();
        JSONObject msgExt = userMessageActionContext.getImMessageLog().getMsgExt();
        if (msgExt.containsKey((Object)"contentId")) {
            return;
        }
        String msgType = userMessageActionContext.getImMessageLog().getMsgType();
        JSONObject msg = new JSONObject();
        if ("txt".equals(msgType)) {
            msgType = "TEXT";
        }
        if ("custom".equals(msgType)) {
            msgType = "CUSTOM";
        }
        msg.put("msgidServer", (Object)userMessageActionContext.getImMessageLog().getMsgidServer());
        msg.put("msgType", (Object)msgType);
        msg.put("msgBody", (Object)msgBody);
        msg.put("attachInfo", (Object)new JSONObject());
        msg.put("msgExt", (Object)msgExt);
        msg.put("msgTimestamp", (Object)userMessageActionContext.getImMessageLog().getMsgTimestamp());
        msg.put("msgidClient", (Object)userMessageActionContext.getImMessageLog().getMsgidClient());
        msg.put("fromClientType", (Object)userMessageActionContext.getImMessageLog().getFromClientType());
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("digi-middleware-auth-user", msgExt.getString("token"));
        httpHeaders.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HttpEntity httpEntity = new HttpEntity((Object)msg, (MultiValueMap)httpHeaders);
        log.info("\u5f00\u59cb\u8c03\u7528\u654f\u6377\u6570\u636e\u63a8\u9001\u6d88\u606f\u5230\u654f\u6377\u6570\u636e,\u5f00\u59cb\u65f6\u95f4:{}, params:{}", (Object)DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"), (Object)JSON.toJSONString((Object)msg));
        ResponseEntity responseEntity = this.restTemplate.exchange(this.envProperties.getAtzUri() + ATZURL, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, (Map)msg);
        log.info("\u654f\u6377\u6570\u636e\u8fd4\u56de:{}", (Object)JSONObject.toJSONString((Object)responseEntity));
        if (responseEntity.getStatusCodeValue() != 200 || null == responseEntity.getBody()) {
            log.info("\u8c03\u7528\u654f\u6377\u6570\u636e\u63a8\u9001\u6d88\u606f\u5230\u654f\u6377\u6570\u636e\u5931\u8d25 code:{}", (Object)responseEntity.getStatusCodeValue());
            return;
        }
        log.info("\u8c03\u7528\u654f\u6377\u6570\u636e\u63a8\u9001\u6d88\u606f\u5230\u654f\u6377\u6570\u636e\u6210\u529f,\u63a8\u9001\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)DateUtils.getNowTime((String)"yyyy-MM-dd HH:mm:ss"), (Object)JSONObject.toJSONString((Object)responseEntity));
        JSONObject responseBody = (JSONObject)responseEntity.getBody();
        JSONObject map = responseBody.getJSONObject("response");
        String resultType = (String)map.get("resultType");
        if ("NOTSUPPORT".equals(resultType)) {
            String accId = userMessageActionContext.getImMessageLog().getFromAccount();
            this.imTypeHandlerStrategy.handler(this.envProperties.getSupplierType(), accId, (Object)GUIDE_SENTENCE, "1", msgExt, this.msgDomain);
        }
    }
}

