/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.configuration.AgoraConfig;
import com.digiwin.athena.ania.dto.agora.AgoraResponseDTO;
import com.digiwin.athena.ania.dto.agora.SendMessageRequestDTO;
import com.digiwin.athena.ania.helper.im.ImTypeHandler;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AgoraImHelper
implements ImTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(AgoraImHelper.class);
    @Autowired
    private AgoraConfig agoraConfig;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private RestTemplate restTemplate;

    public AgoraResponseDTO buildPostRequest(String url, Map<String, Object> paramMap, String errorMassageKey) {
        url = this.dealUrl(url, paramMap);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)this.setHeaders());
        ResponseEntity responseEntity = null;
        try {
            log.info("agora\u8bf7\u6c42url{},\u53c2\u6570{}", (Object)url, (Object)JSON.toJSONString(paramMap));
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, paramMap);
            log.info("agora\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)responseEntity));
            if (responseEntity.getStatusCodeValue() == 400 && "too many queries".equals(responseEntity.getStatusCode().getReasonPhrase())) {
                throw BusinessException.create((String)"too many queries");
            }
        }
        catch (Exception e) {
            log.error(url + " error\uff01paramMap\uff1a{}\uff0cresponse:{}", (Object)JsonUtils.objectToString(paramMap), (Object)e.getMessage());
            if (e.getMessage().contains("too many queries")) {
                throw BusinessException.create((String)"too many queries");
            }
            throw BusinessException.create((String)this.messageUtils.getMessage(errorMassageKey));
        }
        return (AgoraResponseDTO)responseEntity.getBody();
    }

    public AgoraResponseDTO buildDeleteRequest(String url, Map<String, Object> paramMap, String errorMassageKey) {
        url = this.dealUrl(url, paramMap);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.setHeaders());
        ResponseEntity responseEntity = null;
        try {
            log.info("agora\u8bf7\u6c42url{},\u53c2\u6570{}", (Object)url, (Object)JSON.toJSONString(paramMap));
            responseEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, paramMap);
            log.info("agora\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)responseEntity));
        }
        catch (Exception e) {
            log.error(url + " error\uff01paramMap\uff1a{}\uff0cresponse:{}", (Object)JsonUtils.objectToString(paramMap), (Object)e.getMessage());
            throw BusinessException.create((String)this.messageUtils.getMessage(errorMassageKey));
        }
        return (AgoraResponseDTO)responseEntity.getBody();
    }

    private static String mapToUrlParams(Map<String, Object> params) {
        StringBuilder encodedParams = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (encodedParams.length() > 0) {
                encodedParams.append("&");
            }
            encodedParams.append(entry.getKey()).append("={").append(entry.getKey()).append("}");
        }
        return encodedParams.toString();
    }

    public static void main(String[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("param1", "value1");
        params.put("param2", 1);
        String urlParams = AgoraImHelper.mapToUrlParams(params);
        System.out.println(urlParams);
    }

    public AgoraResponseDTO buildPutRequest(String url, MediaType contentType, Map<String, Object> paramMap, Map<String, Object> urlParam, String errorMassageKey) {
        HttpEntity httpEntity;
        switch (contentType.toString()) {
            case "application/x-www-form-urlencoded": {
                httpEntity = new HttpEntity((MultiValueMap)this.setHeaders(contentType));
                String urlParamStr = AgoraImHelper.mapToUrlParams(paramMap);
                url = url + "?" + urlParamStr;
                break;
            }
            case "application/json": {
                httpEntity = new HttpEntity(paramMap, (MultiValueMap)this.setHeaders(contentType));
                break;
            }
            default: {
                throw new RuntimeException("nonsupport type");
            }
        }
        url = this.dealUrl(url, paramMap);
        urlParam.putAll(paramMap);
        ResponseEntity responseEntity = null;
        try {
            log.info("agora\u8bf7\u6c42url{},\u53c2\u6570{}", (Object)url, (Object)JSON.toJSONString(paramMap));
            responseEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, urlParam);
            log.info("agora\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)responseEntity));
        }
        catch (Exception e) {
            log.error(url + " error\uff01paramMap\uff1a{}\uff0cresponse:{}", (Object)JsonUtils.objectToString(paramMap), (Object)e.getMessage());
            throw BusinessException.create((String)this.messageUtils.getMessage(errorMassageKey));
        }
        return (AgoraResponseDTO)responseEntity.getBody();
    }

    private HttpHeaders setHeaders(MediaType contentType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(contentType);
        headers.set("Accept", "application/json");
        headers.setBearerAuth(RedisUtils.getAppTokenFromRedis());
        return headers;
    }

    public AgoraResponseDTO buildPutRequest(String url, Map<String, Object> paramMap, String errorMassageKey) {
        url = this.dealUrl(url, paramMap);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)this.setHeaders());
        ResponseEntity responseEntity = null;
        try {
            log.info("agora\u8bf7\u6c42url{},\u53c2\u6570{}", (Object)url, (Object)JSON.toJSONString(paramMap));
            responseEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, paramMap);
            log.info("agora\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)responseEntity));
        }
        catch (Exception e) {
            log.error(url + " error\uff01paramMap\uff1a{}\uff0cresponse:{}", (Object)JsonUtils.objectToString(paramMap), (Object)e.getMessage());
            throw BusinessException.create((String)this.messageUtils.getMessage(errorMassageKey));
        }
        return (AgoraResponseDTO)responseEntity.getBody();
    }

    public AgoraResponseDTO buildGetRequest(String url, Map<String, Object> paramMap, String errorMassageKey) {
        url = this.dealUrl(url, paramMap);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)this.setHeaders());
        ResponseEntity responseEntity = null;
        try {
            log.info("agora\u8bf7\u6c42url{},\u53c2\u6570{}", (Object)url, (Object)JSON.toJSONString(paramMap));
            responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, paramMap);
            log.info("agora\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c{}", (Object)JSON.toJSONString((Object)responseEntity));
        }
        catch (Exception e) {
            log.error(url + " error\uff01paramMap\uff1a{}\uff0cresponse:{}", (Object)JsonUtils.objectToString(paramMap), (Object)e.getMessage());
            throw BusinessException.create((String)this.messageUtils.getMessage(errorMassageKey));
        }
        return (AgoraResponseDTO)responseEntity.getBody();
    }

    private HttpHeaders setHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(RedisUtils.getAppTokenFromRedis());
        return headers;
    }

    private String dealUrl(String url, Map<String, Object> paramMap) {
        url = url.replaceAll("\\{host\\}", this.agoraConfig.getHost());
        url = url.replaceAll("\\{org_name\\}", this.agoraConfig.getOrgName());
        if ((url = url.replaceAll("\\{app_name\\}", this.agoraConfig.getAppName())).contains("{group_id}") && paramMap.containsKey("teamId") && null != paramMap.get("teamId")) {
            url = url.replaceAll("\\{group_id\\}", paramMap.get("teamId").toString());
            paramMap.remove("teamId");
        }
        if (url.contains("{members}") && paramMap.containsKey("members") && null != paramMap.get("members")) {
            url = url.replaceAll("\\{members\\}", paramMap.get("members").toString());
            paramMap.remove("members");
        }
        if (url.contains("{username}") && paramMap.containsKey("username") && null != paramMap.get("username")) {
            url = url.replaceAll("\\{username\\}", paramMap.get("username").toString());
            paramMap.remove("username");
        }
        return url;
    }

    public String getImType() {
        return "Agora";
    }

    public ResultBean handler(String accId, Object message, String skillType, JSONObject msgExt, String url) {
        SendMessageRequestDTO sendMessageRequestDTO = null;
        msgExt.fluentPut("skillType", (Object)skillType).fluentPut("imSource", (Object)"AI_ASSISTANT").fluentPut("appName", (Object)"ania");
        if (StringUtils.isNotBlank((CharSequence)this.agoraConfig.getEnv())) {
            msgExt.put(this.agoraConfig.getEnv(), (Object)true);
        }
        HashMap<String, Object> mapBody = new HashMap<String, Object>();
        if (message instanceof JSONObject) {
            String msgType = "custom";
            mapBody.put("customEvent", "custom_event");
            mapBody.put("customExts", new JSONObject().fluentPut("msg", (Object)JSONObject.toJSONString((Object)message)));
            sendMessageRequestDTO = SendMessageRequestDTO.builder().from(MDC.get((String)"serverAccid")).to(accId).type(msgType).ext((Map)msgExt).body(mapBody).build();
        } else {
            String msgType = "txt";
            mapBody.put("msg", message);
            sendMessageRequestDTO = SendMessageRequestDTO.builder().from(MDC.get((String)"serverAccid")).to(accId).type(msgType).ext((Map)msgExt).body(mapBody).build();
        }
        AgoraResponseDTO agoraResponseDTO = this.buildPostRequest("https://{host}/{org_name}/{app_name}/messages/users", (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendMessageRequestDTO)), "");
        JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)agoraResponseDTO.getData()));
        HashMap map = Maps.newHashMap();
        map.put("msgId", MapUtils.getString((Map)data, (Object)accId));
        map.put("msgSendTime", agoraResponseDTO.getTimestamp());
        return ResultBean.success((Object)map);
    }

    public ResultBean handlerNew(String accIdFrom, String accIdTo, Object message, String skillType, JSONObject msgExt) {
        SendMessageRequestDTO sendMessageRequestDTO = null;
        msgExt.fluentPut("skillType", (Object)skillType).fluentPut("imSource", (Object)"AI_ASSISTANT").fluentPut("appName", (Object)"ania");
        if (StringUtils.isNotBlank((CharSequence)this.agoraConfig.getEnv())) {
            msgExt.put(this.agoraConfig.getEnv(), (Object)true);
        }
        HashMap<String, Object> mapBody = new HashMap<String, Object>();
        if (message instanceof JSONObject) {
            String msgType = "custom";
            mapBody.put("customEvent", "custom_event");
            mapBody.put("customExts", new JSONObject().fluentPut("msg", (Object)JSONObject.toJSONString((Object)message)));
            sendMessageRequestDTO = SendMessageRequestDTO.builder().from(accIdFrom).to(accIdTo).type(msgType).ext((Map)msgExt).body(mapBody).build();
        } else {
            String msgType = "txt";
            mapBody.put("msg", message);
            sendMessageRequestDTO = SendMessageRequestDTO.builder().from(accIdFrom).to(accIdTo).type(msgType).ext((Map)msgExt).body(mapBody).build();
        }
        AgoraResponseDTO agoraResponseDTO = this.buildPostRequest("https://{host}/{org_name}/{app_name}/messages/users", (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sendMessageRequestDTO)), "");
        JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)agoraResponseDTO.getData()));
        HashMap map = Maps.newHashMap();
        map.put("msgId", MapUtils.getString((Map)data, (Object)accIdTo));
        map.put("msgSendTime", agoraResponseDTO.getTimestamp());
        return ResultBean.success((Object)map);
    }
}

