/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.dto.FileDTO;
import com.digiwin.athena.ania.dto.FileInfoDTO;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ChatFileHelper {
    private static final Logger log = LoggerFactory.getLogger(ChatFileHelper.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    private static final String CHAT_FILE_SYNC_FILE_URL = "/restful/standard/kmo/document/info/sync/process";
    public static final String CHAT_FILE_QUESTION_URL_V2 = "/restful/standard/kcf/isv/api/v2/qa/chatfile";
    private static final String FILE_DETAIL_BY_FILE_NO = "/restful/standard/kmo/kbs/permission/knowledge/fileNo/detail/get";
    private static final String DMC_PREVIEW_URL_BUCKET_END = "/online/preview/";
    @Resource
    private IamHelper iamHelper;
    @Value(value="${chatFile.digi-kai-api-key}")
    private String digiKaiChatApiKey;

    public void syncFileInfoToChatFile(AuthoredUser authoredUser, String dmcId) {
        String userToken = authoredUser.getToken();
        JSONObject jsonObjectParam = new JSONObject();
        jsonObjectParam.put("data_source", (Object)"athena-ania");
        jsonObjectParam.put("data_type", (Object)"1");
        ArrayList list = Lists.newArrayList();
        JSONObject jsonObjectType = new JSONObject();
        jsonObjectType.put("parent_node_no", (Object)"");
        long id = SnowflakeIdWorker.getInstance().newId();
        jsonObjectType.put("classification_no", (Object)String.valueOf(id));
        jsonObjectType.put("classification_name", (Object)"default");
        list.add(jsonObjectType);
        jsonObjectParam.put("classification_info", (Object)list);
        ArrayList listFileInfo = Lists.newArrayList();
        JSONObject jsonObjectFileInfo = new JSONObject();
        jsonObjectFileInfo.put("database", (Object)this.envProperties.getBucket());
        jsonObjectFileInfo.put("classification_no", (Object)String.valueOf(id));
        jsonObjectFileInfo.put("id", (Object)dmcId);
        ArrayList listDataInfo = Lists.newArrayList();
        JSONObject jsonObjectFileOtherInfo = new JSONObject();
        jsonObjectFileOtherInfo.put("key_word", (Object)"22");
        jsonObjectFileOtherInfo.put("key_value", (Object)"22");
        listDataInfo.add(jsonObjectFileOtherInfo);
        jsonObjectFileInfo.put("data_info", (Object)listDataInfo);
        listFileInfo.add(jsonObjectFileInfo);
        jsonObjectParam.put("file_info", (Object)listFileInfo);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", userToken);
        headers.set("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("digi-kai-api-key", this.digiKaiChatApiKey);
        HttpEntity httpEntitys = new HttpEntity((Object)jsonObjectParam, (MultiValueMap)headers);
        this.restTemplate.exchange(this.envProperties.getKmoUri() + CHAT_FILE_SYNC_FILE_URL, HttpMethod.POST, httpEntitys, JSONObject.class, new HashMap());
    }

    public Map fileDetail(String fileNo, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.set("digi-kai-api-key", this.digiKaiChatApiKey);
        FileDTO dto = new FileDTO();
        FileInfoDTO fileInfoDTO = new FileInfoDTO();
        fileInfoDTO.setFile_no(fileNo);
        dto.setFile_info(fileInfoDTO);
        HttpEntity httpEntityForFileDetail = new HttpEntity((Object)dto, (MultiValueMap)headers);
        ResponseEntity fileDetail = this.restTemplate.exchange(this.envProperties.getKmoUri() + FILE_DETAIL_BY_FILE_NO, HttpMethod.POST, httpEntityForFileDetail, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        JSONObject response = ((JSONObject)fileDetail.getBody()).getJSONObject("response");
        Map data = (Map)response.get((Object)"data");
        String dmcBucket = (String)data.get("dmc_bucket");
        String dmcId = (String)data.get("dmc_id");
        HashMap map = Maps.newHashMap();
        map.put("dmc_bucket", dmcBucket);
        map.put("dmc_id", dmcId);
        return map;
    }

    public JSONObject testQa(UserMessageActionContext userMessageActionContext, String token) throws Exception {
        JSONObject msgBody = userMessageActionContext.getImMessageLog().getMsgBody();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("token", token);
        headers.set("digi-middleware-auth-app", this.envProperties.getAppToken());
        String athenaUserLanguage = this.iamHelper.getAthenaUserLanguage(token, userMessageActionContext.getImMessageLog().getFromUserId());
        headers.set("Accept-Language", athenaUserLanguage.replace("_", "-"));
        headers.set("digi-kai-api-key", this.digiKaiChatApiKey);
        JSONObject jsonObject = new JSONObject();
        jsonObject.fluentPut("stream", (Object)false);
        jsonObject.fluentPut("question", (Object)((String)msgBody.get((Object)"text")));
        jsonObject.fluentPut("historyFlag", (Object)false);
        jsonObject.fluentPut("historyList", null);
        jsonObject.fluentPut("skipFile", (Object)false);
        jsonObject.fluentPut("rootDirectory", (Object)3);
        String language = athenaUserLanguage.equalsIgnoreCase(LocalsEnum.CN.getCode()) ? "\u7b80\u4f53\u4e2d\u6587" : "\u7e41\u9ad4\u4e2d\u6587";
        jsonObject.fluentPut("language", (Object)language);
        HttpEntity httpEntityForFileDetail = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
        log.info("\u5f00\u59cb\u8bf7\u6c42\u77e5\u8bc6\u52a9\u7406\u63a5\u53e3 url:{}", (Object)(this.envProperties.getQaUri() + CHAT_FILE_QUESTION_URL_V2));
        ResponseEntity fileDetail = this.restTemplate.exchange(this.envProperties.getQaUri() + CHAT_FILE_QUESTION_URL_V2, HttpMethod.POST, httpEntityForFileDetail, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        JSONObject response = ((JSONObject)fileDetail.getBody()).getJSONObject("response");
        Map data = (Map)response.get((Object)"data");
        String answer = MapUtils.getString((Map)data, (Object)"answer");
        List mapList = JSONObject.parseArray((String)JSONObject.toJSONString(data.get("file_info")), Map.class);
        JSONObject jsonObjectReturn = new JSONObject();
        jsonObjectReturn.put("msg", (Object)answer);
        jsonObjectReturn.put("showType", (Object)10);
        if (CollectionUtils.isEmpty((Collection)mapList)) {
            jsonObjectReturn.put("showType", (Object)2);
        } else {
            ArrayList listFileInfo = Lists.newArrayList();
            for (Map mapFileInfo : mapList) {
                String dmcId;
                HashMap map = Maps.newHashMap();
                map.put("fileName", MapUtils.getString((Map)mapFileInfo, (Object)"source"));
                String rootDirectory = MapUtils.getString((Map)mapFileInfo, (Object)"root_directory");
                if ("1".equals(rootDirectory) || "2".equals(rootDirectory)) {
                    dmcId = MapUtils.getString((Map)mapFileInfo, (Object)"dmc_id");
                    map.put("id", dmcId);
                    map.put("url", this.envProperties.getDmcPreview() + "KSC" + DMC_PREVIEW_URL_BUCKET_END + dmcId);
                    listFileInfo.add(map);
                }
                if (!rootDirectory.equals("5")) continue;
                dmcId = MapUtils.getString((Map)mapFileInfo, (Object)"dmc_id");
                Map mapBucketAndDmcId = this.fileDetail(dmcId, (String)userMessageActionContext.getImMessageLog().getMsgExt().get((Object)"token"));
                map.put("url", this.envProperties.getDmcPreview() + (String)mapBucketAndDmcId.get("dmc_bucket") + DMC_PREVIEW_URL_BUCKET_END + (String)mapBucketAndDmcId.get("dmc_id"));
                listFileInfo.add(map);
            }
            jsonObjectReturn.put("list", (Object)listFileInfo);
        }
        return jsonObjectReturn;
    }
}

