/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.helper.OpenfireUtil;
import com.digiwin.athena.ania.helper.im.ImTypeHandler;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.id.UuidStanzaIdSource;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OpenFireImHelper
implements ImTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(OpenFireImHelper.class);
    @Value(value="${openfire.msgDomain}")
    private String msgDomain;

    public String getImType() {
        return "Openfire";
    }

    public ResultBean handler(String accId, Object msg, String skillType, JSONObject msgExt, String msgDomain) throws Exception {
        String serverAccId = MDC.get((String)"serverAccid");
        SmackConfiguration.DEBUG = true;
        XMPPTCPConnectionConfiguration configSender = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword((CharSequence)serverAccId, "88888888")).setXmppDomain(msgDomain)).setHost((CharSequence)msgDomain)).setPort(5222)).setConnectTimeout(30000).addEnabledSaslMechanism("PLAIN")).setSecurityMode(ConnectionConfiguration.SecurityMode.disabled)).build();
        XMPPTCPConnection connectionSender = OpenfireUtil.getInstance((XMPPTCPConnectionConfiguration)configSender);
        try {
            connectionSender.setUseStreamManagement(true);
            if (!connectionSender.isConnected()) {
                connectionSender.connect();
                connectionSender.login();
            }
            msgExt.fluentPut("skillType", (Object)skillType).fluentPut("imSource", (Object)"AI_ASSISTANT").toJSONString();
            String msgType = msg instanceof JSONObject ? ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar() : ImConstants.ImMsgTypeEnum.TEXT.getTypeChar();
            StandardExtensionElement element = StandardExtensionElement.builder((String)"ext", (String)"asa").addAttribute("msgType", msgType).addAttribute("msgExt", msgExt.toJSONString()).build();
            String msgSend = null;
            msgSend = msg instanceof JSONObject ? ((JSONObject)msg).toJSONString() : (String)msg;
            Message message = MessageBuilder.buildMessageFrom((Message)((MessageBuilder)((MessageBuilder)MessageBuilder.buildMessage().to((CharSequence)(accId + "@" + msgDomain))).setBody(msgSend).ofType(Message.Type.chat).addExtension((ExtensionElement)element)).build(), (String)UuidStanzaIdSource.INSTANCE.getNewStanzaId()).build();
            connectionSender.sendStanza((Stanza)message);
        }
        catch (Exception e) {
            log.error("\u300cerrMsg:[{}]", (Object)e.getMessage(), (Object)e);
            return new ResultBean(new ServiceException(Integer.valueOf(500), JSONObject.toJSONString((Object)e)));
        }
        return new ResultBean();
    }
}

