/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ServiceException;
import com.digiwin.athena.ania.common.SkcConstants;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.exception.FusionException;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.dto.skc.SkcSessionAddDto;
import com.digiwin.athena.ania.helper.dto.skc.SkcSessionUpdateDto;
import com.digiwin.athena.ania.helper.dto.skc.SkcSkillDelistingDto;
import com.digiwin.athena.ania.helper.dto.skc.SkcSkillPublishDto;
import com.digiwin.athena.ania.helper.dto.skc.command.CreateCommandSetsBrushDto;
import com.digiwin.athena.ania.helper.dto.skc.command.CreateCommandSetsDto;
import com.digiwin.athena.ania.helper.dto.skc.command.DeleteCommandSetsDto;
import com.digiwin.athena.ania.helper.dto.skc.command.ListCommandSetDto;
import com.digiwin.athena.ania.helper.dto.skc.command.UseCommandSetsDto;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SkcHelper {
    private static final Logger log = LoggerFactory.getLogger(SkcHelper.class);
    @Autowired
    private RestTemplate restTemplate;
    @Resource
    private EnvProperties envProperties;
    @Value(value="${chatFile.digi-kai-api-key}")
    private String digiKaiChatApiKey;
    @Value(value="${ania.skc.subscriber-token}")
    private String skcSubscriberToken;
    @Value(value="${ania.skc.enable:true}")
    private boolean skcEnable;

    public com.alibaba.fastjson2.JSONObject queryAgentSessionList(String queryType, int pageNo, int pageSize, String iamToken) {
        if (this.skcEnable) {
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/api/nna/v1/skill/session/list";
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("token", iamToken);
                headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
                headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
                com.alibaba.fastjson2.JSONObject param = new com.alibaba.fastjson2.JSONObject();
                param.put((Object)"queryType", (Object)queryType);
                param.put((Object)"pageNo", (Object)pageNo);
                param.put((Object)"pageSize", (Object)pageSize);
                HttpEntity requestEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
                log.info("queryAgentSessionList#pre, traceId:{}, ptxId:{}, entity:{}", new Object[]{MdcUtil.getTraceId(), MdcUtil.get((String)"PtxId"), JSON.toJSONString((Object)requestEntity)});
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
                log.info("queryAgentSessionList#post, traceId:{}", (Object)MdcUtil.getTraceId());
                if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                    log.error("Skc queryAgentSessionList is fail responseEntity:{}", (Object)response);
                    return null;
                }
                com.alibaba.fastjson2.JSONObject responseBody = (com.alibaba.fastjson2.JSONObject)response.getBody();
                com.alibaba.fastjson2.JSONObject data = responseBody.getJSONObject("response").getJSONObject("data");
                log.info("queryAgentSessionList#result, traceId:{}, total:{}", (Object)MdcUtil.getTraceId(), (Object)data.getIntValue("total"));
                return data;
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u5386\u53f2\u5bf9\u8bdd\u5217\u8868\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            }
        }
        return null;
    }

    public List<Map> queryAgentList(int pageSize, String iamToken, String language) {
        ArrayList<Map> agentList = new ArrayList<Map>();
        if (this.skcEnable) {
            JSONObject data;
            int pageNum = 1;
            while ((data = this.queryAgentList(pageNum, pageSize, iamToken, language)) != null) {
                int total = MapUtils.getIntValue((Map)data, (Object)"total", (int)0);
                List rows = (List)data.get((Object)"rows");
                agentList.addAll(rows);
                if (agentList.size() >= total) break;
                ++pageNum;
            }
        }
        return agentList;
    }

    public JSONObject queryAgentList(int pageNo, int pageSize, String iamToken, String language) {
        if (this.skcEnable) {
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/api/v1/skills/wis/list";
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("token", iamToken);
                headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
                headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
                headers.add("Accept-Language", LocalsEnum.isTw((String)language) ? "zh-TW" : "zh-CN");
                com.alibaba.fastjson2.JSONObject param = new com.alibaba.fastjson2.JSONObject();
                param.put((Object)"publishType", (Object)ListUtil.toList((Object[])new String[]{"public", "scope", "private"}));
                param.put((Object)"pageNo", (Object)pageNo);
                param.put((Object)"pageSize", (Object)pageSize);
                HttpEntity requestEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
                log.info("queryAgentList#pre, traceId:{}, ptxId:{} ,entity:{}", new Object[]{MdcUtil.getTraceId(), MdcUtil.get((String)"PtxId"), JSON.toJSONString((Object)requestEntity)});
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
                log.info("queryAgentList#post, traceId:{}", (Object)MdcUtil.getTraceId());
                if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                    log.error("Skc queryAgentList is fail responseEntity:{}", (Object)response);
                    return null;
                }
                JSONObject responseBody = (JSONObject)response.getBody();
                JSONObject data = responseBody.getJSONObject("response").getJSONObject("data");
                log.info("queryAgentList#result, traceId:{}, total:{}", (Object)MdcUtil.getTraceId(), (Object)data.getIntValue("total"));
                return data;
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u5217\u8868\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            }
        }
        return null;
    }

    public JSONObject queryAgentDetail(String agentCode, String iamToken, String language) {
        if (this.skcEnable) {
            String url = String.format(this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/app/v1/skill/get/%s", agentCode);
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("token", iamToken);
                headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
                headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
                headers.add("Accept-Language", LocalsEnum.isTw((String)language) ? "zh-TW" : "zh-CN");
                HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                log.info("queryAgentDetail#pre, traceId:{}, ptxId:{} ,entity:{}", new Object[]{MdcUtil.getTraceId(), MdcUtil.get((String)"PtxId"), JSON.toJSONString((Object)requestEntity)});
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
                log.info("queryAgentDetail#post, traceId:{}", (Object)MdcUtil.getTraceId());
                if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                    log.error("Skc queryAgentDetail is fail responseEntity:{}", (Object)response);
                    return null;
                }
                JSONObject responseBody = (JSONObject)response.getBody();
                return responseBody.getJSONObject("response").getJSONObject("data");
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u8be6\u60c5\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            }
        }
        return null;
    }

    public Boolean skillPublish(SkcSkillPublishDto dto, String iamToken) {
        try {
            String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
            log.info("skc.skillPublish.securityToken={}", (Object)securityToken);
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/api/nna/v1/skill/publish";
            HttpHeaders headers = this.getHeader(iamToken, securityToken);
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)paramStr, (MultiValueMap)headers);
            log.info("skc.skillPublish.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.skillPublish.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
            return ((com.alibaba.fastjson2.JSONObject)response.getBody()).getJSONObject("response").getBoolean("success");
        }
        catch (Exception e) {
            log.error("skc.skillPublish.exception", (Throwable)e);
            return false;
        }
    }

    public Boolean skillDelisting(SkcSkillDelistingDto dto, String iamToken) {
        try {
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/api/nna/v1/skill/delisting";
            HttpHeaders headers = this.getHeader(iamToken);
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.skillDelisting.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.skillDelisting.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
            return ((com.alibaba.fastjson2.JSONObject)response.getBody()).getJSONObject("response").getBoolean("success");
        }
        catch (Exception e) {
            log.error("skc.skillDelisting.exception", (Throwable)e);
            return false;
        }
    }

    public String sessionAdd(SkcSessionAddDto dto, AppAuthContext appAuthContext) {
        try {
            String iamToken = appAuthContext.getAuthoredUser().getToken();
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/api/nna/v1/skill/session/add";
            HttpHeaders headers = this.getHeader(iamToken, appAuthContext.getSecurityToken());
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.sessionAdd.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.sessionAdd.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
            return ((com.alibaba.fastjson2.JSONObject)response.getBody()).getJSONObject("response").getString("data");
        }
        catch (Exception e) {
            log.error("skc.sessionAdd.exception", (Throwable)e);
            return null;
        }
    }

    public void sessionUpdate(SkcSessionUpdateDto dto, AppAuthContext appAuthContext) {
        try {
            String iamToken = appAuthContext.getAuthoredUser().getToken();
            String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/skc/api/nna/v1/skill/session/update";
            HttpHeaders headers = this.getHeader(iamToken, appAuthContext.getSecurityToken());
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.sessionUpdate.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.sessionUpdate.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
        }
        catch (Exception e) {
            log.error("skc.sessionUpdate.exception", (Throwable)e);
        }
    }

    public void createCommandSet(CreateCommandSetsDto dto, String iamToken) {
        try {
            String url = SkcConstants.getCreateCommandSetUri((Boolean)this.skcEnable, (EnvProperties)this.envProperties);
            HttpHeaders headers = this.getSubscriberHeader(iamToken);
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.createCommandSet.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.createCommandSet.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
        }
        catch (Exception e) {
            log.error("skc.createCommandSet.exception", (Throwable)e);
            throw new FusionException(e.getMessage());
        }
    }

    public void createCommandSetBrush(CreateCommandSetsBrushDto dto, String iamToken) {
        try {
            String url = this.envProperties.getKnowledgeUrl() + "/gateway/api/NNA/restful/standard/nna/isv/v1/commands/sets/create/batch";
            HttpHeaders headers = this.getSubscriberHeader(iamToken);
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.createCommandSetBrush.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.createCommandSetBrush.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
        }
        catch (Exception e) {
            log.error("skc.createCommandSetBrush.exception", (Throwable)e);
        }
    }

    public void deleteCommandSet(DeleteCommandSetsDto dto, String iamToken) {
        try {
            String url = SkcConstants.getDeleteCommandSetUri((Boolean)this.skcEnable, (EnvProperties)this.envProperties);
            HttpHeaders headers = this.getSubscriberHeader(iamToken);
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.deleteCommandSet.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.deleteCommandSet.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
        }
        catch (Exception e) {
            log.error("skc.deleteCommandSet.exception", (Throwable)e);
            throw new FusionException(e.getMessage());
        }
    }

    public com.alibaba.fastjson2.JSONObject listCommandSet(ListCommandSetDto dto, String iamToken) {
        try {
            String url = SkcConstants.getListCommandSetUri((Boolean)this.skcEnable, (EnvProperties)this.envProperties);
            HttpHeaders headers = this.getSubscriberHeader(iamToken);
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.listCommandSet.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.listCommandSet.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
            return ((com.alibaba.fastjson2.JSONObject)response.getBody()).getJSONObject("response").getJSONObject("data");
        }
        catch (Exception e) {
            log.error("skc.listCommandSet.exception", (Throwable)e);
            return new com.alibaba.fastjson2.JSONObject();
        }
    }

    public void useCommandSet(UseCommandSetsDto dto, String iamToken) {
        try {
            String url = SkcConstants.getUseCommandSetUri((Boolean)this.skcEnable, (EnvProperties)this.envProperties);
            HttpHeaders headers = this.getSubscriberHeader(iamToken);
            String paramStr = JSONUtil.toJsonStr((Object)dto);
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            log.info("skc.useCommandSet.request={},token={}", (Object)paramStr, (Object)iamToken);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, com.alibaba.fastjson2.JSONObject.class, new Object[0]);
            log.info("skc.useCommandSet.response={},token={}", (Object)JSONUtil.toJsonStr((Object)response), (Object)iamToken);
            this.checkResponse(response);
        }
        catch (Exception e) {
            log.error("skc.useCommandSet.exception", (Throwable)e);
            throw new FusionException(e.getMessage());
        }
    }

    public HttpHeaders getHeader(String iamToken) {
        return this.getHeader(iamToken, null);
    }

    public HttpHeaders getHeader(String iamToken, String SecurityToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", iamToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
        if (StrUtil.isNotBlank((CharSequence)SecurityToken)) {
            headers.add("security-token", SecurityToken);
        }
        return headers;
    }

    public HttpHeaders getSubscriberHeader(String iamToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", iamToken);
        headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
        headers.add("digi-skc-app-token", this.skcSubscriberToken);
        String securityToken = AppAuthContextHolder.getContext().getSecurityToken();
        if (StrUtil.isNotBlank((CharSequence)securityToken)) {
            headers.add("security-token", securityToken);
        }
        return headers;
    }

    public void checkResponse(ResponseEntity<com.alibaba.fastjson2.JSONObject> response) {
        if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
            com.alibaba.fastjson2.JSONObject body = (com.alibaba.fastjson2.JSONObject)response.getBody();
            String errorMessage = body.getString("errorMessage");
            if (StrUtil.isNotBlank((CharSequence)body.getString("errorMessage"))) {
                throw new ServiceException(errorMessage);
            }
            throw new ServiceException("\u8bf7\u6c42\u5931\u8d25");
        }
        com.alibaba.fastjson2.JSONObject responseJson = ((com.alibaba.fastjson2.JSONObject)response.getBody()).getJSONObject("response");
        if (!responseJson.getBoolean("success").booleanValue()) {
            throw new ServiceException(responseJson.getString("message"));
        }
    }

    public String getLanguage() {
        return this.envProperties.getKnowledgeUrl().contains(".cn") ? LocalsEnum.CN.getCode() : LocalsEnum.TW.getCode();
    }
}

