/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.helper;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.digiwin.athena.ania.env.EnvProperties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WisHelper {
    private static final Logger log = LoggerFactory.getLogger(WisHelper.class);
    @Autowired
    private RestTemplate restTemplate;
    @Resource
    private EnvProperties envProperties;
    @Value(value="${chatFile.digi-kai-api-key}")
    private String digiKaiChatApiKey;

    public JSONObject querySuperSessionInfo(String superSessionId, String iamToken) {
        String url = this.envProperties.getKnowledgeUrl() + String.format("/restful/standard/wis/openapi/v1/super/agent/session/list/%s", superSessionId);
        ResponseEntity response = null;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", iamToken);
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
            JSONObject param = new JSONObject();
            param.put((Object)"page", (Object)1);
            param.put((Object)"pageSize", (Object)20);
            HttpEntity requestEntity = new HttpEntity((Object)param, (MultiValueMap)headers);
            response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                log.info("Wis querySuperSessionInfo is fail responseEntity:{}", (Object)response);
                return null;
            }
            JSONObject responseBody = (JSONObject)response.getBody();
            JSONObject data = responseBody.getJSONObject("response").getJSONObject("data");
            return data;
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u4f1a\u8bdd\u5217\u8868\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            return null;
        }
    }

    public JSONObject querySessionMessageInfo(String sessionId, String iamToken) {
        String url = this.envProperties.getKnowledgeUrl() + "/restful/standard/wis/session/message/list";
        ResponseEntity response = null;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("token", iamToken);
            headers.add("digi-middleware-auth-app", this.envProperties.getAppToken());
            headers.add("digi-kai-api-key", this.digiKaiChatApiKey);
            JSONObject pageBean = new JSONObject();
            pageBean.put((Object)"page", (Object)1);
            pageBean.put((Object)"pageSize", (Object)20);
            JSONArray querys = new JSONArray();
            JSONObject querySession = this.constructQueryInfo("", "EQUAL", "sessionId", "AND", sessionId);
            JSONObject queryActuatorMode1 = this.constructQueryInfo("two.and", "NOT_EQUAL", "actuatorMode", "OR", "executeMultiagent");
            JSONObject queryActuatorMode2 = this.constructQueryInfo("two.and", "IS_NULL", "actuatorMode", "OR", null);
            querys.add((Object)querySession);
            querys.add((Object)queryActuatorMode1);
            querys.add((Object)queryActuatorMode2);
            JSONObject requestParam = new JSONObject();
            requestParam.put((Object)"pageBean", (Object)pageBean);
            requestParam.put((Object)"querys", (Object)querys);
            HttpEntity requestEntity = new HttpEntity((Object)pageBean, (MultiValueMap)headers);
            response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (response.getStatusCodeValue() != 200 || null == response.getBody()) {
                log.info("Wis querySessionMessageInfo is fail responseEntity:{}", (Object)response);
                return null;
            }
            JSONObject responseBody = (JSONObject)response.getBody();
            JSONObject data = responseBody.getJSONObject("response").getJSONObject("data");
            return data;
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u667a\u80fd\u4f53\u4f1a\u8bdd\u6d88\u606f\u5217\u8868\u5931\u8d25\uff0curi:{}\uff0c\u9519\u8bef\u4fe1\u606f", (Object)url, (Object)ex);
            return null;
        }
    }

    private JSONObject constructQueryInfo(String group, String operation, String property, String relation, String value) {
        JSONObject query = new JSONObject();
        query.put((Object)"group", (Object)group);
        query.put((Object)"operation", (Object)operation);
        query.put((Object)"property", (Object)property);
        query.put((Object)"relation", (Object)relation);
        query.put((Object)"value", (Object)value);
        return query;
    }
}

