/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.client.sse;

import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.knowledge.client.sse.CommonEventSourceListener;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.sse.EventSource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class PrivateKnowledgeEventSourceListener
extends CommonEventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(PrivateKnowledgeEventSourceListener.class);

    public PrivateKnowledgeEventSourceListener(SseEventParams sseEventParams, SseEventDataService sseEventDataService, Map<Integer, SseFlow> flowMap) {
        this.sseEventParams = sseEventParams;
        this.sseEventDataService = sseEventDataService;
        this.buildEvent = false;
        this.flowMap = flowMap;
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        this.buildEvent = true;
        log.info("SceneEventSourceListener.onEvent id:{},type:{},data:{}", new Object[]{id, type, data});
        EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent());
        if ("status".equals(type) && "success".equals(data)) {
            log.info("SceneEventSourceListener.onEvent is not need data");
            return;
        }
        if (SseEventlEnum.EventDataMessageEnum.FILE.getMessageType().equals(type)) {
            log.info("SceneEventSourceListener.onEvent file is not need data");
            return;
        }
        EventData.EventMessage eventMessage = new EventData.EventMessage(SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), data);
        eventData.setData(eventMessage);
        this.sseEventDataService.saveEventDataLog(this.sseEventParams, eventData);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)this.sseEventParams.getId());
        String sseEmitterId = this.sseEventParams.getId();
        if (sseEmitter == null) {
            eventSource.cancel();
            KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
            return;
        }
        try {
            SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)eventData);
            SseEventContext.setAnswer((String)sseEmitterId, (EventData)eventData);
        }
        catch (IOException e) {
            log.error("PrivateKnowledgeEventSourceListener.onEvent is error id:{},type:{},data:{}", new Object[]{id, type, data, e});
            KnowledgeContext.removeKnowledgeEventSource((String)sseEmitterId);
            eventSource.cancel();
            this.chatComplete(sseEmitter);
            this.sendAnswerDone(sseEmitter, false);
        }
    }

    protected String defaultErrorMsg(Integer type) {
        String language = this.sseEventParams.getLanguage();
        List actionScenes = this.sseEventParams.getActionScene().getActionScenes();
        String sceneName = "";
        if (CollectionUtils.isNotEmpty((Collection)actionScenes)) {
            sceneName = ((AssistantScene)actionScenes.get(0)).getSceneName(language);
        }
        if (Objects.equals(2, type)) {
            return LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684" + sceneName + "\u77e5\u8bc6\u5e93\u6682\u65e0\u54cd\u5e94\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684" + sceneName + "\u77e5\u8b58\u5eab\u66ab\u7121\u97ff\u61c9\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
        }
        if (Objects.equals(1, type)) {
            return LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684" + sceneName + "\u77e5\u8bc6\u5e93\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684" + sceneName + "\u77e5\u8b58\u5eab\u8fd4\u56de\u6578\u64da\u89e3\u6790\u5f02\u5e38\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
        }
        return LocalsEnum.isCn((String)language) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684" + sceneName + "\u77e5\u8bc6\u5e93\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684" + sceneName + "\u77e5\u8b58\u5eab\u8acb\u6c42\u5931\u6557\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
    }
}

