/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.client.sse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.knowledge.client.sse.SSEMsgHandler;
import com.digiwin.athena.ania.knowledge.context.SseContext;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SSEListener
extends EventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(SSEListener.class);
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private SSEMsgHandler msgHandler;

    public SSEListener(SSEMsgHandler msgHandler) {
        this.msgHandler = msgHandler;
    }

    public void onOpen(EventSource eventSource, Response response) {
        log.info("\u5efa\u7acbsse\u8fde\u63a5...");
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        try {
            if ("finish".equals(type)) {
                log.info("\u8bf7\u6c42\u7ed3\u675f");
            }
            if ("error".equals(type)) {
                log.error("\u6d88\u606f\u7aef\u5f02\u5e38 {} ", (Object)data);
            }
            this.msgHandler.handleMsg(data, type);
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u9519\u8befid:{},data:{},type:{}", new Object[]{id, data, type, e});
            this.countDownLatch.countDown();
            throw new RuntimeException(e);
        }
    }

    public void onClosed(EventSource eventSource) {
        log.info("sse\u8fde\u63a5\u5173\u95ed");
        this.clostSseServerEmitter(eventSource);
        this.countDownLatch.countDown();
    }

    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        log.error("\u4f7f\u7528\u4e8b\u4ef6\u6e90\u65f6\u51fa\u73b0\u5f02\u5e38... [\u5f02\u5e38\u4fe1\u606f]...:{},\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)t), (Object)JSONObject.toJSONString((Object)response));
        this.clostSseServerEmitter(eventSource);
        this.countDownLatch.countDown();
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    private void clostSseServerEmitter(EventSource eventSource) {
        RequestBody request = eventSource.request().body();
        try (Buffer buffer = new Buffer();){
            request.writeTo((BufferedSink)buffer);
            String requestStr = buffer.readString(StandardCharsets.UTF_8);
            JSONObject requestBody = JSON.parseObject((String)requestStr);
            String uniId = requestBody.getString("messageId");
            SseEmitter sseEmitter = SseContext.getSseEmitter((String)uniId);
            if (sseEmitter != null) {
                sseEmitter.complete();
            }
        }
    }
}

