/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.dto.AniaEventLogBuilder;
import com.digiwin.athena.ania.entity.ImMessageLog;
import com.digiwin.athena.ania.helper.AsaHelper;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.HisAssistantChatDto;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.domain.WorkitemInfoData;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.mongo.repository.WorkitemInfoDao;
import com.digiwin.athena.ania.service.message.HisConversationMessageService;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.LmcClientUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import com.digiwin.athena.ania.util.Utils;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AssistantStrategy {
    private static final Logger log = LoggerFactory.getLogger(AssistantStrategy.class);
    @Autowired
    protected AssistantSceneDao assistantSceneDao;
    @Autowired
    protected SseEventDataService sseEventDataService;
    @Autowired
    protected AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    private WorkitemInfoDao workitemInfoDao;
    @Autowired
    private AsaHelper asaHelper;
    @Resource
    protected HisConversationMessageService hisConversationMessageService;
    private static final Map<Integer, AssistantSceneStrategy> ASSISTANT_TEMPLATE = new HashMap();
    protected Map<Integer, SseFlow> flowMap = new HashMap();

    @Autowired
    public void setAssistantSceneDao(List<AssistantSceneStrategy> assistantSceneStrategyList) {
        assistantSceneStrategyList.forEach(sceneStrategy -> ASSISTANT_TEMPLATE.put(sceneStrategy.getAssistantSceneType(), sceneStrategy));
    }

    @Autowired
    public void setFlowMap(List<SseFlow> sseFlows) {
        sseFlows.forEach(flow -> this.flowMap.put(flow.getFlowType().getFlowEventType(), flow));
    }

    public void execute(SseEventParams sseEventParam) {
        this.beforeSceneAgg(sseEventParam);
        if (SseEmitterUtils.isActive((String)sseEventParam.getId())) {
            this.beforeSceneExtend(sseEventParam);
            this.dispatchIntentRequest(sseEventParam);
        }
    }

    public abstract Integer getAssistantSubType();

    public abstract void beforeSceneExtend(SseEventParams var1);

    public void beforeSceneAgg(SseEventParams sseEventParam) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("assistantCode", sseEventParam.getQuestion().getAssistantCode());
        content.put("question", (String)sseEventParam.getQuestion());
        SaveEventLog eventLog = AniaEventLogBuilder.anAniaEventLog().withEventId(sseEventParam.getId()).withEventName("Assistant Question Start").withEventSource(sseEventParam.getTraceId()).withEventType(Integer.valueOf(1)).withRequestUrl(null).withStatus(Integer.valueOf(0)).withTenantId(sseEventParam.getUser().getTenantId()).withTenantName(sseEventParam.getUser().getTenantName()).withUserId(sseEventParam.getUser().getUserId()).withUserName(sseEventParam.getUser().getUserName()).withRequestParam(sseEventParam.getQuestion().getMessage().getText()).withContent(content).build();
        LmcClientUtils.saveEventLog((SaveEventLog)eventLog, (String)sseEventParam.getUser().getToken());
        this.selectSceneHandle(sseEventParam);
    }

    private void dispatchIntentRequest(SseEventParams sseEventParam) {
        if (!SseEmitterUtils.isActive((String)sseEventParam.getId())) {
            return;
        }
        AssistantSceneStrategy assistantSceneStrategy = null;
        if (Objects.nonNull(sseEventParam.getActionScene())) {
            assistantSceneStrategy = (AssistantSceneStrategy)ASSISTANT_TEMPLATE.get(sseEventParam.getActionScene().getType());
        }
        if (Objects.isNull(assistantSceneStrategy)) {
            this.sseEventDataService.sendAnswerDone(sseEventParam, false);
        } else {
            assistantSceneStrategy.dispatchIntentRequest(sseEventParam);
        }
    }

    private void selectSceneHandle(SseEventParams sseEventParam) {
        JSONObject selectScene = null;
        try {
            selectScene = sseEventParam.getQuestion().getSelectScene();
            if (MapUtils.isEmpty((Map)selectScene)) {
                return;
            }
            JSONObject executeContext = selectScene.getJSONObject("executeContext");
            String contentId = MapUtils.getString((Map)executeContext, (Object)"contentId");
            if (StringUtils.isBlank((CharSequence)contentId)) {
                return;
            }
            Optional knowledgeMessage = this.asaKnowledgeMessageDao.findById((Object)contentId);
            if (!knowledgeMessage.isPresent()) {
                return;
            }
            JSONObject scene = selectScene.getJSONObject("value");
            if (MapUtils.isEmpty((Map)selectScene)) {
                return;
            }
            String sceneCode = MapUtils.getString((Map)scene, (Object)"key");
            if (StringUtils.isBlank((CharSequence)sceneCode)) {
                return;
            }
            AsaKnowledgeMessage asaKnowledgeMessage = (AsaKnowledgeMessage)knowledgeMessage.get();
            asaKnowledgeMessage.setAssistantSceneCode(sceneCode);
            this.asaKnowledgeMessageDao.save((Object)asaKnowledgeMessage);
            Integer type = MapUtils.getInteger((Map)scene, (Object)"type");
            if (Objects.isNull(type)) {
                return;
            }
            Assistant assistant = sseEventParam.getAssistant();
            ArrayList<AssistantScene> dataSceneList = new ArrayList<AssistantScene>();
            if (Objects.equals(3, type)) {
                String[] sceneCodeList;
                for (String code : sceneCodeList = sceneCode.split("_")) {
                    AssistantScene assistantScene = this.assistantSceneDao.findAllByAssistantCodeAndCodeAndVersion(assistant.getAssistantCode(), code, assistant.getVersion());
                    if (!Objects.equals(assistantScene.getType(), type)) continue;
                    dataSceneList.add(assistantScene);
                }
            } else if (Objects.equals(1, type)) {
                JSONArray childArray = scene.getJSONArray("child");
                for (int i = 0; i < childArray.size(); ++i) {
                    JSONObject child = childArray.getJSONObject(i);
                    String dataSceneKey = child.getString("key");
                    AssistantScene assistantScene = this.assistantSceneDao.findAllByAssistantCodeAndCodeAndVersion(assistant.getAssistantCode(), dataSceneKey, assistant.getVersion());
                    if (!Objects.equals(assistantScene.getType(), type)) continue;
                    dataSceneList.add(assistantScene);
                }
            } else {
                AssistantScene assistantScene = this.assistantSceneDao.findAllByAssistantCodeAndCodeAndVersion(assistant.getAssistantCode(), sceneCode, assistant.getVersion());
                if (Objects.equals(assistantScene.getType(), type)) {
                    dataSceneList.add(assistantScene);
                }
            }
            if (CollectionUtils.isNotEmpty(dataSceneList)) {
                SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
                actionScene.setActionScenes(dataSceneList);
                actionScene.setType(type);
                sseEventParam.setActionScene(actionScene);
            }
        }
        catch (Exception ex) {
            log.error("selectSceneHandle is error selectScene;{}", (Object)BaseUseUtils.toJsonString((Object)selectScene), (Object)ex);
        }
    }

    protected void replySceneHandle(SseEventParams sseEventParam) {
        boolean textCollectResult;
        List imMessageLogList;
        HisAssistantChatDto question = sseEventParam.getQuestion();
        String ext = question.getMessage().getExt();
        JSONObject extJson = JSONObject.parseObject((String)ext);
        if (extJson.containsKey((Object)"referenced_message_id")) {
            SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
            actionScene.setType(Integer.valueOf(101));
            sseEventParam.setActionScene(actionScene);
        } else if (BooleanUtils.isFalse((Boolean)sseEventParam.getAssistant().getSourceCustom()) && CollectionUtils.isNotEmpty((Collection)(imMessageLogList = this.tryReply(sseEventParam))) && (textCollectResult = this.textCollect(sseEventParam, imMessageLogList))) {
            SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
            actionScene.setType(Integer.valueOf(102));
            sseEventParam.setActionScene(actionScene);
        }
    }

    public List<ImMessageLog> tryReply(SseEventParams sseEventParam) {
        ImMessageLog imMessageLog;
        JSONObject msgExt;
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        List conversationMessages = this.hisConversationMessageService.queryMessage(questionMessage.getUserId(), questionMessage.getTenantId(), questionMessage.getConversationId(), questionMessage.getSectionId(), questionMessage.getIndex(), 10);
        List imMessageLogList = this.hisConversationMessageService.convertImMessageLog(conversationMessages);
        ArrayList<ImMessageLog> latestMessages = new ArrayList<ImMessageLog>();
        for (int i = 0; i < imMessageLogList.size() && !"301".equals((msgExt = (imMessageLog = (ImMessageLog)imMessageLogList.get(i)).getMsgExt()).getString("messageType")); ++i) {
            JSONObject executeContext = imMessageLog.getMsgBody().getJSONObject("executeContext");
            if (!Objects.nonNull(executeContext) || !executeContext.containsKey((Object)"abilityCode") || !"textCollect".equals(executeContext.getString("abilityCode"))) continue;
            latestMessages.add(imMessageLog);
        }
        return latestMessages;
    }

    public boolean textCollect(SseEventParams sseEventParam, List<ImMessageLog> imMessageLogList) {
        try {
            String replyWorkitemId;
            WorkitemInfoData collectWorkCard;
            JSONObject executeContext;
            ArrayList<String> workitemIds = new ArrayList<String>();
            HashMap<String, ImMessageLog> imMessageLogMap = new HashMap<String, ImMessageLog>();
            HashMap<String, WorkitemInfoData> collectWorkCardMap = new HashMap<String, WorkitemInfoData>();
            for (ImMessageLog imMessageLog : imMessageLogList) {
                executeContext = imMessageLog.getMsgBody().getJSONObject("executeContext");
                collectWorkCard = this.workitemInfoDao.findByUserIdAndWorkitemId(sseEventParam.getUser().getUserId(), executeContext.getString("workitemId"));
                if (!Objects.nonNull(collectWorkCard) || !collectWorkCard.needSubmit() || workitemIds.contains(collectWorkCard.getWorkitemId())) continue;
                workitemIds.add(collectWorkCard.getWorkitemId());
                imMessageLogMap.put(collectWorkCard.getWorkitemId(), imMessageLog);
                collectWorkCardMap.put(collectWorkCard.getWorkitemId(), collectWorkCard);
            }
            if (!SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                return false;
            }
            if (CollectionUtils.isNotEmpty(workitemIds) && StringUtils.isNotBlank((CharSequence)(replyWorkitemId = this.asaHelper.textCollect(workitemIds, sseEventParam.getQuestion().getMessage().getText(), sseEventParam.getUser().getToken())))) {
                ImMessageLog imMessageLog;
                imMessageLog = (ImMessageLog)imMessageLogMap.get(replyWorkitemId);
                executeContext = imMessageLog.getMsgBody().getJSONObject("executeContext");
                collectWorkCard = (WorkitemInfoData)collectWorkCardMap.get(replyWorkitemId);
                JSONObject layout = collectWorkCard.getBpmData().getJSONObject("_layout");
                String schema = layout.getString("schema");
                JSONObject submitDto = new JSONObject();
                submitDto.put("value", (Object)Utils.getReferencedValue((String)schema, (String)sseEventParam.getQuestion().getMessage().getText(), (String)sseEventParam.getLanguage()));
                submitDto.put("executeContext", (Object)executeContext);
                submitDto.put("msgIdServer", (Object)imMessageLog.getMsgidServer());
                submitDto.put("msgIdClient", (Object)imMessageLog.getMsgidClient());
                submitDto.put("messageType", imMessageLog.getMsgBody().get((Object)"messageType"));
                if (!SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                    return false;
                }
                SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
                actionScene.setSceneData((Object)submitDto);
                actionScene.setType(Integer.valueOf(102));
                sseEventParam.setActionScene(actionScene);
                return true;
            }
        }
        catch (Exception ex) {
            log.error("textCollect is error", (Throwable)ex);
        }
        return false;
    }
}

