/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.knowledge.server.business;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.ChatGptPromptEnum;
import com.digiwin.athena.ania.common.enums.IntentTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.MessageTypeEnum;
import com.digiwin.athena.ania.common.enums.RhModelEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.common.enums.SseFlowToolTypeEnum;
import com.digiwin.athena.ania.dto.AniaEventLogBuilder;
import com.digiwin.athena.ania.dto.chatgpt.ChatGptRequest;
import com.digiwin.athena.ania.dto.chatgpt.command.TemplateCommand;
import com.digiwin.athena.ania.helper.AsaHelper;
import com.digiwin.athena.ania.helper.ChatGptHelper;
import com.digiwin.athena.ania.helper.RhHelper;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.AssistantStrategy;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AiProject;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneMgDao;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.JsonUtil;
import com.digiwin.athena.ania.util.LmcClientUtils;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class BusinessComponent
extends AssistantStrategy {
    private static final Logger log = LoggerFactory.getLogger(BusinessComponent.class);
    public static final Integer DEFAULT_MSG_TYPE = 1;
    @Value(value="${multiDialogueFlag:false}")
    private Boolean multiDialogueFlag;
    @Resource
    private RhHelper rhHelper;
    @Autowired
    private AsaHelper asaHelper;
    @Autowired
    private ChatGptHelper chatGptHelper;
    @Resource
    private AssistantSceneMgDao assistantSceneMgDao;

    public Integer getAssistantSubType() {
        return AssistantSubTypeEnum.BUSINESS.getType();
    }

    public void beforeSceneExtend(SseEventParams sseEventParam) {
        this.interpretCommand(sseEventParam);
    }

    public void interpretCommand(SseEventParams sseEventParam) {
        try {
            ((SseFlow)this.flowMap.get(SseFlowToolTypeEnum.INTENT_UNDERSTANDING.getFlowEventType())).flowStart(sseEventParam);
            if (Objects.isNull(sseEventParam.getActionScene())) {
                if (!SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                    return;
                }
                this.replySceneHandle(sseEventParam);
                Assistant assistant = sseEventParam.getAssistant();
                if (BooleanUtils.isFalse((Boolean)assistant.getSourceCustom())) {
                    if (Objects.isNull(sseEventParam.getActionScene())) {
                        this.multiDialogue(sseEventParam);
                        if (!SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                            return;
                        }
                        this.intentRecognition(sseEventParam);
                    }
                } else {
                    this.customIntentRecognition(sseEventParam);
                }
            }
        }
        finally {
            ((SseFlow)this.flowMap.get(SseFlowToolTypeEnum.INTENT_UNDERSTANDING.getFlowEventType())).flowEnd(sseEventParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void customIntentRecognition(SseEventParams sseEventParam) {
        JSONObject assistantAgentResult = null;
        try {
            EventData eventData = new EventData(SseEventlEnum.CHAT_IN_PROGRESS.getEvent(), null);
            this.sendEventData(sseEventParam, eventData);
            SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
            assistantAgentResult = this.asaHelper.assistantAgent(sseEventParam.getQuestion(), sseEventParam.getUser().getToken(), sseEventParam.getUser().getTenantId());
            if (Objects.nonNull(assistantAgentResult) && assistantAgentResult.containsKey((Object)"data")) {
                JSONObject data = assistantAgentResult.getJSONObject("data");
                SseEventlEnum.SseEventDataTypeEnum intentRecognition = SseEventlEnum.SseEventDataTypeEnum.INTENT_RECOGNITION;
                String msg = intentRecognition.getDefaultValue() + BaseUseUtils.toJsonString((Object)data);
                EventData intentEventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), intentRecognition.getType(), null, msg);
                this.sendEventData(sseEventParam, intentEventData);
                String command = data.getString("command");
                if (StringUtils.isNotBlank((CharSequence)command)) {
                    switch (command) {
                        case "EXE_TASK_MSG": {
                            JSONObject workCard = data.getJSONObject("workCard");
                            JSONObject submitDto = new JSONObject();
                            submitDto.put("value", (Object)data.getString("cardData"));
                            submitDto.put("executeContext", (Object)workCard.getJSONObject("message").getJSONObject("executeContext"));
                            submitDto.put("messageType", (Object)workCard.getJSONObject("message").getInteger("messageType"));
                            actionScene.setSceneData((Object)submitDto);
                            actionScene.setType(Integer.valueOf(102));
                            sseEventParam.setActionScene(actionScene);
                            break;
                        }
                        case "START_TEMPLATE": {
                            String intentType = data.getString("intentType");
                            IntentTypeEnum intentTypeEnum = IntentTypeEnum.getTypeEnumByName((String)intentType);
                            actionScene.setSceneData((Object)new TemplateCommand(intentTypeEnum, data.getString("value")));
                            actionScene.setType(Integer.valueOf(105));
                            sseEventParam.setActionScene(actionScene);
                            break;
                        }
                        case "SEND_MSG": {
                            sseEventParam.setAiMsg(data.getString("msg"));
                        }
                    }
                }
                if (Objects.nonNull(actionScene = sseEventParam.getActionScene())) {
                    LmcClientUtils.saveEventLog((SaveEventLog)this.buildIntentEventLog(sseEventParam, assistantAgentResult), (String)sseEventParam.getUser().getToken());
                    return;
                }
                actionScene = new SseEventParams.ActionScene();
                if (SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                    actionScene.setType(Integer.valueOf(88));
                    sseEventParam.setActionScene(actionScene);
                }
            }
            LmcClientUtils.saveEventLog((SaveEventLog)this.buildIntentEventLog(sseEventParam, assistantAgentResult), (String)sseEventParam.getUser().getToken());
        }
        catch (Exception e) {
            log.error("customIntentRecognition is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
        }
        finally {
            LmcClientUtils.saveEventLog((SaveEventLog)this.buildIntentEventLog(sseEventParam, assistantAgentResult), (String)sseEventParam.getUser().getToken());
        }
    }

    private SaveEventLog buildIntentEventLog(SseEventParams sseEventParam, JSONObject assistantAgentResult) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("assistantCode", sseEventParam.getQuestion().getAssistantCode());
        content.put("question", (String)sseEventParam.getQuestion());
        SaveEventLog eventLog = AniaEventLogBuilder.anAniaEventLog().withEventId(sseEventParam.getId()).withEventName("intentRecognition").withEventSource(sseEventParam.getTraceId()).withEventType(Integer.valueOf(1)).withRequestUrl(null).withTenantId(sseEventParam.getUser().getTenantId()).withTenantName(sseEventParam.getUser().getTenantName()).withUserId(sseEventParam.getUser().getUserId()).withUserName(sseEventParam.getUser().getUserName()).withRequestParam(sseEventParam.getQuestion().getMessage().getText()).withContent(content).withJsonResult(BaseUseUtils.toJsonString((Object)assistantAgentResult)).build();
        if (sseEventParam.getActionScene() != null && (Objects.equals(105, sseEventParam.getActionScene().getType()) || Objects.equals(102, sseEventParam.getActionScene().getType()))) {
            eventLog.setStatus(Integer.valueOf(0));
        } else {
            eventLog.setErrorMsg("none intent");
            eventLog.setStatus(Integer.valueOf(1));
        }
        return eventLog;
    }

    private boolean sendEventData(SseEventParams sseEventParam, EventData data) {
        try {
            this.sseEventDataService.saveEventDataLog(sseEventParam, data);
            SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
            if (Objects.nonNull(sseEmitter)) {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)data);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)data);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intentRecognition(SseEventParams sseEventParam) {
        log.info("BusinessComponent.intentRecognition.PtxId:{}", (Object)MdcUtil.get((String)"PtxId"));
        ArrayList<String> matchIntents = new ArrayList<String>();
        try {
            EventData eventData = new EventData(SseEventlEnum.CHAT_IN_PROGRESS.getEvent(), null);
            this.sendEventData(sseEventParam, eventData);
            Assistant assistant = sseEventParam.getAssistant();
            AiProject aiProject = assistant.getAiProject();
            String modelTag = StringUtils.isBlank((CharSequence)aiProject.getModelTag()) ? "test" : aiProject.getModelTag();
            boolean esEnable = aiProject.getModelTypes() == null ? false : aiProject.getModelTypes().contains(3);
            String combinationMsg = sseEventParam.getCombinationMsg();
            String text = sseEventParam.getQuestion().getMessage().getText();
            text = StrUtil.isNotBlank((CharSequence)combinationMsg) ? combinationMsg : text;
            JSONObject requestData = new JSONObject().fluentPut("project_name", (Object)aiProject.getProjectCode()).fluentPut("assistant_id", (Object)assistant.getAssistantCode()).fluentPut("tenant_id", (Object)sseEventParam.getUser().getTenantId()).fluentPut("text", (Object)text).fluentPut("threshold", (Object)"0.8").fluentPut("deploy_mode", (Object)modelTag).fluentPut("es_mode", (Object)esEnable).fluentPut("llm_foundation_model", (Object)"ChatGPT");
            JSONObject intentResult = this.rhHelper.syncRequest(sseEventParam.getUser().getToken(), (Map)requestData, RhModelEnum.INFERENCE_V1);
            Integer code = intentResult.getInteger("code");
            if (Objects.equals(0, code)) {
                JSONObject data = intentResult.getJSONObject("data");
                JSONObject candidateIntent = data.getJSONObject("candidate_intent");
                JSONObject scores = candidateIntent.getJSONObject("scores");
                Set scoreIntents = scores.keySet();
                for (String scoreIntent : scoreIntents) {
                    if ("None".equals(scoreIntent) || Float.compare(scores.getFloatValue(scoreIntent), 0.8f) < 0) continue;
                    matchIntents.add(scoreIntent);
                }
                if (CollectionUtils.isEmpty(matchIntents)) {
                    matchIntents.add(candidateIntent.getString("top_intent"));
                }
            } else if (Objects.equals(1, code)) {
                sseEventParam.setAiMsg(intentResult.getJSONObject("candidate_intent").getString("msg"));
            }
            sseEventParam.setIntentResult(intentResult);
            SseEventlEnum.SseEventDataTypeEnum intentRecognition = SseEventlEnum.SseEventDataTypeEnum.INTENT_RECOGNITION;
            String msg = CollectionUtils.isNotEmpty(matchIntents) ? intentRecognition.getDefaultValue() + "(" + Joiner.on((String)"_").join(matchIntents) + ")" : intentRecognition.getDefaultValue();
            EventData intentEventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), intentRecognition.getType(), null, msg);
            this.sendEventData(sseEventParam, intentEventData);
            this.buildScene(sseEventParam, matchIntents);
        }
        catch (Exception e) {
            log.error("intentRecognition is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
        }
        finally {
            this.buildDefaultScene(sseEventParam);
            this.saveIntentEventLog(sseEventParam, matchIntents);
        }
    }

    private void buildScene(SseEventParams sseEventParam, List<String> matchIntents) {
        if (CollectionUtils.isNotEmpty(matchIntents)) {
            AssistantScene scene;
            int index = matchIntents.size();
            if (index > 10) {
                index = 10;
            }
            List assistantSceneList = this.assistantSceneDao.findAllByAssistantCodeAndVersion(sseEventParam.getAssistant().getAssistantCode(), sseEventParam.getAssistant().getVersion());
            Map assistantSceneMap = assistantSceneList.stream().collect(Collectors.toMap(AssistantScene::getName, Function.identity(), (key1, key2) -> key2));
            HashMap<String, AssistantScene> assistantSceneLangMap = new HashMap<String, AssistantScene>();
            for (AssistantScene assistantScene : assistantSceneList) {
                Map sceneNameLang;
                Map lang = assistantScene.getLang();
                if (!MapUtils.isNotEmpty((Map)lang) || !MapUtils.isNotEmpty((Map)(sceneNameLang = (Map)lang.get("name")))) continue;
                for (Object sceneName : sceneNameLang.values()) {
                    assistantSceneLangMap.put(sceneName.toString(), assistantScene);
                }
            }
            ArrayList<AssistantScene> identifyScenes = new ArrayList<AssistantScene>();
            ArrayList<String> nameNotMatchIntents = new ArrayList<String>();
            for (int i = 0; i < index; ++i) {
                String sceneName = matchIntents.get(i);
                scene = (AssistantScene)assistantSceneMap.get(sceneName);
                if (Objects.nonNull(scene)) {
                    identifyScenes.add(scene);
                    continue;
                }
                nameNotMatchIntents.add(sceneName);
            }
            for (String notMatchIntent : nameNotMatchIntents) {
                scene = (AssistantScene)assistantSceneLangMap.get(notMatchIntent);
                if (!Objects.nonNull(scene)) continue;
                identifyScenes.add(scene);
            }
            sseEventParam.setIdentifyScenes(identifyScenes);
            if (CollectionUtils.isNotEmpty(identifyScenes)) {
                if (identifyScenes.size() == 1) {
                    SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
                    actionScene.setType(Integer.valueOf(Objects.nonNull(((AssistantScene)identifyScenes.get(0)).getType()) ? ((AssistantScene)identifyScenes.get(0)).getType() : 3));
                    actionScene.setActionScenes(identifyScenes);
                    sseEventParam.setActionScene(actionScene);
                    return;
                }
                HashMap dataSceneMap = new HashMap(identifyScenes.size());
                ArrayList<SseEventParams.ActionScene> actionScenes = new ArrayList<SseEventParams.ActionScene>();
                for (AssistantScene scene2 : identifyScenes) {
                    SseEventParams.ActionScene actionScene = new SseEventParams.ActionScene();
                    actionScene.setType(Integer.valueOf(Objects.nonNull(((AssistantScene)identifyScenes.get(0)).getType()) ? ((AssistantScene)identifyScenes.get(0)).getType() : 3));
                    actionScene.setActionScenes((List)Lists.newArrayList((Object[])new AssistantScene[]{scene2}));
                    actionScenes.add(actionScene);
                }
                if (actionScenes.size() == 1) {
                    sseEventParam.setActionScene((SseEventParams.ActionScene)actionScenes.get(0));
                }
            }
            log.info("buildScene end sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
        }
    }

    private void saveIntentEventLog(SseEventParams sseEventParam, List<String> matchIntents) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("assistantCode", sseEventParam.getQuestion().getAssistantCode());
        content.put("question", (String)sseEventParam.getQuestion());
        SaveEventLog eventLog = AniaEventLogBuilder.anAniaEventLog().withEventId(sseEventParam.getId()).withEventName("intentRecognition").withEventSource(sseEventParam.getTraceId()).withEventType(Integer.valueOf(1)).withRequestUrl(null).withStatus(Integer.valueOf(0)).withTenantId(sseEventParam.getUser().getTenantId()).withTenantName(sseEventParam.getUser().getTenantName()).withUserId(sseEventParam.getUser().getUserId()).withUserName(sseEventParam.getUser().getUserName()).withRequestParam(sseEventParam.getQuestion().getMessage().getText()).withContent(content).build();
        if (CollectionUtils.isEmpty(matchIntents)) {
            eventLog.setErrorMsg("none intent");
            eventLog.setStatus(Integer.valueOf(1));
        } else {
            eventLog.setJsonResult(Joiner.on((String)",").join(matchIntents));
        }
        LmcClientUtils.saveEventLog((SaveEventLog)eventLog, (String)sseEventParam.getUser().getToken());
    }

    private void buildDefaultScene(SseEventParams sseEventParam) {
        try {
            SseEventParams.ActionScene actionScene = sseEventParam.getActionScene();
            if (Objects.nonNull(actionScene)) {
                return;
            }
            actionScene = new SseEventParams.ActionScene();
            List identifyScenes = sseEventParam.getIdentifyScenes();
            if (CollectionUtils.isEmpty((Collection)identifyScenes)) {
                Assistant assistant = sseEventParam.getAssistant();
                Query query = Query.query((CriteriaDefinition)Criteria.where((String)"assistantCode").is((Object)assistant.getAssistantCode()).and("version").is((Object)assistant.getVersion()).and("knowledgeBase.defaultKBS").is((Object)true));
                AssistantScene defaultAssistantScene = (AssistantScene)this.assistantSceneMgDao.findOne(query);
                if (Objects.nonNull(defaultAssistantScene)) {
                    actionScene.setType(defaultAssistantScene.getType());
                    actionScene.setActionScenes((List)ListUtil.toList((Object[])new AssistantScene[]{defaultAssistantScene}));
                    if (Objects.equals(3, defaultAssistantScene.getType())) {
                        sseEventParam.setActionScene(actionScene);
                    }
                }
            } else {
                actionScene.setType(Integer.valueOf(99));
                sseEventParam.setActionScene(actionScene);
            }
            if (Objects.isNull(sseEventParam.getActionScene()) && SseEmitterUtils.isActive((String)sseEventParam.getId())) {
                actionScene.setType(Integer.valueOf(88));
                sseEventParam.setActionScene(actionScene);
            }
            log.info("buildDefaultScene end sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
        }
        catch (Exception e) {
            log.error("buildDefaultScene is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
        }
    }

    private void multiDialogue(SseEventParams sseEventParams) {
        try {
            if (!this.multiDialogueFlag.booleanValue()) {
                return;
            }
            AuthoredUser user = sseEventParams.getUser();
            String token = user.getToken();
            ConversationMessage questionMessage = sseEventParams.getQuestionMessage();
            List conversationMessages = this.hisConversationMessageService.queryMessage(questionMessage.getUserId(), questionMessage.getTenantId(), questionMessage.getConversationId(), questionMessage.getSectionId(), questionMessage.getIndex(), 10);
            ArrayList<ConversationMessage> questMessages = new ArrayList<ConversationMessage>();
            for (int i = 0; i < conversationMessages.size() && questMessages.size() < 3; ++i) {
                ConversationMessage imMessageLog = (ConversationMessage)conversationMessages.get(i);
                Map msgExt = imMessageLog.getExt();
                if (MessageTypeEnum.NEW_CONVERSATION.getType().equals(MapUtils.getInteger((Map)msgExt, (Object)"messageType"))) break;
                String showType = MapUtils.getString((Map)msgExt, (Object)"showType");
                if (!StrUtil.isNotBlank((CharSequence)showType) || !"2".equals(showType) || !"TEXT".equals(imMessageLog.getMsgType())) continue;
                questMessages.add(imMessageLog);
            }
            List text = questMessages.stream().map(quest -> quest.getMsgBody().getString("text")).collect(Collectors.toList());
            text.add(sseEventParams.getQuestion().getMessage().getText());
            log.info("\u4e0a\u4e0b\u6587\u7528\u6237\u63d0\u95ee\u6d88\u606f\u7f16\u53f7:{}\uff0c\u7528\u6237\u63d0\u95ee:{}", (Object)sseEventParams.getQuestion().getMessage().getMsgId(), (Object)JsonUtil.toJSONString(text));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("-\u7528\u6237\u6700\u8fd1\u51e0\u8f6e\u4ea4\u4e92\u4fe1\u606f:");
            if (CollUtil.isNotEmpty(questMessages)) {
                for (int i = questMessages.size() - 1; i >= 0; --i) {
                    List textMap;
                    ConversationMessage message = (ConversationMessage)questMessages.get(i);
                    stringBuilder.append("\n");
                    stringBuilder.append("n" + (i + 1));
                    stringBuilder.append(".");
                    stringBuilder.append(message.getMsgBody().getString("text"));
                    if (!CollectionUtils.isNotEmpty((Collection)message.getContent()) || !CollectionUtils.isNotEmpty(textMap = message.getContent().stream().filter(item -> "text".equalsIgnoreCase(MapUtils.getString((Map)item, (Object)"type"))).collect(Collectors.toList()))) continue;
                    String text1 = MapUtils.getString((Map)((Map)textMap.get(0)), (Object)"text");
                    stringBuilder.append(":");
                    stringBuilder.append(text1);
                }
            }
            stringBuilder.append("\n");
            stringBuilder.append("\u7528\u6237\u8bed\u53e5=");
            stringBuilder.append(sseEventParams.getQuestion().getMessage().getText());
            ChatGptRequest chatGptRequest = new ChatGptRequest();
            ChatGptPromptEnum promptEnum = ChatGptPromptEnum.MULTI_DIALOGUE;
            if (LocalsEnum.isTw((String)sseEventParams.getLanguage())) {
                promptEnum = ChatGptPromptEnum.MULTI_DIALOGUE_TW;
            }
            chatGptRequest.setPrompt(promptEnum);
            ArrayList<BasicNameValuePair> userParam = new ArrayList<BasicNameValuePair>();
            userParam.add(new BasicNameValuePair("#{userPrompt}", stringBuilder.toString()));
            chatGptRequest.setUserParam(userParam);
            ArrayList<BasicNameValuePair> systemParam = new ArrayList<BasicNameValuePair>();
            systemParam.add(new BasicNameValuePair("${currentDate}", DateUtil.now()));
            chatGptRequest.setSystemParam(systemParam);
            chatGptRequest.setUserParam(userParam);
            String result = this.chatGptHelper.commonRequestGpt(chatGptRequest, token);
            JSONObject gptResult = JSON.parseObject((String)result);
            String semanticRewriting = gptResult.getString("semantic_rewriting");
            sseEventParams.setCombinationMsg(semanticRewriting);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4e0b\u6587\u6c47\u603b\u5f02\u5e38sseEventParams:{}", (Object)JSONUtil.toJsonStr((Object)sseEventParams), (Object)e);
        }
    }
}

