/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mapper.mongo;

import com.digiwin.athena.ania.entity.ImMessageLog;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class MessageMongoMapper {
    @Resource
    private MongoTemplate semcMessageMongoTemplate;
    private static final String COLLECTION_NAME = "ania_message";

    public void message(ImMessageLog imMessageLog) {
        BulkOperations operations = this.semcMessageMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, COLLECTION_NAME);
        operations.insert((Object)imMessageLog);
        operations.execute();
    }

    public List<ImMessageLog> getLatestMessages(String userId, Integer num, String assistantAccount, String sessionId) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userId), Criteria.where((String)"toAccount").is((Object)userId)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)assistantAccount), Criteria.where((String)"toAccount").is((Object)assistantAccount)});
        if (StringUtils.isNotBlank((CharSequence)sessionId)) {
            Criteria criteria3 = new Criteria();
            criteria3.and("msgExt.sessionId").is((Object)sessionId);
            criteria.andOperator(new Criteria[]{criteria1, criteria2, criteria3});
        } else {
            criteria.andOperator(new Criteria[]{criteria1, criteria2});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"msgTimestamp")}));
        query.limit(num.intValue());
        List mapList = this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
        return mapList;
    }

    public List<ImMessageLog> getLatestMessages(String from, String to, Integer limit) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"fromAccount").is((Object)from));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"toAccount").is((Object)to));
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"msgTimestamp")}));
        query.limit(limit.intValue());
        return this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
    }

    public List<ImMessageLog> get2WayLatestMessages(String userId, String assistantAccount, Integer limit) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userId), Criteria.where((String)"toAccount").is((Object)userId)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)assistantAccount), Criteria.where((String)"toAccount").is((Object)assistantAccount)});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"msgTimestamp")}));
        query.limit(limit.intValue());
        List mapList = this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
        return mapList;
    }

    public List<ImMessageLog> queryMessageByIds(List msgidServers) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"msgidServer").in((Collection)msgidServers)});
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"msgTimestamp")}));
        List mapList = this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
        return mapList;
    }

    public ImMessageLog queryMessageById(String msgidServer) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"msgidServer").is((Object)msgidServer)});
        query.addCriteria((CriteriaDefinition)criteria);
        ImMessageLog imMessageLog = (ImMessageLog)this.semcMessageMongoTemplate.findOne(query, ImMessageLog.class, COLLECTION_NAME);
        return imMessageLog;
    }

    public Set<String> getAllAccid() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"fromAccount", "toAccount"}), Aggregation.project((String[])new String[]{"fromAccount", "toAccount"})});
        AggregationResults results = this.semcMessageMongoTemplate.aggregate(agg, COLLECTION_NAME, Document.class);
        ArrayList<String> aacids = new ArrayList<String>();
        HashSet<String> setAccid = new HashSet<String>();
        for (Document doc : results) {
            String fromAccount = doc.getString((Object)"fromAccount");
            String toAccount = doc.getString((Object)"toAccount");
            if (StringUtils.isNotBlank((CharSequence)fromAccount)) {
                aacids.add(fromAccount);
            }
            if (!StringUtils.isNotBlank((CharSequence)toAccount)) continue;
            aacids.add(toAccount);
        }
        setAccid.addAll(aacids);
        return setAccid;
    }

    public List<ImMessageLog> getMessageByAccId(String serviceAccId, String userAccId, int pageNum, int num) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userAccId), Criteria.where((String)"toAccount").is((Object)userAccId)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)serviceAccId), Criteria.where((String)"toAccount").is((Object)serviceAccId)});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)num, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"msgTimestamp"}));
        query.with((Pageable)pageable);
        List mapList = this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
        if (userAccId.equals("test_cnhw_9723")) {
            return mapList.stream().filter(item -> !"\u53d1\u751f\u7cfb\u7edf\u9519\u8bef-501\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5".equals(item.getMsgBody().getString("prompt"))).collect(Collectors.toList());
        }
        return mapList;
    }

    public List<ImMessageLog> getAllMessageByAccId(String serviceAccId, String userAccid) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userAccid), Criteria.where((String)"toAccount").is((Object)userAccid)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)serviceAccId), Criteria.where((String)"toAccount").is((Object)serviceAccId)});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"msgTimestamp")}));
        List mapList = this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
        if (userAccid.equals("test_cnhw_9723")) {
            return mapList.stream().filter(item -> !"\u53d1\u751f\u7cfb\u7edf\u9519\u8bef-501\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5".equals(item.getMsgBody().getString("prompt"))).collect(Collectors.toList());
        }
        return mapList;
    }

    public void updateMessage(ImMessageLog imMessageLog) {
        if (StringUtils.isNotBlank((CharSequence)imMessageLog.getFromAccount())) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"msgidServer").is((Object)imMessageLog.getMsgidServer()));
            Update update = new Update().set("fromAccount", (Object)imMessageLog.getFromAccount());
            this.semcMessageMongoTemplate.updateFirst(query, (UpdateDefinition)update, COLLECTION_NAME);
        } else if (StringUtils.isNotBlank((CharSequence)imMessageLog.getToAccount())) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"msgidServer").is((Object)imMessageLog.getMsgidServer()));
            Update update = new Update().set("toAccount", (Object)imMessageLog.getToAccount());
            this.semcMessageMongoTemplate.updateFirst(query, (UpdateDefinition)update, COLLECTION_NAME);
        }
    }

    public long count(String serviceAccId, String userAccid) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)userAccid), Criteria.where((String)"toAccount").is((Object)userAccid)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)serviceAccId), Criteria.where((String)"toAccount").is((Object)serviceAccId)});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        long count = this.semcMessageMongoTemplate.count(query, COLLECTION_NAME);
        return count;
    }

    public void updateMessageServerId(ImMessageLog messageLog, String agoraMsgId) {
        if (StringUtils.isNotBlank((CharSequence)agoraMsgId)) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"msgidServer").is((Object)messageLog.getMsgidServer()));
            Update update = new Update().set("msgidServer", (Object)agoraMsgId);
            this.semcMessageMongoTemplate.updateFirst(query, (UpdateDefinition)update, COLLECTION_NAME);
        }
    }

    public List<ImMessageLog> queryMessage(Long msgTimestamp, int pageSize, String fromAccount) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)fromAccount)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"msgTimestamp").lt((Object)msgTimestamp), Criteria.where((String)"fromAccount").is((Object)fromAccount)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"msgTimestamp").lt((Object)msgTimestamp)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"msgTimestamp")}));
        query.limit(pageSize);
        return this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
    }

    public long queryMessageCount(Long msgTimestamp, String fromAccount) {
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)fromAccount)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"msgTimestamp").lt((Object)msgTimestamp), Criteria.where((String)"fromAccount").is((Object)fromAccount)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"msgTimestamp").lt((Object)msgTimestamp)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return this.semcMessageMongoTemplate.count(query, COLLECTION_NAME);
    }

    public long count(long msgTimestamp, String assistantAccid) {
        Query query = new Query();
        LocalDateTime oneYearNow = LocalDateTime.now().minusYears(1L);
        long oneYearNowMillis = oneYearNow.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        Criteria time = Criteria.where((String)"msgTimestamp").lt((Object)msgTimestamp);
        query.addCriteria((CriteriaDefinition)time);
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)assistantAccid), Criteria.where((String)"toAccount").is((Object)assistantAccid)});
        query.addCriteria((CriteriaDefinition)criteria1);
        long count = this.semcMessageMongoTemplate.count(query, COLLECTION_NAME);
        return count;
    }

    public List<ImMessageLog> findAll(long msgTimestamp, String assistantAccid) {
        Query query = new Query();
        LocalDateTime oneYearNow = LocalDateTime.now().minusYears(1L);
        long oneYearNowMillis = oneYearNow.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        Criteria time = Criteria.where((String)"msgTimestamp").lt((Object)msgTimestamp);
        query.addCriteria((CriteriaDefinition)time);
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)assistantAccid), Criteria.where((String)"toAccount").is((Object)assistantAccid)});
        query.addCriteria((CriteriaDefinition)criteria1);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"msgTimestamp"}));
        query.limit(100);
        List imMessageLogList = this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
        return imMessageLogList;
    }

    public List<ImMessageLog> getMessageByMsgId(String msgId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"msgExt.msgId").is((Object)msgId));
        return this.semcMessageMongoTemplate.find(query, ImMessageLog.class, COLLECTION_NAME);
    }
}

