/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mapper.mongo;

import com.digiwin.athena.ania.entity.MessageSearch;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class MessageSearchMongoMapper {
    @Resource
    private MongoTemplate semcMessageMongoTemplate;
    private static final String COLLECTION_NAME = "message_search";

    public void message(MessageSearch messageSearch) {
        BulkOperations operations = this.semcMessageMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, COLLECTION_NAME);
        operations.insert((Object)messageSearch);
        operations.execute();
    }

    public Long countMessage(Map mapParam, String accid) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)accid), Criteria.where((String)"toAccount").is((Object)accid)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)MapUtils.getString((Map)mapParam, (Object)"assistantAccount")), Criteria.where((String)"toAccount").is((Object)MapUtils.getString((Map)mapParam, (Object)"assistantAccount"))});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        LocalDateTime oneYearNow = LocalDateTime.now().minusYears(1L);
        long oneYearNowMillis = oneYearNow.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        Criteria time = Criteria.where((String)"msgTimestamp").gte((Object)oneYearNowMillis);
        if (Objects.nonNull(MapUtils.getLong((Map)mapParam, (Object)"lastMsgTimestamp"))) {
            time.lte((Object)MapUtils.getLong((Map)mapParam, (Object)"lastMsgTimestamp"));
        } else {
            time.lte((Object)System.currentTimeMillis());
        }
        query.addCriteria((CriteriaDefinition)time);
        Pattern pattern = Pattern.compile("^.*" + MapUtils.getString((Map)mapParam, (Object)"keyword") + ".*$", 2);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"keyword").regex(pattern));
        Long num = this.semcMessageMongoTemplate.count(query, COLLECTION_NAME);
        return num;
    }

    public List<MessageSearch> searchMessage(Map mapParam, String accid) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)accid), Criteria.where((String)"toAccount").is((Object)accid)});
        Criteria criteria2 = new Criteria();
        criteria2.orOperator(new Criteria[]{Criteria.where((String)"fromAccount").is((Object)MapUtils.getString((Map)mapParam, (Object)"assistantAccount")), Criteria.where((String)"toAccount").is((Object)MapUtils.getString((Map)mapParam, (Object)"assistantAccount"))});
        criteria.andOperator(new Criteria[]{criteria1, criteria2});
        query.addCriteria((CriteriaDefinition)criteria);
        LocalDateTime oneYearNow = LocalDateTime.now().minusYears(1L);
        long oneYearNowMillis = oneYearNow.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        Criteria time = Criteria.where((String)"msgTimestamp").gte((Object)oneYearNowMillis);
        if (Objects.nonNull(MapUtils.getLong((Map)mapParam, (Object)"lastMsgTimestamp"))) {
            time.lt((Object)MapUtils.getLong((Map)mapParam, (Object)"lastMsgTimestamp"));
        } else {
            time.lt((Object)System.currentTimeMillis());
        }
        query.addCriteria((CriteriaDefinition)time);
        Pattern pattern = Pattern.compile("^.*" + MapUtils.getString((Map)mapParam, (Object)"keyword") + ".*$", 2);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"keyword").regex(pattern));
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"msgTimestamp"});
        PageRequest pageable = PageRequest.of((int)(MapUtils.getIntValue((Map)mapParam, (Object)"page") - 1), (int)MapUtils.getIntValue((Map)mapParam, (Object)"rows"), (Sort)sort);
        query.with((Pageable)pageable);
        List messageSearchList = this.semcMessageMongoTemplate.find(query, MessageSearch.class, COLLECTION_NAME);
        return messageSearchList;
    }

    public MessageSearch findOne(String msgidServer) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"msgidServer").is((Object)msgidServer)});
        query.addCriteria((CriteriaDefinition)criteria);
        MessageSearch one = (MessageSearch)this.semcMessageMongoTemplate.findOne(query, MessageSearch.class, COLLECTION_NAME);
        return one;
    }
}

