/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.domain;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.PublicEventTypeEnum;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.helper.dto.skc.SkcSkillDelistingDto;
import com.digiwin.athena.ania.helper.dto.skc.SkcSkillPublishDto;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantEventRecord;
import com.digiwin.athena.ania.util.IdSnowflake;
import com.digiwin.athena.ania.util.JsonUtil;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(value="fusion_assistant_event_record")
public class FusionAssistantEventRecord {
    @Id
    private String id;
    private String eventType;
    private String eventId;
    private List<JSONObject> event;
    private String UserId;
    private String assistantId;
    private JSONObject customInfo;
    private Date createTime = new Date();

    public static FusionAssistantEventRecord publish(FusionAssistantPublishDto dto) {
        FusionAssistantEventRecord fusionAssistantEventRecord = new FusionAssistantEventRecord();
        fusionAssistantEventRecord.setEventType(dto.getEventType());
        fusionAssistantEventRecord.setEventId(dto.getEventId());
        fusionAssistantEventRecord.setEvent(dto.getEvent());
        return fusionAssistantEventRecord;
    }

    public static FusionAssistantEventRecord skcPublish(SkcSkillPublishDto dto, Boolean result) {
        FusionAssistantEventRecord fusionAssistantEventRecord = new FusionAssistantEventRecord();
        fusionAssistantEventRecord.setEventType(PublicEventTypeEnum.SKC_PUBLISHED.getType());
        fusionAssistantEventRecord.setEventId(IdSnowflake.snowflakeIdStr());
        fusionAssistantEventRecord.setUserId(dto.getOwnerUserId());
        fusionAssistantEventRecord.setAssistantId(dto.getAppId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("param", (Object)JsonUtil.toJSONString((Object)dto));
        jsonObject.put("response", (Object)result);
        fusionAssistantEventRecord.setCustomInfo(jsonObject);
        return fusionAssistantEventRecord;
    }

    public static FusionAssistantEventRecord skcUnPublish(SkcSkillDelistingDto dto, Boolean result) {
        FusionAssistantEventRecord fusionAssistantEventRecord = new FusionAssistantEventRecord();
        fusionAssistantEventRecord.setEventType(PublicEventTypeEnum.SKC_UNPUBLISH.getType());
        fusionAssistantEventRecord.setEventId(IdSnowflake.snowflakeIdStr());
        fusionAssistantEventRecord.setUserId(dto.getUpdateId());
        fusionAssistantEventRecord.setAssistantId(dto.getId());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("param", (Object)JsonUtil.toJSONString((Object)dto));
        jsonObject.put("response", (Object)result);
        fusionAssistantEventRecord.setCustomInfo(jsonObject);
        return fusionAssistantEventRecord;
    }

    public static FusionAssistantEventRecordBuilder builder() {
        return new FusionAssistantEventRecordBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventId() {
        return this.eventId;
    }

    public List<JSONObject> getEvent() {
        return this.event;
    }

    public String getUserId() {
        return this.UserId;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public JSONObject getCustomInfo() {
        return this.customInfo;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setEvent(List<JSONObject> event) {
        this.event = event;
    }

    public void setUserId(String UserId) {
        this.UserId = UserId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public void setCustomInfo(JSONObject customInfo) {
        this.customInfo = customInfo;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FusionAssistantEventRecord)) {
            return false;
        }
        FusionAssistantEventRecord other = (FusionAssistantEventRecord)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$eventType = this.getEventType();
        String other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !this$eventType.equals(other$eventType)) {
            return false;
        }
        String this$eventId = this.getEventId();
        String other$eventId = other.getEventId();
        if (this$eventId == null ? other$eventId != null : !this$eventId.equals(other$eventId)) {
            return false;
        }
        List this$event = this.getEvent();
        List other$event = other.getEvent();
        if (this$event == null ? other$event != null : !((Object)this$event).equals(other$event)) {
            return false;
        }
        String this$UserId = this.getUserId();
        String other$UserId = other.getUserId();
        if (this$UserId == null ? other$UserId != null : !this$UserId.equals(other$UserId)) {
            return false;
        }
        String this$assistantId = this.getAssistantId();
        String other$assistantId = other.getAssistantId();
        if (this$assistantId == null ? other$assistantId != null : !this$assistantId.equals(other$assistantId)) {
            return false;
        }
        JSONObject this$customInfo = this.getCustomInfo();
        JSONObject other$customInfo = other.getCustomInfo();
        if (this$customInfo == null ? other$customInfo != null : !this$customInfo.equals(other$customInfo)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FusionAssistantEventRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : $eventType.hashCode());
        String $eventId = this.getEventId();
        result = result * 59 + ($eventId == null ? 43 : $eventId.hashCode());
        List $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
        String $UserId = this.getUserId();
        result = result * 59 + ($UserId == null ? 43 : $UserId.hashCode());
        String $assistantId = this.getAssistantId();
        result = result * 59 + ($assistantId == null ? 43 : $assistantId.hashCode());
        JSONObject $customInfo = this.getCustomInfo();
        result = result * 59 + ($customInfo == null ? 43 : $customInfo.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "FusionAssistantEventRecord(id=" + this.getId() + ", eventType=" + this.getEventType() + ", eventId=" + this.getEventId() + ", event=" + this.getEvent() + ", UserId=" + this.getUserId() + ", assistantId=" + this.getAssistantId() + ", customInfo=" + this.getCustomInfo() + ", createTime=" + this.getCreateTime() + ")";
    }

    public FusionAssistantEventRecord() {
    }

    public FusionAssistantEventRecord(String id, String eventType, String eventId, List<JSONObject> event, String UserId, String assistantId, JSONObject customInfo, Date createTime) {
        this.id = id;
        this.eventType = eventType;
        this.eventId = eventId;
        this.event = event;
        this.UserId = UserId;
        this.assistantId = assistantId;
        this.customInfo = customInfo;
        this.createTime = createTime;
    }
}

