/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.dto.conversation.ConversationQueryDto;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.LimitOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ConversationDao
extends CommonAsaMgDao<Conversation> {
    public static final String AGENT_ID_KEY = "agentId";
    public static final String CONVERSATION_ID_KEY = "conversationId";
    public static final String SORT_KEY = "updateTime";

    public ConversationDao(MongoTemplate template) {
        super(template);
        this.entityClass = Conversation.class;
    }

    public List<Conversation> queryUserConversation(AuthoredUser authoredUser, ConversationQueryDto dto) {
        Criteria criteria = this.baseCriteria(authoredUser.getTenantId(), authoredUser.getUserId());
        criteria.and("isAvailable").ne((Object)false);
        if (StringUtils.isNotEmpty((CharSequence)dto.getKeyword())) {
            criteria.and("title").regex("^.*" + dto.getKeyword() + ".*$");
        }
        if (StrUtil.isNotBlank((CharSequence)dto.getAgentId())) {
            criteria.and(AGENT_ID_KEY).is((Object)dto.getAgentId());
        }
        Query query = new Query((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)(dto.getPage() - 1), (int)dto.getPageSize(), (Sort)this.buildSort(true, SORT_KEY));
        query.with((Pageable)pageable);
        return super.findList(query);
    }

    public Long queryUserConversationCount(AuthoredUser authoredUser, String keyword) {
        Criteria criteria = this.baseCriteria(authoredUser.getTenantId(), authoredUser.getUserId());
        criteria.and("isAvailable").ne((Object)false);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            criteria.and("title").regex("^.*" + keyword + ".*$");
        }
        Query query = new Query((CriteriaDefinition)criteria);
        return super.count(query);
    }

    public Conversation queryConversationById(String conversationId, String userId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)CONVERSATION_ID_KEY).is((Object)conversationId).and("userId").is((Object)userId).and("status").is((Object)1));
        return (Conversation)super.findOne(query);
    }

    public boolean isExitConversation(String conversationId, String tenantId, String userId) {
        if (StringUtils.isBlank((CharSequence)conversationId)) {
            return false;
        }
        return super.count(new Query((CriteriaDefinition)this.baseCriteria(tenantId, userId).and(CONVERSATION_ID_KEY).is((Object)conversationId))) > 0L;
    }

    public List<Conversation> queryRecentAgents(List<String> agentIds, String tenantId, String userId, int limit) {
        if (limit <= 0) {
            return new ArrayList<Conversation>();
        }
        MatchOperation match = Aggregation.match((Criteria)this.baseCriteria(tenantId, userId).and(AGENT_ID_KEY).in(agentIds));
        SortOperation sort = Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{SORT_KEY});
        GroupOperation group = Aggregation.group((String[])new String[]{AGENT_ID_KEY}).first(AGENT_ID_KEY).as(AGENT_ID_KEY).first(SORT_KEY).as(SORT_KEY);
        SortOperation sortByRecent = Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{SORT_KEY});
        LimitOperation limitOp = Aggregation.limit((long)limit);
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, sort, group, sortByRecent, limitOp});
        AggregationResults results = this.template.aggregate(aggregation, this.entityClass, this.entityClass);
        return results.getMappedResults();
    }

    public Conversation queryLatestConversationByAgentId(String tenantId, String userId, String agentId) {
        Query query = new Query((CriteriaDefinition)this.baseCriteria(tenantId, userId).and(AGENT_ID_KEY).is((Object)agentId));
        query.with(this.buildSort(true, SORT_KEY));
        query.limit(1);
        return (Conversation)super.findOne(query);
    }

    public Criteria baseCriteria(String tenantId, String userId) {
        return super.baseCriteria(tenantId, userId).and("status").is((Object)1);
    }

    public Criteria baseCriteria(Criteria criteria, String tenantId, String userId) {
        return super.baseCriteria(criteria, tenantId, userId).and("status").is((Object)1);
    }

    public List<Conversation> findByAgentId(String agentId) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)AGENT_ID_KEY).is((Object)agentId));
        query.fields().include(CONVERSATION_ID_KEY);
        return super.findList(query);
    }
}

