/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionAddDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionDeleteDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantQuestionQueryDto;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantQuestionItem;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class FusionAssistantQuestionItemMgDao
extends CommonAsaMgDao<FusionAssistantQuestionItem> {
    public FusionAssistantQuestionItemMgDao(MongoTemplate template) {
        super(template);
        this.entityClass = FusionAssistantQuestionItem.class;
    }

    public Long find(FusionAssistantQuestionAddDto dto, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)dto.getAssistantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"question").is((Object)dto.getQuestion()));
        return this.template.count(query, this.entityClass);
    }

    public List<FusionAssistantQuestionItem> find(FusionAssistantQuestionQueryDto dto, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)dto.getAssistantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        return this.template.find(query, this.entityClass);
    }

    public Long count(String assistantId, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId));
        return this.template.count(query, this.entityClass);
    }

    public void remove(FusionAssistantQuestionDeleteDto dto, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in((Collection)dto.getIds()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)authoredUser.getTenantId()));
        this.template.remove(query, this.entityClass);
    }

    public List<FusionAssistantQuestionItem> findSkcListByAssistantId(String assistantId, String userId, int pageNum, int pageSize) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId));
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        }
        PageRequest pageable = PageRequest.of((int)(pageNum - 1), (int)pageSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createTime"}));
        query.with((Pageable)pageable);
        return this.template.find(query, this.entityClass);
    }
}

