/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.mongo.repository;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import com.digiwin.athena.ania.mongo.repository.CommonAsaMgDao;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class FusionAssistantSubMgDao
extends CommonAsaMgDao<FusionAssistantSub> {
    public FusionAssistantSubMgDao(MongoTemplate template) {
        super(template);
        this.entityClass = FusionAssistantSub.class;
    }

    public void deleteByAssistantIds(List<FusionAssistantSub> fusionAssistantSubs) {
        if (fusionAssistantSubs == null || fusionAssistantSubs.isEmpty()) {
            return;
        }
        Criteria criteria = new Criteria();
        Criteria[] subCriterias = new Criteria[fusionAssistantSubs.size()];
        for (int i = 0; i < fusionAssistantSubs.size(); ++i) {
            FusionAssistantSub fusionAssistantSub = fusionAssistantSubs.get(i);
            subCriterias[i] = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"assistantId").is((Object)fusionAssistantSub.getAssistantId()), Criteria.where((String)"version").is((Object)fusionAssistantSub.getVersion())});
        }
        criteria.orOperator(subCriterias);
        Query query = new Query((CriteriaDefinition)criteria);
        this.template.remove(query, FusionAssistantSub.class);
    }

    public List<FusionAssistantSub> find(JSONArray assistantsArray) {
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        for (int i = 0; i < assistantsArray.size(); ++i) {
            JSONObject jsonObject = assistantsArray.getJSONObject(i);
            String assistantId = jsonObject.getString("assistantId");
            String version = jsonObject.getString("version");
            Criteria criteria = Criteria.where((String)"assistantId").is((Object)assistantId).and("version").is((Object)version);
            criteriaList.add(criteria);
        }
        Query batchQuery = new Query();
        if (!criteriaList.isEmpty()) {
            batchQuery.addCriteria((CriteriaDefinition)new Criteria().orOperator(criteriaList.toArray(new Criteria[0])));
        }
        return this.template.find(batchQuery, this.entityClass);
    }

    public List<FusionAssistantSub> findByAssistantIds(List<String> assistantIds) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").in(assistantIds));
        return this.template.find(query, this.entityClass);
    }

    public FusionAssistantSub findByAssistantIdAndVersion(String assistantId, String version) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        return (FusionAssistantSub)this.template.findOne(query, this.entityClass);
    }
}

