/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.proxy.dmc.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.MidWareResponse;
import com.digiwin.athena.ania.configuration.DMCConfig;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.proxy.dmc.service.DmcService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DmcServiceImpl
implements DmcService {
    private static final Logger log = LoggerFactory.getLogger(DmcServiceImpl.class);
    private static final String ROOT_DIR_ID = "00000000-0000-0000-0000-000000000000";
    @Resource
    private EnvProperties envProperties;
    @Resource
    private RestTemplate restTemplate;
    @Autowired
    private DMCConfig dmcConfig;
    private static final String DMC_LOGIN_PATH = "/api/dmc/v1/auth/login";
    private static final String DMC_FILE_INFO_PATH = "/api/dmc/v2/fileinfo/intelligententry/ids";
    private static final long MAX_SIZE_PER_FILE = 0x6400000L;
    private static final long SEGMENT_FILE_SIZE = 0x5A00000L;
    private String token;

    public String getDmcToken() {
        if (StrUtil.isBlank((CharSequence)this.token)) {
            return this.loginDmc();
        }
        return this.token;
    }

    public String loginDmc() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("username", this.dmcConfig.getUserName());
        requestMap.put("pwdhash", this.dmcConfig.getPassword());
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getDmcUri()).append(DMC_LOGIN_PATH);
        try {
            log.info("loginDmc param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                String token = ((JSONObject)respEntity.getBody()).getString("userToken");
                return token;
            }
            log.error("loginDmc return fail, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            throw BusinessException.create((String)"loginDmc return fail");
        }
        catch (Exception ex) {
            log.error("loginDmc error, url:{}, errorMessage:{}", (Object)url, (Object)ex.getMessage());
            throw BusinessException.create((String)ex.getMessage());
        }
    }

    public JSONArray queryFileInfoList(List<String> fileIdList, String dmcUserToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", dmcUserToken);
        HttpEntity requestEntity = new HttpEntity(fileIdList, (MultiValueMap)headers);
        StringBuilder url = new StringBuilder(this.envProperties.getDmcUri()).append(DMC_FILE_INFO_PATH);
        try {
            log.info("query file info list, param:" + JSONObject.toJSONString((Object)requestEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url.toString(), HttpMethod.POST, requestEntity, JSONObject.class, new Object[0]);
            if (200 == respEntity.getStatusCodeValue() && respEntity.getBody() != null) {
                return ((JSONObject)respEntity.getBody()).getJSONArray("data");
            }
            log.info("query file info list return empty, url:{}, status:{}, response:{}", new Object[]{url, respEntity.getStatusCodeValue(), JSONObject.toJSONString((Object)respEntity.getBody())});
            return new JSONArray();
        }
        catch (Exception ex) {
            log.error("query file info list error, url:{}, errorMessage:{}", (Object)url, (Object)ex.getMessage());
            return new JSONArray();
        }
    }

    public Pair<String, Date> shareFile(String fileId, Integer expireDay) {
        ResponseEntity exchange;
        MidWareResponse midWareResponse;
        BaseUseUtils.businessException((boolean)StringUtils.isBlank((CharSequence)fileId), (String)"\u5206\u4eab\u6587\u4ef6Id\u4e0d\u80fd\u4e3a\u7a7a");
        String url = this.envProperties.getDmcUri() + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/share";
        HttpHeaders header = this.getCommonHeaders(MediaType.APPLICATION_JSON);
        JSONObject body = new JSONObject();
        body.put("fileId", (Object)fileId);
        Date expireDate = null;
        if (Objects.nonNull(expireDay) && expireDay > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, expireDay);
            expireDate = calendar.getTime();
            body.put("expireDate", (Object)DateUtil.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (Objects.equals(Boolean.TRUE, (midWareResponse = (MidWareResponse)(exchange = this.restTemplate.postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)header), MidWareResponse.class, new Object[0])).getBody()).getSuccess())) {
            return Pair.of((Object)MapUtils.getString((Map)((Map)midWareResponse.getData()), (Object)"url"), (Object)expireDate);
        }
        log.error("shareFile.is error msg:{}", (Object)midWareResponse.getMessage());
        return null;
    }

    public Pair<String, Date> shareFile(String fileId) {
        return this.shareFile(fileId, null);
    }

    public String upload(MultipartFile uploadFile, String fileName, String directoryId) throws IOException {
        String fileDisplayName = StringUtils.isBlank((CharSequence)fileName) ? uploadFile.getOriginalFilename() : fileName;
        byte[] bytes = IOUtils.toByteArray((InputStream)uploadFile.getInputStream());
        long fileSize = uploadFile.getSize();
        if (fileSize > 0x6400000L) {
            return this.uploadSegment(bytes, fileSize, uploadFile.getOriginalFilename(), fileDisplayName, directoryId, null);
        }
        return this.upload(bytes, uploadFile.getOriginalFilename(), fileDisplayName, directoryId, null);
    }

    private String uploadSegment(byte[] byteArray, long fileSize, String fileName, String fileDisplayName, String directoryId, Date expireDate) {
        String contentType = this.getContentTypeByFileName(fileName);
        String url = this.envProperties.getDmcUri() + "/api/dmc/v1/buckets/" + this.dmcConfig.getBucket() + "/files/segment";
        HttpHeaders header = this.getCommonHeaders(MediaType.APPLICATION_JSON);
        JSONObject body = new JSONObject();
        body.put("fileName", (Object)fileName);
        body.put("tag", (Object)fileDisplayName);
        if (StringUtils.isNotBlank((CharSequence)directoryId) && !ROOT_DIR_ID.equals(directoryId)) {
            body.put("directoryId", (Object)directoryId);
        }
        if (Objects.nonNull(expireDate)) {
            body.put("expireDate", (Object)DateUtil.format((Date)expireDate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        JSONObject metadata = new JSONObject();
        metadata.put("source", (Object)"ania");
        body.put("metadata", (Object)metadata);
        ResponseEntity exchange = this.restTemplate.postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)header), JSONObject.class, new Object[0]);
        JSONObject result = (JSONObject)exchange.getBody();
        if (Objects.nonNull(result)) {
            String fileId = result.getString("id");
            String segmentUrlFormat = this.envProperties.getDmcUri() + "/api/dmc/v1/buckets/" + this.dmcConfig.getBucket() + "/files/%s/%d/%d/%d";
            if (this.pushFileBySegment(byteArray, fileSize, segmentUrlFormat, fileId, contentType)) {
                return null;
            }
            return fileId;
        }
        log.error("DmcService.uploadSegment is error");
        return null;
    }

    private boolean pushFileBySegment(byte[] byteArray, long fileSize, String segmentUrlFormat, String fileId, String contentType) {
        long segmentCount = 0L;
        segmentCount = fileSize % 0x5A00000L == 0L ? fileSize / 0x5A00000L : fileSize / 0x5A00000L + 1L;
        long fileFrom = 0L;
        long fileTo = 0L;
        int segmentIndex = 0;
        while ((long)segmentIndex < segmentCount) {
            HttpEntity fileEntity;
            fileFrom = (long)segmentIndex * 0x5A00000L;
            fileTo = (long)segmentIndex != segmentCount - 1L ? (long)(segmentIndex + 1) * 0x5A00000L - 1L : fileSize - 1L;
            int segmentFileFrom = fileFrom == 0L ? 0 : (int)fileFrom;
            int segmentFileTo = fileTo != fileSize - 1L ? (int)(fileTo + 1L) : (int)fileSize;
            byte[] subByteArray = Arrays.copyOfRange(byteArray, segmentFileFrom, segmentFileTo);
            String segmentUrl = String.format(segmentUrlFormat, fileId, fileFrom, fileTo, fileSize);
            ResponseEntity fileResult = this.restTemplate.postForEntity(segmentUrl, (Object)(fileEntity = new HttpEntity((Object)new ByteArrayResource(subByteArray), (MultiValueMap)this.getCommonHeaders(MediaType.parseMediaType((String)contentType)))), JSONObject.class, new Object[0]);
            JSONObject segmentResponse = (JSONObject)fileResult.getBody();
            if (!Objects.nonNull(segmentResponse)) {
                log.error("DmcService.uploadSegment is error");
                return true;
            }
            log.debug("DMC Result : " + JSON.toJSONString((Object)segmentResponse));
            ++segmentIndex;
        }
        return false;
    }

    private String upload(byte[] byteArray, String fileName, String fileDisplayName, String directoryId, Date expireDate) {
        String contentType = this.getContentTypeByFileName(fileName);
        String dmcUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/upload";
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)contentType));
        fileHeader.setContentDispositionFormData("file", fileName);
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(byteArray), (MultiValueMap)fileHeader);
        HashMap<String, String> fileInfo = new HashMap<String, String>(3);
        fileInfo.put("displayName", fileDisplayName);
        fileInfo.put("description", "");
        if (StringUtils.isNotBlank((CharSequence)directoryId) && !ROOT_DIR_ID.equals(directoryId)) {
            fileInfo.put("directoryId", directoryId);
        }
        if (Objects.nonNull(expireDate)) {
            fileInfo.put("expireDate", DateUtil.format((Date)expireDate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        HttpEntity fileInfoEntity = new HttpEntity(fileInfo, (MultiValueMap)fileInfoHeader);
        multiValueMap.add((Object)"file", (Object)fileEntity);
        multiValueMap.add((Object)"fileInfo", (Object)fileInfoEntity);
        ResponseEntity postForEntity = this.restTemplate.postForEntity(dmcUrl, (Object)new HttpEntity((Object)multiValueMap, (MultiValueMap)this.getCommonHeaders(MediaType.MULTIPART_FORM_DATA)), MidWareResponse.class, new Object[0]);
        MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
        if (Objects.equals(Boolean.TRUE, midWareResponse.getSuccess())) {
            log.debug("DMC Result : " + JSON.toJSONString((Object)midWareResponse.getData()));
            return MapUtils.getString((Map)((Map)midWareResponse.getData()), (Object)"id");
        }
        log.error("DmcService.upload is error");
        return null;
    }

    private String getContentTypeByFileName(String fileName) {
        String contentType = URLConnection.guessContentTypeFromName(fileName);
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = new MimetypesFileTypeMap().getContentType(fileName);
        }
        return contentType;
    }

    public String cover(MultipartFile uploadFile, String fileId) throws IOException {
        BaseUseUtils.businessException((boolean)StringUtils.isBlank((CharSequence)fileId), (String)"\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        byte[] bytes = IOUtils.toByteArray((InputStream)uploadFile.getInputStream());
        String fileName = uploadFile.getOriginalFilename();
        long fileSize = uploadFile.getSize();
        if (fileSize > 0x6400000L) {
            return this.coverFileSegment(bytes, fileId, fileName, fileSize);
        }
        return this.coverFile(bytes, fileId, fileName);
    }

    private String coverFileSegment(byte[] byteArray, String fileId, String fileName, long fileSize) {
        BaseUseUtils.businessException((boolean)StringUtils.isBlank((CharSequence)fileId), (String)"\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        String contentType = this.getContentTypeByFileName(fileName);
        String segmentUrlFormat = this.envProperties.getDmcUri() + "/api/dmc/v1/buckets/" + this.dmcConfig.getBucket() + "/files/%s/%d/%d/%d/cover";
        if (this.pushFileBySegment(byteArray, fileSize, segmentUrlFormat, fileId, contentType)) {
            return null;
        }
        return fileId;
    }

    private String coverFile(byte[] byteArray, String fileId, String fileName) {
        String url = this.envProperties.getDmcUri() + "/api/dmc/v2/file/" + this.dmcConfig.getBucket() + "/upload/cover";
        String contentType = this.getContentTypeByFileName(fileName);
        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType((String)contentType));
        fileHeader.setContentDispositionFormData("file", fileName);
        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity fileEntity = new HttpEntity((Object)new ByteArrayResource(byteArray), (MultiValueMap)fileHeader);
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        multiValueMap.add((Object)"file", (Object)fileEntity);
        multiValueMap.add((Object)"fileId", (Object)fileId);
        ResponseEntity postForEntity = this.restTemplate.postForEntity(url, (Object)new HttpEntity((Object)multiValueMap, (MultiValueMap)this.getCommonHeaders(MediaType.MULTIPART_FORM_DATA)), MidWareResponse.class, new Object[0]);
        MidWareResponse midWareResponse = (MidWareResponse)postForEntity.getBody();
        if (Objects.equals(Boolean.TRUE, midWareResponse.getSuccess())) {
            return MapUtils.getString((Map)((Map)midWareResponse.getData()), (Object)"id");
        }
        log.error("DmcService.coverFile is error msg:{}", (Object)midWareResponse.getMessage());
        return null;
    }

    private HttpHeaders getCommonHeaders(MediaType mediaType) {
        String token = this.getDmcToken();
        String appToken = this.dmcConfig.getAppToken();
        HttpHeaders headers = new HttpHeaders();
        if (Objects.nonNull(mediaType)) {
            headers.setContentType(mediaType);
        }
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", appToken);
        return headers;
    }
}

