/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.scheduled;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.MessageTypeEnum;
import com.digiwin.athena.ania.configuration.RedisLock;
import com.digiwin.athena.ania.dto.TextMsg;
import com.digiwin.athena.ania.helper.IamHelper;
import com.digiwin.athena.ania.helper.MessageHelper;
import com.digiwin.athena.ania.mongo.domain.NewConversation;
import com.digiwin.athena.ania.mongo.repository.NewConversationMgDao;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class NewConversationScheduled {
    private static final Logger log = LoggerFactory.getLogger(NewConversationScheduled.class);
    @Autowired
    private IamHelper iamHelper;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private MessageHelper messageHelper;
    @Autowired
    private NewConversationMgDao newConversationMgDao;
    private static String LOCK_KEY = "NewConversationScheduled";

    @Scheduled(fixedRate=1800000L)
    public void newConversation() {
        String lock = this.redisLock.tryLock(LOCK_KEY, 180000L);
        try {
            if (StrUtil.isNotBlank((CharSequence)lock)) {
                this.handler();
            }
        }
        finally {
            if (Objects.nonNull(lock)) {
                this.redisLock.unlock(LOCK_KEY, lock);
            }
        }
    }

    private void handler() {
        List newConversations = this.newConversationMgDao.find();
        if (CollUtil.isNotEmpty((Collection)newConversations)) {
            for (int i = 0; i < newConversations.size(); ++i) {
                try {
                    NewConversation newConversation = (NewConversation)newConversations.get(i);
                    JSONObject msgExt = new JSONObject();
                    msgExt.put("messageType", (Object)MessageTypeEnum.NEW_CONVERSATION.getType());
                    msgExt.put("skillType", (Object)newConversation.getAssistantCode());
                    msgExt.put("token", (Object)this.iamHelper.getTenantToken(newConversation.getTenantId()));
                    TextMsg textMsg = new TextMsg("\u5f00\u542f\u65b0\u5bf9\u8bdd", newConversation.getAssistantCode());
                    textMsg.setFrom(newConversation.getFrom());
                    textMsg.setTo(newConversation.getTo());
                    textMsg.setExt((Map)msgExt);
                    this.messageHelper.pushTextMessage(textMsg);
                    this.newConversationMgDao.remove(newConversation.getFrom(), newConversation.getTo());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

