/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.ania.configuration.AssistanceAccountConfig;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.repository.AssistantDao;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AssistantServiceImpl
implements AssistantService {
    private static final Logger log = LoggerFactory.getLogger(AssistantServiceImpl.class);
    @Resource
    private AssistanceAccountConfig assistanceAccountConfig;
    @Resource
    private AssistantDao assistantDao;
    @Resource
    private AssistantSceneDao assistantSceneDao;
    @Resource
    private KmHelper kmHelper;
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    public Assistant getAssistant(String assistanceCode) {
        Assistant cacheAssistant;
        if (assistanceCode.equals("1")) {
            assistanceCode = "asada";
        }
        if (assistanceCode.equals("2")) {
            assistanceCode = "asaka";
        }
        if (assistanceCode.equals("3")) {
            assistanceCode = "asaaa";
        }
        if (assistanceCode.equals("4")) {
            assistanceCode = "asaca";
        }
        String tenantVersion = null;
        if (Objects.nonNull(AppAuthContextHolder.getContext().getAuthoredUser())) {
            tenantVersion = this.kmHelper.getTenantVersion(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        }
        return Objects.nonNull(cacheAssistant = this.getCacheAssistant(assistanceCode, tenantVersion)) ? cacheAssistant : this.getDbAssistant(assistanceCode, tenantVersion);
    }

    private Assistant getCacheAssistant(String assistanceCode, String tenantVersion) {
        String cacheAssistance = null;
        if (StringUtils.isBlank((CharSequence)tenantVersion)) {
            cacheAssistance = (String)this.redisTemplate.opsForValue().get((Object)("ANIA:HIS:ASSISTANT:1.0" + assistanceCode));
            if (StringUtils.isBlank((CharSequence)cacheAssistance)) {
                cacheAssistance = (String)this.redisTemplate.opsForValue().get((Object)("ANIA:HIS:ASSISTANT:2.0" + assistanceCode));
            }
        } else {
            cacheAssistance = (String)this.redisTemplate.opsForValue().get((Object)("ANIA:HIS:ASSISTANT:" + tenantVersion + assistanceCode));
        }
        if (StringUtils.isNotBlank((CharSequence)cacheAssistance)) {
            return (Assistant)JSON.parseObject((String)cacheAssistance, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        }
        return null;
    }

    public List<Assistant> batchGetCacheAssistant(List<String> assistanceCodeList, String tenantVersion) {
        ArrayList keys = new ArrayList();
        assistanceCodeList.stream().forEach(assistanceCode -> keys.add("ANIA:HIS:ASSISTANT:" + tenantVersion + assistanceCode));
        List cacheResults = this.redisTemplate.opsForValue().multiGet(keys);
        ArrayList<Assistant> assistantList = new ArrayList<Assistant>();
        if (CollectionUtils.isNotEmpty((Collection)cacheResults)) {
            cacheResults.stream().forEach(assistant -> {
                if (Objects.nonNull(assistant)) {
                    assistantList.add((Assistant)JSON.parseObject((String)assistant, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]));
                }
            });
        }
        return assistantList;
    }

    private Assistant getDbAssistant(String assistanceCode, String tenantVersion) {
        if (StringUtils.isBlank((CharSequence)tenantVersion)) {
            return this.assistantDao.findAllByAssistantCodeAndVersion(assistanceCode, "1.0");
        }
        return this.assistantDao.findAllByAssistantCodeAndVersion(assistanceCode, tenantVersion);
    }

    public String getAssistantAccount(String assistantCode) {
        String customerAccIdByAssistanceCode = this.assistanceAccountConfig.getCustomerAccIdByAssistanceCode(assistantCode);
        if (StringUtils.isNotBlank((CharSequence)customerAccIdByAssistanceCode)) {
            return customerAccIdByAssistanceCode;
        }
        Assistant cacheAssistant = this.getCacheAssistant(assistantCode, "1.0");
        if (Objects.nonNull(cacheAssistant)) {
            Map customerAccIdMap = this.assistanceAccountConfig.getCustomerAccIdMap();
            customerAccIdMap.put(assistantCode, cacheAssistant.getAccid());
            this.assistanceAccountConfig.setCustomerAccIdMap(customerAccIdMap);
            return cacheAssistant.getAccid();
        }
        Assistant allByAssistantCodeAndVersion = this.assistantDao.findAllByAssistantCodeAndVersion(assistantCode, "1.0");
        if (Objects.nonNull(allByAssistantCodeAndVersion)) {
            Map customerAccIdMap = this.assistanceAccountConfig.getCustomerAccIdMap();
            customerAccIdMap.put(assistantCode, allByAssistantCodeAndVersion.getAccid());
            this.assistanceAccountConfig.setCustomerAccIdMap(customerAccIdMap);
            this.redisTemplate.opsForValue().set((Object)("ASA_ASSISTANT_ACCOUNT_" + assistantCode), (Object)allByAssistantCodeAndVersion.getAccid());
            return allByAssistantCodeAndVersion.getAccid();
        }
        return null;
    }

    public List<AssistantScene> getAssistantSceneByAssistant(String assistanceCode, String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = this.kmHelper.getTenantVersion(AppAuthContextHolder.getContext().getAuthoredUser().getTenantId());
        }
        return this.assistantSceneDao.findAllByAssistantCodeAndVersion(assistanceCode, version);
    }

    public Assistant getAssistant(String assistanceCode, String tenantId, String tenantVersion) {
        if (StringUtils.isBlank((CharSequence)tenantVersion)) {
            tenantVersion = this.kmHelper.getTenantVersion(tenantId);
        }
        return this.getAssistant(assistanceCode, tenantVersion);
    }

    public Assistant getAssistant(String assistanceCode, String version) {
        Assistant cacheAssistant = this.getCacheAssistant(assistanceCode, version);
        return Objects.nonNull(cacheAssistant) ? cacheAssistant : this.assistantDao.findAllByAssistantCodeAndVersion(assistanceCode, version);
    }
}

