/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.assistant.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.PublishAssistantChannel;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantPublishDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.helper.CacHelper;
import com.digiwin.athena.ania.helper.FusionAgentHelper;
import com.digiwin.athena.ania.helper.dto.GetPublishedInfoDto;
import com.digiwin.athena.ania.mongo.domain.ApplicationAssistantRelation;
import com.digiwin.athena.ania.mongo.domain.FusionAssistant;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantPlugin;
import com.digiwin.athena.ania.mongo.domain.FusionAssistantSub;
import com.digiwin.athena.ania.mongo.repository.AppAssistantRelationDao;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantMgDao;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantSubMgDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantPluginService;
import com.digiwin.athena.ania.service.assistant.FusionAssistantRecordService;
import com.digiwin.athena.ania.service.assistant.SkcService;
import com.digiwin.athena.ania.service.assistant.strategy.PublishAssistantService;
import com.digiwin.athena.ania.util.LanguageUtils;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PublishAssistantServiceImpl
implements PublishAssistantService {
    private static final Logger log = LoggerFactory.getLogger(PublishAssistantServiceImpl.class);
    @Autowired
    private CacHelper cacHelper;
    @Autowired
    private SkcService skcService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private FusionAgentHelper fusionAgentHelper;
    @Autowired
    private FusionAssistantMgDao fusionAssistantMgDao;
    @Autowired
    private FusionAssistantSubMgDao fusionAssistantSubMgDao;
    @Autowired
    private FusionAssistantRecordService fusionAssistantRecordService;
    @Resource
    private AppAssistantRelationDao appAssistantRelationDao;
    @Autowired
    private FusionAssistantPluginService fusionAssistantPluginService;
    @Resource
    private ExecutorService publishAssistantExecutor;

    public Integer getAssistantType() {
        return AssistantType.PUBLISH_ASSISTANT.getType();
    }

    public void publish(FusionAssistantPublishDto dto) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        this.fusionAssistantRecordService.save(dto);
        Map publishedInfoDtoList = GetPublishedInfoDto.getPublishedInfoDtoList((FusionAssistantPublishDto)dto);
        JSONArray assistantsArray = new JSONArray();
        publishedInfoDtoList.forEach((k, v) -> {
            JSONArray assistants = this.fusionAgentHelper.getPublishedInfo(((GetPublishedInfoDto)v.get(0)).getBaseURL(), authoredUser.getToken(), v);
            if (!assistants.isEmpty()) {
                assistantsArray.addAll((Collection)assistants);
            }
        });
        FusionAssistantSub.publicAssistantDetailCheck((JSONArray)assistantsArray, (FusionAssistantPublishDto)dto);
        List fusionAssistants = this.fusionAssistantMgDao.findByAssistantIds(dto.getAssistantIds());
        List skcAssistantId = fusionAssistants.stream().filter(assistant -> PublishAssistantChannel.SKC.getCode().equals(assistant.getAccessChannel())).map(assistant -> assistant.getAssistantId()).collect(Collectors.toList());
        List fusionAssistantList = FusionAssistant.publish((List)fusionAssistants, (FusionAssistantPublishDto)dto, (JSONArray)assistantsArray);
        this.fusionAssistantMgDao.upsert(fusionAssistantList);
        List fusionAssistantSubs = FusionAssistantSub.publish((JSONArray)assistantsArray);
        this.fusionAssistantSubMgDao.deleteByAssistantIds(fusionAssistantSubs);
        this.fusionAssistantSubMgDao.insertAll((Collection)fusionAssistantSubs);
        List fusionAssistantPlugins = FusionAssistantPlugin.publish((List)fusionAssistantSubs);
        this.fusionAssistantPluginService.insertAll(fusionAssistantPlugins);
        this.addAssistantCache(fusionAssistantList);
        this.addAssistantSubCache(fusionAssistantSubs);
        this.publishAppAssistantRelation(fusionAssistantList);
        this.skcService.skcPublish(skcAssistantId, fusionAssistantSubs, dto);
    }

    private void publishAppAssistantRelation(List<FusionAssistant> fusionAssistantList) {
        if (CollectionUtils.isNotEmpty(fusionAssistantList)) {
            List collect = fusionAssistantList.stream().map(FusionAssistant::getAssistantId).distinct().collect(Collectors.toList());
            this.appAssistantRelationDao.delete(new Query((CriteriaDefinition)Criteria.where((String)"assistantId").in(collect)));
            this.appAssistantRelationDao.insertAll((Collection)collect.stream().map(assistantId -> ApplicationAssistantRelation.builder().appCode(assistantId).assistantId(assistantId).assistantType(AssistantType.PUBLISH_ASSISTANT.getType()).build()).collect(Collectors.toList()));
        }
    }

    private void addAssistantSubCache(List<FusionAssistantSub> assistantList) {
        CollUtil.emptyIfNull(assistantList).forEach(assistant -> {
            String key = "ANIA:ASSISTANT:SUB:" + assistant.getVersion() + assistant.getAssistantId();
            this.redisTemplate.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)assistant));
        });
    }

    private void addAssistantCache(List<FusionAssistant> assistantList) {
        CollUtil.emptyIfNull(assistantList).forEach(assistant -> {
            String key = "ANIA:PUBLISH:ASSISTANT:" + assistant.getAssistantId();
            this.redisTemplate.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)assistant));
        });
    }

    public void unPublish(FusionAssistantPublishDto dto) {
        this.fusionAssistantRecordService.save(dto);
        List events = dto.getEvent();
        for (int i = 0; i < events.size(); ++i) {
            JSONObject assistant = (JSONObject)events.get(i);
            String assistantId = assistant.getString("assistantId");
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistant.getString("assistantId")));
            this.fusionAssistantMgDao.update(query, new Update().set("isAvailable", (Object)false));
            this.skcService.updateAccessChannel(assistantId, null);
        }
    }

    private FusionAssistantVo findFusionAssistantVo(FusionAssistant fusionAssistant, String version, Boolean simple) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        FusionAssistantSub fusionAssistantSub = this.findFusionAssistantSub(fusionAssistant.getAssistantId(), version);
        if (!simple.booleanValue()) {
            JSONObject inspirationPhrases = this.fusionAgentHelper.getInspirationPhrases(fusionAssistant.getBaseURL(), authoredUser.getToken(), fusionAssistant.getAssistantId());
            if (null != inspirationPhrases && !inspirationPhrases.isEmpty()) {
                fusionAssistantSub.setInspirationPhrases(new JSONObject().fluentPut("intents", (Object)inspirationPhrases.getJSONArray("inspirationPhrases")));
            }
            fusionAssistantSub.setPluginCustoms(this.fusionAssistantPluginService.findPlugins(fusionAssistant.getAssistantId(), version));
            Boolean nnaAuth = this.skcService.getNnaAuth();
            if (nnaAuth.booleanValue()) {
                fusionAssistant.setAccessChannel(PublishAssistantChannel.SKC.getCode());
            } else {
                fusionAssistant.setAccessChannel(null);
            }
        }
        if (Objects.nonNull(fusionAssistantSub)) {
            return FusionAssistantVo.covertFusionAssistantVo((FusionAssistant)fusionAssistant, (FusionAssistantSub)fusionAssistantSub, (String)LanguageUtils.processLanguage());
        }
        return null;
    }

    public FusionAssistant findFusionAssistant(String assistantId) {
        Object fusionAssistantStr = this.redisTemplate.opsForValue().get((Object)("ANIA:PUBLISH:ASSISTANT:" + assistantId));
        if (Objects.nonNull(fusionAssistantStr)) {
            return (FusionAssistant)JSONUtil.toBean((String)fusionAssistantStr.toString(), FusionAssistant.class);
        }
        return this.fusionAssistantMgDao.findByAssistantId(assistantId);
    }

    public FusionAssistantSub findFusionAssistantSub(String assistantId, String version) {
        Object fusionAssistantSubStr = this.redisTemplate.opsForValue().get((Object)("ANIA:ASSISTANT:SUB:" + version + assistantId));
        if (Objects.nonNull(fusionAssistantSubStr)) {
            JSONUtil.toBean((String)fusionAssistantSubStr.toString(), FusionAssistantSub.class);
        }
        return this.fusionAssistantSubMgDao.findByAssistantIdAndVersion(assistantId, version);
    }

    public FusionAssistantVo assistantBaseInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        return this.queryFusionAssistantVo(param, authoredUser, true);
    }

    public FusionAssistantVo assistantDetailsInfo(FusionAssistantInfoDto param, AuthoredUser authoredUser) {
        return this.queryFusionAssistantVo(param, authoredUser, false);
    }

    private FusionAssistantVo queryFusionAssistantVo(FusionAssistantInfoDto param, AuthoredUser authoredUser, boolean simple) {
        if (BooleanUtils.isTrue((Boolean)param.getAuth()) && !this.cacHelper.hasApplicationAuth(authoredUser, param.getAssistantId())) {
            return null;
        }
        FusionAssistant fusionAssistant = this.findFusionAssistant(param.getAssistantId());
        if (Objects.isNull(fusionAssistant)) {
            return null;
        }
        String assistantVersion = param.getVersion();
        if (StringUtils.isBlank((CharSequence)assistantVersion)) {
            assistantVersion = CollectionUtils.isNotEmpty((Collection)fusionAssistant.getVersions()) && fusionAssistant.getVersions().size() == 1 ? (String)fusionAssistant.getVersions().stream().findFirst().get() : this.fusionAgentHelper.getAssistantVersion(fusionAssistant.getBaseURL(), authoredUser.getToken(), fusionAssistant.getAssistantId());
        }
        return this.findFusionAssistantVo(fusionAssistant, assistantVersion, Boolean.valueOf(simple));
    }

    public List<FusionAssistantVo> assistantList(AuthoredUser authoredUser, List<String> currentAppCodes, String clientType, Boolean simple) {
        List assistants;
        if (CollectionUtils.isEmpty(currentAppCodes)) {
            return Collections.emptyList();
        }
        List publishAssistants = this.appAssistantRelationDao.queryAssistant(currentAppCodes, AssistantType.PUBLISH_ASSISTANT.getType().intValue());
        if (CollectionUtils.isEmpty((Collection)publishAssistants)) {
            return Collections.emptyList();
        }
        Criteria criteria = Criteria.where((String)"assistantId").in((Collection)publishAssistants).and("isAvailable").is((Object)true);
        if (StringUtils.isNotBlank((CharSequence)clientType)) {
            criteria.and("clientType").in(new Object[]{clientType});
        }
        if (CollectionUtils.isEmpty((Collection)(assistants = this.fusionAssistantMgDao.findList(new Query((CriteriaDefinition)criteria))))) {
            return Collections.emptyList();
        }
        ArrayList<Future> futures = new ArrayList<Future>();
        String langName = LocaleContextHolder.getLocale().toLanguageTag();
        for (FusionAssistant fusionAssistant : assistants) {
            Future future = this.publishAssistantExecutor.submit(() -> {
                try {
                    LocaleContextHolder.setLocale((Locale)Locale.forLanguageTag(langName));
                    String assistantVersion = CollectionUtils.isNotEmpty((Collection)fusionAssistant.getVersions()) && fusionAssistant.getVersions().size() == 1 ? (String)fusionAssistant.getVersions().stream().findFirst().get() : this.fusionAgentHelper.getAssistantVersion(fusionAssistant.getBaseURL(), authoredUser.getToken(), fusionAssistant.getAssistantId());
                    FusionAssistantVo fusionAssistantVo = this.findFusionAssistantVo(fusionAssistant, assistantVersion, simple);
                    return fusionAssistantVo;
                }
                finally {
                    LocaleContextHolder.resetLocaleContext();
                }
            });
            futures.add(future);
        }
        ArrayList<FusionAssistantVo> assistantList = new ArrayList<FusionAssistantVo>();
        for (Future future : futures) {
            try {
                assistantList.add((FusionAssistantVo)future.get());
            }
            catch (Exception e) {
                log.warn("\u83b7\u53d6\u53d1\u5e03\u52a9\u7406\u5931\u8d25", (Throwable)e);
            }
        }
        return assistantList;
    }
}

