/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.brush;

import com.digiwin.athena.ania.aspect.Lock;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.mongo.domain.ApplicationAssistantRelation;
import com.digiwin.athena.ania.mongo.domain.FusionAssistant;
import com.digiwin.athena.ania.mongo.repository.AppAssistantRelationDao;
import com.digiwin.athena.ania.mongo.repository.FusionAssistantMgDao;
import com.digiwin.athena.ania.service.assistant.strategy.HistoryAssistantService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class BrushAppAssistantRelationComponent {
    private static final Logger log = LoggerFactory.getLogger(BrushAppAssistantRelationComponent.class);
    @Resource
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    @Resource
    private HistoryAssistantService historyAssistantService;
    @Resource
    private FusionAssistantMgDao fusionAssistantMgDao;
    @Resource
    private AppAssistantRelationDao appAssistantRelationDao;

    @Lock(key="BrushAppAssistantRelationComponent:hisAppAssistantRelation", expire=30000L)
    public void hisAppAssistantRelation(String assistantCode) {
        if (StringUtils.isNotBlank((CharSequence)assistantCode)) {
            this.historyAssistantService.publish(assistantCode);
            return;
        }
        Set allAssistantIds = this.getAllAssistantIds();
        if (CollectionUtils.isNotEmpty((Collection)allAssistantIds)) {
            for (String assistantId : allAssistantIds) {
                this.historyAssistantService.publish(assistantId);
            }
        }
    }

    @Lock(key="BrushAppAssistantRelationComponent:publishAppAssistantRelation", expire=30000L)
    public void publishAppAssistantRelation(String assistantId) {
        List fusionAssistants;
        Criteria criteria = Criteria.where((String)"isAvailable").is((Object)true);
        if (StringUtils.isNotBlank((CharSequence)assistantId)) {
            criteria.and("assistantId").is((Object)assistantId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(fusionAssistants = this.fusionAssistantMgDao.findList(new Query((CriteriaDefinition)criteria))))) {
            for (FusionAssistant assistant : fusionAssistants) {
                this.appAssistantRelationDao.delete(new Query((CriteriaDefinition)Criteria.where((String)"assistantId").is((Object)assistantId)));
                this.appAssistantRelationDao.insert((Object)ApplicationAssistantRelation.builder().appCode(assistant.getAssistantId()).assistantId(assistant.getAssistantId()).assistantType(AssistantType.PUBLISH_ASSISTANT.getType()).build());
            }
        }
    }

    private Set<String> getAllAssistantIds() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"status").is((Object)1).and("assistantType").is((Object)1)), Aggregation.group((String[])new String[]{"assistantCode"}), Aggregation.project((String[])new String[0]).and("_id").as("assistantCode")});
        AggregationResults results = this.mongoTemplate.aggregate(agg, "assistant", Document.class);
        HashSet<String> allAssistantIds = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)results.getMappedResults())) {
            for (Document doc : results.getMappedResults()) {
                allAssistantIds.add(doc.getString((Object)"assistantCode"));
            }
        }
        return allAssistantIds;
    }
}

