/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.chat;

import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.configuration.RedisLock;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.ConversationDao;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.service.conversation.ConversationMessageService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.ania.service.notice.NoticeService;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class BaseEmitterChatComponent {
    private static final Logger log = LoggerFactory.getLogger(BaseEmitterChatComponent.class);
    @Resource
    protected SseEventDataService sseEventDataService;
    @Resource
    protected MessageUtils messageUtils;
    @Resource
    protected ConversationDao conversationDao;
    protected Map<Integer, SseFlow> flowMap;
    @Resource
    protected NoticeService noticeService;
    @Resource
    protected RedisLock redisLock;
    @Resource
    protected ConversationIndexService conversationIndexService;
    @Resource
    protected ConversationService conversationService;
    @Resource
    protected ConversationMessageService conversationMessageService;

    protected String errorAnswer(SseEventParams sseEventParam, Throwable t) {
        String answer = null;
        if (Objects.nonNull(t)) {
            String message;
            if (t instanceof BusinessException) {
                BusinessException businessException = (BusinessException)t;
                answer = businessException.getDescription();
            } else if (t instanceof IOException && (message = t.getMessage()) != null && (message.startsWith("Broken pipe") || message.startsWith("\u4f60\u7684\u4e3b\u673a\u4e2d\u7684\u8f6f\u4ef6\u4e2d\u6b62\u4e86\u4e00\u4e2a\u5df2\u5efa\u7acb\u7684\u8fde\u63a5"))) {
                RedisUtils.cacheStrData((String)("ANIA:ASSISTANT:CANCEL:CHAT:" + sseEventParam.getQuestionMessage().getMessageId()), (String)sseEventParam.getQuestionMessage().getConversationId(), (long)5L, (TimeUnit)TimeUnit.MINUTES);
                return LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u60a8\u5df2\u7ec8\u6b62\u5bf9\u8bdd" : "\u60a8\u5df2\u7d42\u6b62\u5c0d\u8a71";
            }
        }
        if (StringUtils.isEmpty(answer)) {
            answer = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u52a9\u7406\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u52a9\u7406\u5f02\u5e38\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
        }
        return answer;
    }

    protected void updateConversationTime(String conversationId, long updateTime) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)conversationId));
        this.conversationDao.update(query, new Update().set("updateTime", (Object)updateTime));
    }

    protected void readMessage(ConversationMessage questionMessage) {
        this.conversationIndexService.updateConversationReadIndex(questionMessage.getUserId(), questionMessage.getConversationId(), questionMessage.getIndex().intValue());
    }
}

