/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.chat;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.TtlRunnable;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.ConversationTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.MessageTypeEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.common.enums.notice.MessageAction;
import com.digiwin.athena.ania.knowledge.context.KnowledgeContext;
import com.digiwin.athena.ania.knowledge.context.RichSseEmitter;
import com.digiwin.athena.ania.knowledge.context.SseEventContext;
import com.digiwin.athena.ania.knowledge.intentflow.FlowContent;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.intentflow.dto.IntentFlowEventData;
import com.digiwin.athena.ania.knowledge.server.AssistantSSeComponent;
import com.digiwin.athena.ania.knowledge.server.SseEventDataService;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import com.digiwin.athena.ania.service.chat.BaseEmitterChatComponent;
import com.digiwin.athena.ania.service.chat.SseEmitterHisChatComponent;
import com.digiwin.athena.ania.service.message.HisConversationMessageService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.DateUtils;
import com.digiwin.athena.ania.util.EventMessageUtils;
import com.digiwin.athena.ania.util.IdSnowflake;
import com.digiwin.athena.ania.util.MdcUtil;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.ania.util.SseEmitterUtils;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.navercorp.pinpoint.sdk.v1.concurrent.TraceRunnable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import okhttp3.sse.EventSource;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class SseEmitterHisChatComponent
extends BaseEmitterChatComponent {
    private static final Logger log = LoggerFactory.getLogger(SseEmitterHisChatComponent.class);
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    protected RedisTemplate<String, String> redisTemplate;
    @Resource
    private HisConversationMessageService hisConversationMessageService;
    @Resource
    private SseEventDataService sseEventDataService;
    @Resource
    private AssistantSSeComponent assistantSSeComponent;
    @Resource
    private AssistantSceneDao assistantSceneDao;
    @Resource
    private Executor taskExecutorKnow;

    @Autowired
    public void setFlowMap(List<SseFlow> sseFlows) {
        this.flowMap = new HashMap(sseFlows.size());
        sseFlows.forEach(flow -> this.flowMap.put(flow.getFlowType().getFlowEventType(), flow));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichSseEmitter chatAction(SseEventParams sseEventParam) {
        Conversation conversation = this.conversationService.getConversation(sseEventParam.getQuestion().getConversationId(), ConversationTypeEnum.LONG, sseEventParam.getUser().getTenantId(), sseEventParam.getUser().getUserId());
        if (Objects.isNull(conversation)) {
            throw BusinessException.create((String)"conversation is not exist");
        }
        if (!conversation.getAgentId().equals(sseEventParam.getQuestion().getAssistantCode()) || !Objects.equals(AssistantType.HISTORY_ASSISTANT.getType(), conversation.getConversationType())) {
            throw BusinessException.create((String)"conversation is not exist");
        }
        String tryLock = null;
        String lockKey = "ania:his:chat:" + conversation.getConversationId();
        try {
            tryLock = this.redisLock.tryLock(lockKey, 5000L);
            if (Objects.isNull(tryLock) || RedisUtils.hasStrDataKey((String)("ANIA:ASSISTANT:CHAT:" + conversation.getConversationId())).booleanValue()) {
                throw BusinessException.create((String)"{\n  \"error_type\": \"chat.user_pushing\",\n  \"message\": \"\u53d1\u9001\u9891\u7387\u8fc7\u9ad8\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5.\"\n}");
            }
            String messageId = IdSnowflake.snowflakeIdStr();
            String answerMessageId = IdSnowflake.snowflakeIdStr();
            RedisUtils.cacheStrData((String)("ANIA:ASSISTANT:CHAT:" + conversation.getConversationId()), (String)messageId, (long)5L, (TimeUnit)TimeUnit.MINUTES);
            ConversationMessage questionMessage = new ConversationMessage(messageId, conversation.getSectionId(), sseEventParam.getQuestion(), sseEventParam.getUser());
            this.conversationMessageService.sendMessage(questionMessage);
            this.readMessage(questionMessage);
            Integer answerMessageIndex = this.conversationIndexService.incrementIndex(questionMessage.getUserId(), questionMessage.getConversationId());
            this.updateConversationTime(conversation.getConversationId(), questionMessage.getUpdateTime().longValue());
            conversation.setUpdateTime(questionMessage.getUpdateTime());
            sseEventParam.setQuestionMessage(questionMessage);
            sseEventParam.setAnswerMessageIndex(answerMessageIndex);
            sseEventParam.setAnswerMessageId(answerMessageId);
            RichSseEmitter sseEmitter = new RichSseEmitter(Long.valueOf(300000L));
            sseEventParam.setId(questionMessage.getMessageId());
            KnowledgeContext.setSseEmitter((String)sseEventParam.getId(), (SseEmitter)sseEmitter);
            sseEmitter.onTimeout(TraceRunnable.asyncEntry(() -> this.sseEmitterTimeout(sseEventParam)));
            sseEmitter.onError(throwable -> this.sseEmitterError(sseEventParam, throwable));
            sseEmitter.onCompletion(TraceRunnable.asyncEntry(() -> this.sseEmitterCompletion(sseEventParam)));
            sseEmitter.setSseEventParams(sseEventParam);
            CompletableFuture.runAsync((Runnable)Objects.requireNonNull(TtlRunnable.get((Runnable)new AssistantChatAction(this, sseEventParam, null))), this.taskExecutorKnow);
            RichSseEmitter richSseEmitter = sseEmitter;
            return richSseEmitter;
        }
        finally {
            if (Objects.nonNull(tryLock)) {
                this.redisLock.unlock(lockKey, tryLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sseEmitterError(SseEventParams sseEventParam, Throwable t) {
        block9: {
            MdcUtil.setTraceId((String)sseEventParam.getTraceId());
            log.error("SseEmitterHisChatComponent.ErrorCallback sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)t);
            try {
                EventData functionCall;
                EventSource knowledgeEventSource = KnowledgeContext.getKnowledgeEventSource((String)sseEventParam.getId());
                if (knowledgeEventSource != null) {
                    knowledgeEventSource.cancel();
                }
                if (Objects.nonNull(functionCall = SseEventContext.lastFunctionCall((String)sseEventParam.getId()))) {
                    IntentFlowEventData.IntentEventMessage intentEventMessage = (IntentFlowEventData.IntentEventMessage)functionCall.getData();
                    Integer flowEventType = intentEventMessage.getExtra_info().getInteger("flow_event_type");
                    FlowContent.flowEnd((Map)this.flowMap, (SseEventParams)sseEventParam, (Integer)flowEventType, (String)("\u5f02\u5e38\u7ec8\u6b62" + t.getMessage()));
                }
                String answer = this.errorAnswer(sseEventParam, t);
                if (SseEventContext.noSupplyTerminate((String)sseEventParam.getId())) break block9;
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
                try {
                    this.sseEventDataService.saveEventDataLog(sseEventParam, eventData);
                    SseEmitterUtils.send((String)sseEventParam.getId(), (EventData)eventData);
                }
                catch (Exception e) {
                    log.error("SseEmitterHisChatComponent.ErrorCallback send error", (Throwable)e);
                }
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)eventData);
            }
            catch (Exception e) {
                log.error("SseEmitterHisChatComponent.ErrorCallback is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
            }
            finally {
                this.stop(sseEventParam);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sseEmitterTimeout(SseEventParams sseEventParam) {
        log.info("SseEmitterHisChatComponent.SseEmitterTimeout sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
        try {
            MdcUtil.setTraceId((String)sseEventParam.getTraceId());
            EventSource knowledgeEventSource = KnowledgeContext.getKnowledgeEventSource((String)sseEventParam.getId());
            if (knowledgeEventSource != null) {
                knowledgeEventSource.cancel();
            }
            if (!SseEventContext.noSupplyTerminate((String)sseEventParam.getId())) {
                String answer = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u60a8\u8bf7\u6c42\u8bbf\u95ee\u7684\u52a9\u7406\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff0c\u5982\u679c\u95ee\u9898\u6301\u7eed\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u79df\u6237\u7ba1\u7406\u5458\u6216\u987e\u95ee\u54a8\u8be2\u3002" : "\u62b1\u6b49\uff0c\u60a8\u8acb\u6c42\u8a2a\u554f\u7684\u52a9\u7406\u5f02\u5e38\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\uff0c\u5982\u679c\u554f\u984c\u6301\u7e8c\uff0c\u8acb\u806f\u7cfb\u60a8\u7684\u79df\u6236\u7ba1\u7406\u54e1\u6216\u9867\u554f\u8aee\u8a62\u3002";
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), answer);
                this.sseEventDataService.saveEventDataLog(sseEventParam, eventData);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)eventData);
            }
        }
        catch (Exception ex) {
            log.error("SseEmitterHisChatComponent.TimeoutCallback is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
        finally {
            this.stop(sseEventParam);
            MdcUtil.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sseEmitterCompletion(SseEventParams sseEventParam) {
        ArrayList<EventData> answer = null;
        try {
            ConversationMessage answerMessage;
            List deltaFileAnswer;
            RedisUtils.deleteCacheStrData((String)("ANIA:ASSISTANT:CHAT:" + sseEventParam.getQuestionMessage().getConversationId()));
            MdcUtil.setTraceId((String)sseEventParam.getTraceId());
            KnowledgeContext.removeSseEmitter((String)sseEventParam.getId());
            answer = SseEventContext.getAnswer((String)sseEventParam.getId());
            SseEventContext.removeAnswer((String)sseEventParam.getId());
            if (Objects.isNull(answer)) {
                answer = new ArrayList<EventData>();
            }
            if (!SseEventContext.noSupplyTerminate((List)answer)) {
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), "\u60a8\u5df2\u505c\u6b62\u751f\u6210\u7b54\u6848");
                this.sseEventDataService.saveEventDataLog(sseEventParam, eventData);
                answer.add(eventData);
            }
            log.info("SseEmitterHisChatComponent.CompletionCallback send sseEventParam:{},answer:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), answer);
            String assistantSceneData = (String)this.redisTemplate.opsForValue().get((Object)("ANIA_QUESTION_" + sseEventParam.getId()));
            Integer type = null;
            String assistantSceneCode = null;
            if (StringUtils.isNotBlank((CharSequence)assistantSceneData)) {
                JSONObject sceneData = JSON.parseObject((String)assistantSceneData);
                type = MapUtils.getInteger((Map)sceneData, (Object)"type");
                assistantSceneCode = MapUtils.getString((Map)sceneData, (Object)"sceneCodes");
            }
            String combinationMsg = (String)this.redisTemplate.opsForValue().get((Object)("ANIA_QUESTION_CBT_" + sseEventParam.getId()));
            AsaKnowledgeMessage asaKnowledgeMessage = new AsaKnowledgeMessage();
            asaKnowledgeMessage.setTraceId(sseEventParam.getTraceId());
            asaKnowledgeMessage.setAssistantCode(sseEventParam.getQuestion().getAssistantCode());
            asaKnowledgeMessage.setAssistantSceneCode(assistantSceneCode);
            asaKnowledgeMessage.setSceneType(type);
            asaKnowledgeMessage.setCreateTime(DateUtils.getNowTime(null));
            asaKnowledgeMessage.setCardList(SseEventContext.getCardList((SseEventParams)sseEventParam, answer));
            StringBuilder msg = new StringBuilder();
            List deltaTextAnswer = SseEventContext.getMessageByType(answer, (SseEventlEnum.EventDataMessageEnum)SseEventlEnum.EventDataMessageEnum.TEXT);
            for (EventData data : deltaTextAnswer) {
                if (!SseEventlEnum.MESSAGE_DELTA.getEvent().equals(data.getEvent())) continue;
                msg.append(data.getData().getMessage());
            }
            if (SseEventContext.canceled(answer)) {
                String terminateMsg;
                String string = terminateMsg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u60a8\u5df2\u7ec8\u6b62\u5bf9\u8bdd" : "\u60a8\u5df2\u7d42\u6b62\u5c0d\u8a71";
                if (Integer.valueOf(1).equals(type) && CollUtil.isEmpty((Collection)asaKnowledgeMessage.getCardList())) {
                    msg.append(terminateMsg);
                } else if (StrUtil.isBlank((CharSequence)msg)) {
                    msg.append(terminateMsg);
                }
                asaKnowledgeMessage.setCanceled(Boolean.valueOf(true));
            }
            if (CollUtil.isNotEmpty((Collection)(deltaFileAnswer = SseEventContext.getMessageByType(answer, (SseEventlEnum.EventDataMessageEnum)SseEventlEnum.EventDataMessageEnum.FILE)))) {
                JSONArray jsonArray = new JSONArray();
                for (EventData data : deltaFileAnswer) {
                    String fileData = data.getData().getMessage();
                    JSONArray fileDataJsonArray = JSONArray.parseArray((String)fileData);
                    jsonArray.addAll((Collection)fileDataJsonArray);
                }
                asaKnowledgeMessage.setReferencedAttachments(jsonArray);
            }
            ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
            asaKnowledgeMessage.setMsg(msg.toString());
            asaKnowledgeMessage.setCombinationMsg(combinationMsg);
            asaKnowledgeMessage.setQuestion(sseEventParam.getQuestion().getMessage().getText());
            asaKnowledgeMessage.setMsgId(questionMessage.getLocalMessageId());
            asaKnowledgeMessage.setUserId(sseEventParam.getUser().getUserId());
            asaKnowledgeMessage.setTenantId(sseEventParam.getUser().getTenantId());
            asaKnowledgeMessage.setFinish(Boolean.valueOf(answer.stream().anyMatch(item -> SseEventlEnum.CHAT_DONE.getEvent().equals(item.getEvent()))));
            asaKnowledgeMessage.setFunctionList(SseEventContext.functionList(answer));
            asaKnowledgeMessage = (AsaKnowledgeMessage)this.asaKnowledgeMessageDao.save((Object)asaKnowledgeMessage);
            String selectScenes = (String)this.redisTemplate.opsForValue().get((Object)("ANIA_QUESTION_MULTIPLE_" + sseEventParam.getId()));
            if (StringUtils.isNotBlank((CharSequence)selectScenes)) {
                answerMessage = this.multipleIntentions(sseEventParam, asaKnowledgeMessage, selectScenes);
            } else {
                this.hiddenMultipleIntentAfterMsg(sseEventParam);
                JSONObject msgExt = new JSONObject(questionMessage.getExt());
                msgExt.put("contentId", (Object)asaKnowledgeMessage.getId());
                msgExt.put("messageBusinessCode", (Object)"assistantQuestion");
                msgExt.put("sceneType", (Object)asaKnowledgeMessage.getSceneType());
                msgExt.put("streamFile", (Object)sseEventParam.getQuestion().getMessage().getContent());
                msgExt.put("tenantId", (Object)sseEventParam.getUser().getTenantId());
                msgExt.fluentPut("traceId", (Object)sseEventParam.getTraceId());
                JSONObject answerContent = new JSONObject();
                answerContent.fluentPut("contentId", (Object)asaKnowledgeMessage.getId());
                answerContent.fluentPut("showType", (Object)1);
                answerContent.fluentPut("knowledgeAssistantCode", (Object)sseEventParam.getQuestion().getAssistantCode());
                if (Objects.nonNull(sseEventParam.getAssistant())) {
                    answerContent.fluentPut("assistantSubType", (Object)sseEventParam.getAssistant().getAssistantSubType());
                }
                answerContent.fluentPut("replyId", (Object)questionMessage.getMessageId());
                answerMessage = ConversationMessage.builder().messageId(sseEventParam.getAnswerMessageId()).index(sseEventParam.getAnswerMessageIndex()).replyId(questionMessage.getMessageId()).conversationId(questionMessage.getConversationId()).agentId(questionMessage.getAgentId()).localMessageId(questionMessage.getLocalMessageId()).msgType(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar()).sectionId(questionMessage.getSectionId()).tenantId(sseEventParam.getUser().getTenantId()).userId(sseEventParam.getUser().getUserId()).msgBody(answerContent).ext((Map)msgExt).msgExt(JSONUtil.toJsonStr((Object)msgExt)).createTime(Long.valueOf(System.currentTimeMillis())).userType(2).status(Integer.valueOf(1)).build();
            }
            EventMessageUtils.buildHisStreamContent((ConversationMessage)answerMessage, (AsaKnowledgeMessage)asaKnowledgeMessage, answer);
            if (RedisUtils.hasStrDataKey((String)("ANIA:ASSISTANT:CANCEL:CHAT:" + sseEventParam.getQuestionMessage().getMessageId())).booleanValue()) {
                answerMessage.setStatus(Integer.valueOf(3));
            }
            this.conversationMessageService.sendMessage(answerMessage);
            if (Objects.equals(1, questionMessage.getIndex())) {
                this.noticeService.conversationEvent(MessageAction.CREATED, Conversation.builder().conversationId(questionMessage.getConversationId()).agentId(questionMessage.getAgentId()).tenantId(questionMessage.getTenantId()).userId(questionMessage.getUserId()).build());
            }
        }
        catch (Exception e) {
            log.info("SseEmitterHisChatComponent.CompletionCallback is error send sseEventParam:{},answer:{}", new Object[]{BaseUseUtils.toJsonString((Object)sseEventParam), BaseUseUtils.toJsonString(answer), e});
        }
        finally {
            EventSource knowledgeEventSource = KnowledgeContext.getKnowledgeEventSource((String)sseEventParam.getId());
            KnowledgeContext.removeKnowledgeEventSource((String)sseEventParam.getId());
            if (knowledgeEventSource != null) {
                knowledgeEventSource.cancel();
            }
            MdcUtil.clear();
        }
    }

    public ConversationMessage multipleIntentions(SseEventParams sseEventParam, AsaKnowledgeMessage asaKnowledgeMessage, String selectScenes) {
        String[] sceneCodeList;
        Assistant assistant = sseEventParam.getAssistant();
        ArrayList<AssistantScene> sceneList = new ArrayList<AssistantScene>();
        for (String code : sceneCodeList = selectScenes.split("_")) {
            AssistantScene assistantScene = this.assistantSceneDao.findAllByAssistantCodeAndCodeAndVersion(asaKnowledgeMessage.getAssistantCode(), code, assistant.getVersion());
            if (!Objects.nonNull(assistantScene)) continue;
            sceneList.add(assistantScene);
        }
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        HashMap<String, ArrayList<AssistantScene>> dataSceneMap = new HashMap<String, ArrayList<AssistantScene>>(sceneCodeList.length);
        ArrayList<JSONObject> selectSceneData = new ArrayList<JSONObject>();
        String athenaUserLanguage = sseEventParam.getLanguage();
        for (AssistantScene assistantScene : sceneList) {
            if (Objects.equals(1, assistantScene.getType())) {
                JSONObject dataMetric = assistantScene.getDataMetric();
                String application = dataMetric.getString("application");
                ArrayList<AssistantScene> assistantScenes = (ArrayList<AssistantScene>)dataSceneMap.get(application);
                if (Objects.isNull(assistantScenes)) {
                    assistantScenes = new ArrayList<AssistantScene>();
                }
                assistantScenes.add(assistantScene);
                dataSceneMap.put(application, assistantScenes);
                continue;
            }
            Map lang = assistantScene.getLang();
            String name = MapUtils.getString((Map)((Map)lang.get("name")), (Object)athenaUserLanguage, (String)assistantScene.getName());
            JSONObject data = new JSONObject().fluentPut("key", (Object)assistantScene.getCode()).fluentPut("name", (Object)name).fluentPut("type", (Object)assistantScene.getType());
            selectSceneData.add(data);
        }
        if (MapUtils.isNotEmpty(dataSceneMap)) {
            for (Map.Entry entry : dataSceneMap.entrySet()) {
                ArrayList<String> keys = new ArrayList<String>();
                List value = (List)entry.getValue();
                ArrayList<JSONObject> child = new ArrayList<JSONObject>();
                StringBuilder nameString = new StringBuilder();
                for (AssistantScene scene : value) {
                    keys.add(scene.getCode());
                    Map lang = scene.getLang();
                    String name = MapUtils.getString((Map)((Map)lang.get("name")), (Object)athenaUserLanguage, (String)scene.getName());
                    child.add(new JSONObject().fluentPut("key", (Object)scene.getCode()).fluentPut("name", (Object)name));
                    if (nameString.length() > 0) {
                        nameString.append("_");
                    }
                    nameString.append(name);
                }
                String application = (String)entry.getKey();
                JSONObject data = new JSONObject().fluentPut("key", (Object)application).fluentPut("name", (Object)nameString.toString()).fluentPut("type", (Object)1).fluentPut("child", child);
                selectSceneData.add(data);
            }
        }
        JSONObject message = new JSONObject();
        message.put("executeContext", (Object)new JSONObject().fluentPut("contentId", (Object)asaKnowledgeMessage.getId()).fluentPut("rtMsgServerId", (Object)questionMessage.getMessageId()).fluentPut("combinationMsg", (Object)asaKnowledgeMessage.getCombinationMsg()).fluentPut("text", (Object)asaKnowledgeMessage.getQuestion()));
        message.put("value", (Object)new JSONObject().fluentPut("data", selectSceneData));
        message.put("messageType", (Object)MessageTypeEnum.MULTIPLE_INTENTIONS.getType());
        message.put("messageBusinessCode", (Object)"ania_multiple_intentions");
        message.put("title", (Object)this.messageUtils.getMessageByLangName("600.0272", athenaUserLanguage));
        return ConversationMessage.builder().messageId(sseEventParam.getAnswerMessageId()).index(sseEventParam.getAnswerMessageIndex()).replyId(questionMessage.getMessageId()).conversationId(questionMessage.getConversationId()).localMessageId(questionMessage.getLocalMessageId()).msgType(ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar()).sectionId(questionMessage.getSectionId()).tenantId(sseEventParam.getUser().getTenantId()).userId(sseEventParam.getUser().getUserId()).msgBody(message).ext((Map)asaKnowledgeMessage.getExt()).userType(2).status(Integer.valueOf(1)).build();
    }

    private void hiddenMultipleIntentAfterMsg(SseEventParams sseEventParam) {
        JSONObject selectScene = sseEventParam.getQuestion().getSelectScene();
        if (null == selectScene || selectScene.isEmpty()) {
            return;
        }
        JSONObject executeContext = selectScene.getJSONObject("executeContext");
        String rtMsgServerId = MapUtils.getString((Map)executeContext, (Object)"rtMsgServerId");
        if (StrUtil.isBlank((CharSequence)rtMsgServerId)) {
            return;
        }
        ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
        List imSessionMsgLogs = this.hisConversationMessageService.queryMessage(questionMessage.getUserId(), questionMessage.getTenantId(), questionMessage.getConversationId(), null, questionMessage.getIndex(), 3);
        if (CollUtil.isNotEmpty((Collection)imSessionMsgLogs) && imSessionMsgLogs.size() == 3) {
            ConversationMessage multipleMsg = (ConversationMessage)imSessionMsgLogs.get(0);
            ConversationMessage firstMessage = (ConversationMessage)imSessionMsgLogs.get(1);
            ConversationMessage secondMessage = (ConversationMessage)imSessionMsgLogs.get(2);
            JSONObject body = multipleMsg.getMsgBody();
            Integer messageType = body.getInteger("messageType");
            String messageBusinessCode = body.getString("messageBusinessCode");
            if (MessageTypeEnum.MULTIPLE_INTENTIONS.getType().equals(messageType) && "ania_multiple_intentions".equals(messageBusinessCode) && (rtMsgServerId.equals(firstMessage.getMessageId()) || rtMsgServerId.equals(secondMessage.getMessageId()))) {
                questionMessage.getExt().put("hidden", true);
                boolean success = this.hisConversationMessageService.updateMessageExt(questionMessage);
                log.info("updateMessageExt status:{}", (Object)success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop(SseEventParams sseEventParam) {
        EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, completed);
        EventData doneData = new EventData(SseEventlEnum.CHAT_FAILED.getEvent(), null);
        this.sseEventDataService.saveEventDataLog(sseEventParam, doneData);
        SseEmitter sseEmitter = KnowledgeContext.getSseEmitter((String)sseEventParam.getId());
        if (Objects.nonNull(sseEmitter)) {
            try {
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)completed);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)completed);
                SseEmitterUtils.send((SseEmitter)sseEmitter, (EventData)doneData);
                SseEventContext.setAnswer((String)sseEventParam.getId(), (EventData)doneData);
            }
            catch (IOException e) {
                log.error("SseEmitterHisChatComponent.sendAnswerDone is error", (Throwable)e);
            }
            finally {
                sseEmitter.complete();
            }
        }
    }

    static /* synthetic */ AssistantSSeComponent access$100(SseEmitterHisChatComponent x0) {
        return x0.assistantSSeComponent;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

