/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.conversation.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSONObject;
import com.digiwin.athena.ania.common.DialogueModeEnum;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.ConvMsgContentTypeEnum;
import com.digiwin.athena.ania.common.enums.ConversationTypeEnum;
import com.digiwin.athena.ania.common.enums.notice.MessageAction;
import com.digiwin.athena.ania.configuration.RedisLock;
import com.digiwin.athena.ania.dto.conversation.ConversationListVo;
import com.digiwin.athena.ania.dto.conversation.ConversationQueryDto;
import com.digiwin.athena.ania.dto.conversation.ConversationReadDto;
import com.digiwin.athena.ania.dto.conversation.ConversationVo;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantInfoDto;
import com.digiwin.athena.ania.dto.dialogue.FusionAssistantVo;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.helper.SkcHelper;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.ConversationDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageDao;
import com.digiwin.athena.ania.service.assistant.FusionAssistantService;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.ania.service.notice.NoticeService;
import com.digiwin.athena.ania.util.DateUtils;
import com.digiwin.athena.ania.util.IdSnowflake;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class ConversationServiceImpl
implements ConversationService {
    private static final Logger log = LoggerFactory.getLogger(ConversationServiceImpl.class);
    @Resource
    private SkcHelper skcHelper;
    @Resource
    private RedisLock redisLock;
    @Resource
    private ConversationDao conversationDao;
    @Resource
    private ConversationMessageDao conversationMessageDao;
    @Resource
    private ConversationIndexService conversationIndexService;
    @Resource
    private EnvProperties envProperties;
    @Resource
    private NoticeService noticeService;
    @Lazy
    @Resource
    private FusionAssistantService fusionAssistantService;
    private static final long SEND_MESSAGE_LOCK = 5000L;
    @Resource
    private KmHelper kmHelper;

    public ConversationListVo getConversations(ConversationQueryDto param) {
        ConversationListVo result = new ConversationListVo();
        result.setPage(Integer.valueOf(param.getPage()));
        result.setPageSize(Integer.valueOf(param.getPageSize()));
        List<ConversationVo> conversationVoList = new ArrayList();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (!"nna".equals(param.getQueryType())) {
            List conversationList = this.conversationDao.queryUserConversation(authoredUser, param);
            if (CollectionUtils.isNotEmpty((Collection)conversationList)) {
                HashMap fusionAssistantMap = new HashMap();
                Map assistantMap = conversationList.stream().filter(item -> Objects.nonNull(item.getAgentType())).collect(Collectors.groupingBy(Conversation::getAgentType, Collectors.mapping(Conversation::getAgentId, Collectors.toSet())));
                if (MapUtils.isNotEmpty(assistantMap)) {
                    Set<String> publishAssistants;
                    Set historyAssistants = assistantMap.get(AssistantType.HISTORY_ASSISTANT.getType());
                    if (CollectionUtils.isNotEmpty((Collection)historyAssistants)) {
                        String tenantVersion = this.kmHelper.getTenantVersion(authoredUser.getTenantId());
                        historyAssistants.forEach(agentId -> {
                            FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(FusionAssistantInfoDto.builder().assistantId(agentId).assistantType(AssistantType.HISTORY_ASSISTANT.getType()).version(tenantVersion).auth(Boolean.valueOf(false)).build(), authoredUser);
                            fusionAssistantMap.put(agentId, fusionAssistantVo);
                        });
                    }
                    if (CollectionUtils.isNotEmpty(publishAssistants = assistantMap.get(AssistantType.PUBLISH_ASSISTANT.getType()))) {
                        publishAssistants.forEach(agentId -> {
                            FusionAssistantVo fusionAssistantVo = this.fusionAssistantService.assistantBaseInfo(FusionAssistantInfoDto.builder().assistantId(agentId).assistantType(AssistantType.PUBLISH_ASSISTANT.getType()).auth(Boolean.valueOf(false)).build(), authoredUser);
                            fusionAssistantMap.put(agentId, fusionAssistantVo);
                        });
                    }
                }
                for (Conversation conversation : conversationList) {
                    ConversationMessage message;
                    ConversationVo conversationVo = this.transformConversation2Vo(conversation, (FusionAssistantVo)fusionAssistantMap.get(conversation.getAgentId()));
                    if (!"latest".equals(param.getQueryType()) && Objects.nonNull(conversationVo.getMessageIndex()) && conversationVo.getMessageIndex() > 0 && Objects.nonNull(message = this.conversationMessageDao.getMessageByConversationIdAndIndex(conversationVo.getConversationId(), conversationVo.getMessageIndex().intValue()))) {
                        List contentMap = message.getContent();
                        String messageType = "general";
                        if (CollectionUtils.isNotEmpty((Collection)contentMap)) {
                            for (Map contentItem : contentMap) {
                                if (contentItem.get("type") == null) continue;
                                if (ConvMsgContentTypeEnum.CUST.getCode().equalsIgnoreCase((String)contentItem.get("type"))) {
                                    messageType = "card";
                                    break;
                                }
                                if (ConvMsgContentTypeEnum.FILE.getCode().equalsIgnoreCase((String)contentItem.get("type"))) {
                                    messageType = "file";
                                    break;
                                }
                                if (!ConvMsgContentTypeEnum.PIC.getCode().equalsIgnoreCase((String)contentItem.get("type"))) continue;
                                messageType = "picture";
                                break;
                            }
                            if ("general".equals(messageType)) {
                                StringBuilder sessionContent = new StringBuilder();
                                for (Map contentItem : contentMap) {
                                    sessionContent.append(contentItem.get("text").toString());
                                }
                                conversationVo.setSessionContent(sessionContent.toString());
                            }
                        }
                        conversationVo.setMessageType(messageType);
                    }
                    conversationVoList.add(conversationVo);
                }
            }
            if (conversationList.size() < param.getPageSize()) {
                int skcPage = 0;
                int skcPageSize = param.getPageSize();
                int offset = 0;
                if (conversationList.size() > 0) {
                    skcPageSize = param.getPageSize() - conversationList.size();
                } else {
                    Long nanaConversationCount = this.conversationDao.queryUserConversationCount(authoredUser, null);
                    long skcPageBegin = (long)((param.getPage() - 1) * param.getPageSize()) - nanaConversationCount;
                    if (skcPageBegin > 0L) {
                        skcPage = Long.valueOf(skcPageBegin).intValue() / param.getPageSize();
                    }
                    if (nanaConversationCount > 0L) {
                        offset = param.getPageSize() - Long.valueOf(nanaConversationCount % (long)param.getPageSize()).intValue();
                    }
                    if (offset > 0) {
                        skcPageSize = param.getPageSize() * 2;
                    }
                }
                JSONObject skcSessionResponse = this.skcHelper.queryAgentSessionList(param.getQueryType(), skcPage + 1, skcPageSize, authoredUser.getToken());
                if (skcSessionResponse != null && MapUtils.isNotEmpty((Map)skcSessionResponse)) {
                    int skcSessionTotal = skcSessionResponse.getIntValue("total");
                    if (skcSessionTotal > 0) {
                        List skcSessionList = (List)skcSessionResponse.get("rows");
                        if (offset > 0) {
                            int offsetEnd = param.getPageSize() + offset;
                            if (skcSessionTotal < offsetEnd) {
                                offsetEnd = skcSessionTotal;
                            }
                            skcSessionList = skcSessionList.subList(offset, offsetEnd);
                        }
                        conversationVoList.addAll(this.transformSkcSession2Vo(skcSessionList));
                        result.setHasNextPage(skcSessionResponse.getBoolean("hasNextPage"));
                    } else {
                        result.setHasNextPage(Boolean.valueOf(false));
                    }
                } else {
                    result.setHasNextPage(Boolean.valueOf(false));
                }
            } else {
                Long nanaConversationCount = this.conversationDao.queryUserConversationCount(authoredUser, null);
                if (nanaConversationCount > (long)(param.getPage() * param.getPageSize())) {
                    result.setHasNextPage(Boolean.valueOf(true));
                } else if (nanaConversationCount == (long)(param.getPage() * param.getPageSize())) {
                    JSONObject skcSessionResponse = this.skcHelper.queryAgentSessionList(param.getQueryType(), 1, param.getPageSize(), authoredUser.getToken());
                    if (skcSessionResponse != null && MapUtils.isNotEmpty((Map)skcSessionResponse) && skcSessionResponse.getIntValue("total") > 0) {
                        result.setHasNextPage(Boolean.valueOf(true));
                    } else {
                        result.setHasNextPage(Boolean.valueOf(false));
                    }
                } else {
                    result.setHasNextPage(Boolean.valueOf(false));
                }
            }
        } else {
            JSONObject skcSessionResponse = this.skcHelper.queryAgentSessionList(param.getQueryType(), param.getPage(), param.getPageSize(), authoredUser.getToken());
            if (skcSessionResponse != null && MapUtils.isNotEmpty((Map)skcSessionResponse) && skcSessionResponse.getIntValue("total") > 0) {
                List skcSessionList = (List)skcSessionResponse.get("rows");
                conversationVoList = this.transformSkcSession2Vo(skcSessionList);
                result.setHasNextPage(skcSessionResponse.getBoolean("hasNextPage"));
            } else {
                result.setHasNextPage(Boolean.valueOf(false));
            }
        }
        Collections.sort(conversationVoList, (o1, o2) -> o2.getUpdateTime().compareTo(o1.getUpdateTime()));
        result.setConversationList(conversationVoList);
        return result;
    }

    private ConversationVo transformConversation2Vo(Conversation conversation, FusionAssistantVo fusionAssistantVo) {
        String agentId = conversation.getAgentId();
        String iconUrl = conversation.getIconUrl();
        String title = conversation.getTitle();
        ConversationVo conversationVo = new ConversationVo();
        if (fusionAssistantVo != null) {
            conversationVo.setVersion(fusionAssistantVo.getVersion());
            conversationVo.setClientType(fusionAssistantVo.getClientType());
            iconUrl = fusionAssistantVo.getIconUrl();
            if (DialogueModeEnum.longDialogueMode.equals((Object)fusionAssistantVo.getDialogueModeEnum())) {
                title = fusionAssistantVo.getAssistantName();
            }
        }
        conversationVo.setId(conversation.getId());
        conversationVo.setConversationId(conversation.getConversationId());
        conversationVo.setConversationType(conversation.getConversationType());
        conversationVo.setIconUrl(iconUrl);
        conversationVo.setAgentId(agentId);
        conversationVo.setUserId(conversation.getUserId());
        conversationVo.setTenantId(conversation.getTenantId());
        conversationVo.setTitle(title);
        conversationVo.setSessionTitle(conversation.getSessionTitle());
        conversationVo.setSectionId(conversation.getSectionId());
        conversationVo.setUpdateTime(conversation.getUpdateTime());
        conversationVo.setStatus(conversation.getStatus());
        conversationVo.setAgentType(conversation.getAgentType());
        conversationVo.setMessageIndex(this.conversationIndexService.getMaxIndex(conversation.getUserId(), conversation.getConversationId(), conversation.getAgentType()));
        conversationVo.setReadMessageIndex(this.conversationIndexService.getReadIndex(conversation.getUserId(), conversation.getConversationId()));
        return conversationVo;
    }

    private List<ConversationVo> transformSkcSession2Vo(List<Map> skcSessionList) {
        ArrayList<ConversationVo> conversationVoList = new ArrayList<ConversationVo>();
        for (Map skcSession : skcSessionList) {
            String fileId = (String)skcSession.get("skillIcon");
            String skillIconUrl = this.envProperties.getDmcUri() + "/api/dmc/v2/file/KSC/preview/" + fileId;
            ConversationVo conversationVo = new ConversationVo();
            conversationVo.setId((String)skcSession.get("id"));
            conversationVo.setConversationType(ConversationTypeEnum.THIRD.getType());
            conversationVo.setIconUrl(skillIconUrl);
            conversationVo.setAgentId((String)skcSession.get("subscriptionCode"));
            conversationVo.setUserId((String)skcSession.get("createId"));
            conversationVo.setTitle((String)skcSession.get("sessionTitle"));
            conversationVo.setSessionTitle((String)skcSession.get("sessionTitle"));
            conversationVo.setSectionId((String)skcSession.get("sessionId"));
            conversationVo.setStatus(Integer.valueOf(1));
            conversationVo.setAgentType(AssistantType.EMBEDDED_ASSISTANT.getType());
            conversationVo.setMessageType((String)skcSession.get("messageType"));
            conversationVo.setSessionContent((String)skcSession.get("sessionContent"));
            conversationVo.setSuperSessionId((String)skcSession.get("superSessionId"));
            conversationVo.setSessionId((String)skcSession.get("sessionId"));
            String conversationId = StringUtils.isNotBlank((CharSequence)conversationVo.getSuperSessionId()) ? conversationVo.getSuperSessionId() : conversationVo.getSessionId();
            conversationVo.setConversationId(conversationId);
            conversationVo.setSkillIcon(skillIconUrl);
            conversationVo.setSkillName((String)skcSession.get("skillName"));
            conversationVo.setSkillId((String)skcSession.get("skillId"));
            conversationVo.setSubscriptionCode((String)skcSession.get("subscriptionCode"));
            conversationVo.setTenantName((String)skcSession.get("tenantName"));
            conversationVo.setTenantsid((String)skcSession.get("tenantsid"));
            conversationVo.setTenantId((String)skcSession.get("tenantId"));
            conversationVo.setCreateId((String)skcSession.get("createId"));
            conversationVo.setCreateName((String)skcSession.get("createName"));
            conversationVo.setCreateTime((String)skcSession.get("createTime"));
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)skcSession.get("updateTime")))) {
                Long updateTime = DateUtils.dataStr2Timestamp((String)((String)skcSession.get("updateTime")));
                if (updateTime > 0L) {
                    conversationVo.setUpdateTime(updateTime);
                } else {
                    Long createTime = DateUtils.dataStr2Timestamp((String)((String)skcSession.get("createTime")));
                    conversationVo.setUpdateTime(createTime);
                }
            } else {
                Long createTime = DateUtils.dataStr2Timestamp((String)((String)skcSession.get("createTime")));
                conversationVo.setUpdateTime(createTime);
            }
            conversationVoList.add(conversationVo);
        }
        return conversationVoList;
    }

    public ConversationVo getConversationInfo(String conversationId, String userId) {
        ConversationVo conversationInfo = null;
        Conversation nanaConversation = this.conversationDao.queryConversationById(conversationId, userId);
        if (nanaConversation != null) {
            conversationInfo = this.transformConversation2Vo(nanaConversation, null);
        }
        return conversationInfo;
    }

    public ConversationVo getAgentLatestConversationInfo(String agentId) {
        ConversationVo conversationInfo = null;
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        Conversation nanaConversation = this.conversationDao.queryLatestConversationByAgentId(authoredUser.getTenantId(), authoredUser.getUserId(), agentId);
        if (nanaConversation != null) {
            conversationInfo = this.transformConversation2Vo(nanaConversation, null);
        }
        return conversationInfo;
    }

    public void updateMessageFeedback(String conversationId, String messageId, Integer feedback) {
        this.conversationMessageDao.updateFeedback(conversationId, messageId, feedback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(ConversationReadDto dto, AuthoredUser authoredUser) {
        if (!this.conversationDao.isExitConversation(dto.getConversationId(), authoredUser.getTenantId(), authoredUser.getUserId())) {
            log.warn("conversation.message.read false(conversation is null)");
            return false;
        }
        String lockKey = "ania:assistant:read:" + dto.getConversationId();
        String tryLock = this.redisLock.tryLock(lockKey, 5000L);
        try {
            if (Objects.nonNull(tryLock)) {
                Integer readIndex = this.conversationIndexService.getReadIndex(authoredUser.getUserId(), dto.getConversationId());
                if (dto.getReadIndex() >= readIndex) {
                    this.conversationIndexService.updateConversationReadIndex(authoredUser.getUserId(), dto.getConversationId(), dto.getReadIndex().intValue());
                    this.noticeService.conversationEvent(MessageAction.UPDATE, Conversation.builder().conversationId(dto.getConversationId()).tenantId(authoredUser.getTenantId()).userId(authoredUser.getUserId()).build());
                    boolean bl = true;
                    return bl;
                }
                log.warn("conversation.message.read false dto.getReadIndex:{},readIndex:{}", (Object)dto.getReadIndex(), (Object)readIndex);
            }
        }
        finally {
            if (Objects.nonNull(tryLock)) {
                this.redisLock.unlock(lockKey, tryLock);
            }
        }
        log.warn("conversation.message.read false(tryLock:{})", (Object)tryLock);
        return false;
    }

    public String newSection(String conversationId) {
        Conversation conversation = this.conversationDao.queryConversationById(conversationId, AppAuthContextHolder.getContext().getAuthoredUser().getUserId());
        if (Objects.isNull(conversation)) {
            throw BusinessException.create((String)"Conversation is not exist");
        }
        ConversationMessage message = this.conversationMessageDao.getLastMessageByConversationId(conversationId);
        if (Objects.isNull(message)) {
            return conversation.getSectionId();
        }
        if (conversation.getSectionId().equals(message.getSectionId())) {
            String newSectionId = IdSnowflake.snowflakeIdStr();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)conversationId));
            this.conversationDao.update(query, new Update().set("sectionId", (Object)newSectionId));
            return newSectionId;
        }
        return conversation.getSectionId();
    }

    public ConversationVo createOrQueryLongDialogueConversationInfo(FusionAssistantVo fusionAssistant, AuthoredUser authoredUser) {
        if (!DialogueModeEnum.longDialogueMode.equals((Object)fusionAssistant.getDialogueModeEnum())) {
            return null;
        }
        Conversation conversation = this.queryAgentConversation(fusionAssistant.getAssistantId(), authoredUser.getUserId(), authoredUser.getTenantId(), ConversationTypeEnum.LONG);
        if (Objects.isNull(conversation)) {
            conversation = this.creatConversation(fusionAssistant.getAssistantName(), fusionAssistant, authoredUser.getUserId(), authoredUser.getTenantId());
        }
        return this.transformConversation2Vo(conversation, fusionAssistant);
    }

    public Conversation queryAgentConversation(String agentId, String userId, String tenantId, ConversationTypeEnum conversationType) {
        Criteria criteria = this.conversationDao.baseCriteria(tenantId, userId).and("agentId").is((Object)agentId);
        if (Objects.nonNull(conversationType)) {
            criteria.and("conversationType").is((Object)conversationType.getType());
        }
        return (Conversation)this.conversationDao.findOne(new Query((CriteriaDefinition)criteria));
    }

    public Conversation getConversation(String conversationId, ConversationTypeEnum conversationType, String tenantId, String userId) {
        Criteria criteria = this.conversationDao.baseCriteria(tenantId, userId).and("conversationId").is((Object)conversationId);
        if (Objects.nonNull(conversationType)) {
            criteria.and("conversationType").is((Object)conversationType.getType());
        }
        return (Conversation)this.conversationDao.findOne(new Query((CriteriaDefinition)criteria));
    }

    public void deleteConversation(List<String> conversationIds, AuthoredUser authoredUser) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)this.conversationDao.baseCriteria(authoredUser.getTenantId(), authoredUser.getUserId()).and("conversationId").in(conversationIds).and("conversationType").is((Object)ConversationTypeEnum.TOPIC.getType()));
        UpdateResult updateResult = this.conversationDao.update(query, new Update().set("status", (Object)2));
        long modifiedCount = updateResult.getModifiedCount();
        if (modifiedCount > 0L && modifiedCount == (long)conversationIds.size()) {
            conversationIds.forEach(conversationId -> {
                Conversation conversation = new Conversation();
                conversation.setConversationId(conversationId);
                conversation.setTenantId(authoredUser.getTenantId());
                conversation.setUserId(authoredUser.getUserId());
                this.noticeService.conversationEvent(MessageAction.DELETED, conversation);
            });
        }
    }

    public void updateConversationTopic(String conversationId, String userId, String newTopic) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)conversationId).and("userId").is((Object)userId));
        this.conversationDao.update(query, new Update().set("title", (Object)newTopic));
    }

    public List<Conversation> queryRecentAgents(List<String> agentIds, int limit) {
        if (CollUtil.isEmpty(agentIds)) {
            return new ArrayList<Conversation>();
        }
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        return this.conversationDao.queryRecentAgents(agentIds, authoredUser.getTenantId(), authoredUser.getUserId(), limit);
    }

    public Conversation creatConversation(String title, FusionAssistantVo fusionAssistant, String userId, String tenantId) {
        Conversation conversation = Conversation.builder().conversationType(DialogueModeEnum.topicBasedDialogueMode.equals((Object)fusionAssistant.getDialogueModeEnum()) ? ConversationTypeEnum.TOPIC.getType() : ConversationTypeEnum.LONG.getType()).userId(userId).tenantId(tenantId).title(title).sessionTitle(title).iconUrl(fusionAssistant.getIconUrl()).agentId(fusionAssistant.getAssistantId()).agentType(fusionAssistant.getAssistantType()).status(Integer.valueOf(1)).build();
        return this.creatConversation(conversation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conversation creatConversation(Conversation creatConversation) {
        creatConversation.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        creatConversation.setSectionId(IdSnowflake.snowflakeIdStr());
        creatConversation.setConversationId(IdSnowflake.snowflakeIdStr());
        if (Objects.equals(ConversationTypeEnum.LONG.getType(), creatConversation.getConversationType())) {
            String key = "ANIA:CREAT:CONVERSATION" + creatConversation.getTenantId() + ":" + creatConversation.getUserId();
            String tryLock = null;
            try {
                tryLock = this.redisLock.tryLock(key, 5000L);
                if (Objects.isNull(tryLock)) {
                    throw BusinessException.create((String)"lock", (String)"creatConversation lock");
                }
                Conversation conversation = this.conversationDao.queryLatestConversationByAgentId(creatConversation.getTenantId(), creatConversation.getUserId(), creatConversation.getAgentId());
                if (Objects.nonNull(conversation)) {
                    Conversation conversation2 = conversation;
                    return conversation2;
                }
                this.conversationIndexService.initConversationIndex(creatConversation.getConversationId());
                Conversation conversation3 = (Conversation)this.conversationDao.insert((Object)creatConversation);
                return conversation3;
            }
            finally {
                if (Objects.nonNull(tryLock)) {
                    this.redisLock.unlock(key, tryLock);
                }
            }
        }
        this.conversationIndexService.initConversationIndex(creatConversation.getConversationId());
        return (Conversation)this.conversationDao.insert((Object)creatConversation);
    }
}

