/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl;

import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.service.IntentTypeHandler;
import com.digiwin.athena.ania.service.impl.IntentTypeHandlerFactory;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntentTypeHandlerStrategy {
    private static final Logger log = LoggerFactory.getLogger(IntentTypeHandlerStrategy.class);
    @Autowired
    private IntentTypeHandlerFactory intentTypeHandlerFactory;
    @Resource(name="bnaAssistantHandler")
    private IntentTypeHandler bnaAssistantHandler;

    public void handler(String intentType, UserMessageActionContext userMessageActionContext) {
        this.singleandler(intentType, userMessageActionContext);
    }

    private void singleandler(String intentType, UserMessageActionContext userMessageActionContext) {
        try {
            IntentTypeHandler typeHandler = this.intentTypeHandlerFactory.getTypeHandler(intentType);
            if (Objects.nonNull(typeHandler)) {
                typeHandler.handler(userMessageActionContext);
            } else if (StringUtils.isNotBlank((CharSequence)intentType)) {
                this.bnaAssistantHandler.handler(userMessageActionContext);
            }
        }
        catch (Exception e) {
            log.error("\u5a1c\u5a1c\u6d88\u606f\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }
}

