/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.impl.bnaProcessor;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.ania.dto.AssistantConfig;
import com.digiwin.athena.ania.dto.LanguageTemplateBO;
import com.digiwin.athena.ania.env.EnvProperties;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.helper.UserMessageActionContext;
import com.digiwin.athena.ania.helper.im.ImTypeHandlerStrategy;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.mongo.repository.AssistantSceneDao;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public abstract class BnaProcessor {
    private static final Logger log = LoggerFactory.getLogger(BnaProcessor.class);
    @Resource
    protected KmHelper kmHelper;
    @Autowired
    protected RestTemplate restTemplate;
    @Autowired
    protected EnvProperties envProperties;
    @Resource
    protected AssistantSceneDao assistantSceneDao;
    @Autowired
    protected ImTypeHandlerStrategy imTypeHandlerStrategy;
    @Resource
    protected AsaKnowledgeMessageDao asaKnowledgeMessageDao;

    public abstract Integer getAssistantSubType();

    public abstract void execute(UserMessageActionContext var1);

    public void filterAuthScene(List<LanguageTemplateBO> filterAssistantScenes, AssistantConfig assistantConfig, List<LanguageTemplateBO> assistantScene, Map<String, Map> authAppIdMapList, Set<String> authAppIds) {
    }

    protected Boolean auth(String authIndex, Map<String, Map> currentAppIdMapList, Set<String> authAppIds) {
        try {
            if (authAppIds.contains(authIndex)) {
                Map appMap;
                DateTime expiredTime;
                if (Objects.nonNull(currentAppIdMapList) && (expiredTime = DateUtil.parseDate((CharSequence)MapUtils.getString((Map)(appMap = currentAppIdMapList.get(authIndex)), (Object)"expiredTime"))).after(new Date())) {
                    return true;
                }
                return true;
            }
        }
        catch (Exception e) {
            log.error("BnaProcessor.auth error", (Throwable)e);
            return false;
        }
        return false;
    }
}

