/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.message;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.ImConstants;
import com.digiwin.athena.ania.common.ResultBean;
import com.digiwin.athena.ania.common.enums.AssistantType;
import com.digiwin.athena.ania.common.enums.ConversationTypeEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.configuration.RedisLock;
import com.digiwin.athena.ania.dto.HisConversationMessageDto;
import com.digiwin.athena.ania.entity.im.ImSendMsgResult;
import com.digiwin.athena.ania.eventbus.message.ConversationMessageEvent;
import com.digiwin.athena.ania.mongo.domain.AsaKnowledgeMessage;
import com.digiwin.athena.ania.mongo.domain.Assistant;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.mongo.repository.AsaKnowledgeMessageDao;
import com.digiwin.athena.ania.mongo.repository.ConversationDao;
import com.digiwin.athena.ania.mongo.repository.ConversationMessageDao;
import com.digiwin.athena.ania.service.assistant.AssistantService;
import com.digiwin.athena.ania.service.conversation.ConversationIndexService;
import com.digiwin.athena.ania.service.conversation.ConversationMessageService;
import com.digiwin.athena.ania.service.conversation.ConversationService;
import com.digiwin.athena.ania.service.message.HisConversationMessageService;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.ania.util.IdSnowflake;
import com.digiwin.athena.ania.util.RedisUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.mongodb.client.result.UpdateResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

@Service
public class HisConversationMessageServiceImpl
implements HisConversationMessageService {
    private static final Logger log = LoggerFactory.getLogger(HisConversationMessageServiceImpl.class);
    @Resource
    private ConversationMessageDao conversationMessageDao;
    @Resource
    private AssistantService assistantService;
    @Resource
    private RedisLock redisLock;
    @Resource
    private ConversationDao conversationDao;
    @Resource
    private AsaKnowledgeMessageDao asaKnowledgeMessageDao;
    @Resource
    private AsyncEventBus asyncEventBus;
    @Resource
    private ConversationIndexService conversationIndexService;
    @Resource
    private ConversationMessageService conversationMessageService;
    @Resource
    protected ConversationService conversationService;
    private static final long SEND_MESSAGE_LOCK = 5000L;

    public void sendMessage(ConversationMessage message) {
        if (Objects.isNull(message.getIndex())) {
            Integer maxIndex = this.conversationIndexService.incrementIndex(message.getUserId(), message.getConversationId());
            message.setIndex(maxIndex);
        }
        this.conversationMessageService.sendMessage(message);
    }

    public List<ConversationMessage> queryMessage(String userId, String tenantId, String conversationId, String sectionId, Integer index, int limit) {
        if (StringUtils.isBlank((CharSequence)conversationId)) {
            return Collections.emptyList();
        }
        return this.conversationMessageDao.queryMessage(userId, tenantId, conversationId, sectionId, index, limit);
    }

    public boolean updateMessageExt(ConversationMessage message) {
        boolean success;
        Update update;
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"conversationId").is((Object)message.getConversationId()).and("messageId").is((Object)message.getMessageId()));
        UpdateResult updateResult = this.conversationMessageDao.update(query, update = new Update().set("msgExt", (Object)message.getExt()).set("msgExt", (Object)BaseUseUtils.toJsonString((Object)message.getExt())));
        boolean bl = success = updateResult.getMatchedCount() > 0L;
        if (success) {
            this.asyncEventBus.post((Object)new ConversationMessageEvent(message, 1));
        }
        return success;
    }

    public List<HisConversationMessageDto> latelyMessage(Map<String, Object> mapParam, AuthoredUser authoredUser, int limit) {
        String skillType = (String)mapParam.get("skillType");
        String asaCode = (String)mapParam.get("asaCode");
        String assistanceCode = this.getRealAssistanceCode(StringUtils.isNotBlank((CharSequence)asaCode) ? asaCode : skillType);
        Conversation conversation = this.queryConversation(assistanceCode, authoredUser.getUserId(), authoredUser.getTenantId());
        if (Objects.isNull(conversation)) {
            return Collections.emptyList();
        }
        return this.convertImMessageLog(this.queryMessage(authoredUser.getUserId(), authoredUser.getTenantId(), conversation.getConversationId(), null, null, limit));
    }

    public Conversation queryConversation(String assistanceCode, String userId, String tenantId) {
        Query query = new Query((CriteriaDefinition)this.conversationDao.baseCriteria(tenantId, userId).and("agentId").is((Object)assistanceCode).and("conversationType").is((Object)ConversationTypeEnum.LONG.getType()));
        query.limit(1);
        return (Conversation)this.conversationDao.findOne(query);
    }

    public Conversation creatConversation(Assistant assistant, String userId, String tenantId) {
        Conversation conversation = Conversation.builder().conversationType(ConversationTypeEnum.LONG.getType()).userId(userId).tenantId(tenantId).title(assistant.getAssistantName(LocaleContextHolder.getLocale().toLanguageTag())).iconUrl(assistant.getAssistantAvatar()).agentId(assistant.getAssistantCode()).agentType(AssistantType.HISTORY_ASSISTANT.getType()).status(Integer.valueOf(1)).updateTime(Long.valueOf(System.currentTimeMillis())).build();
        return this.conversationService.creatConversation(conversation);
    }

    private String getRealAssistanceCode(String assistanceCode) {
        if ("1".equals(assistanceCode)) {
            return "asada";
        }
        if ("2".equals(assistanceCode)) {
            return "asaka";
        }
        if ("3".equals(assistanceCode)) {
            return "asaaa";
        }
        if ("4".equals(assistanceCode)) {
            return "asaca";
        }
        return assistanceCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultBean<ImSendMsgResult> sendMessage(Map<String, Object> message, AuthoredUser authoredUser) {
        try {
            HashMap<String, String> msgExt;
            if (message.containsKey("msgExt")) {
                Object extObj = message.get("msgExt");
                if (!(extObj instanceof Map)) {
                    log.warn("msgExt is not a Map, using empty map instead.");
                    msgExt = new HashMap();
                } else {
                    msgExt = new HashMap((Map)extObj);
                }
            } else {
                msgExt = new HashMap<String, String>();
            }
            Object msgBodyObj = message.get("msgBody");
            JSONObject msgBody = null;
            if (msgBodyObj == null) {
                return ResultBean.fail((String)"message is blank");
            }
            if (msgBodyObj instanceof Map) {
                msgBody = new JSONObject((Map)msgBodyObj);
            }
            if (MapUtils.isEmpty(msgBody)) {
                return ResultBean.fail((String)"message is blank");
            }
            String targetTenantId = MapUtils.getString(message, (Object)"targetTenantId");
            String targetUserId = MapUtils.getString(message, (Object)"userId");
            String proxyToken = MapUtils.getString(message, (Object)"proxyToken");
            String msgType = MapUtils.getString(message, (Object)"msgType");
            String skillType = MapUtils.getString(message, (Object)"skillType");
            String asaCode = MapUtils.getString(msgExt, (Object)"asaCode");
            String tenantId = StringUtils.isNotBlank((CharSequence)targetTenantId) ? targetTenantId : authoredUser.getTenantId();
            String userId = StringUtils.isNotBlank((CharSequence)targetUserId) ? targetUserId : authoredUser.getUserId();
            msgExt.put("userId", userId);
            msgExt.put("proxyToken", proxyToken);
            msgExt.put("targetTenantId", targetTenantId);
            msgExt.put("skillType", skillType);
            if (!msgExt.containsKey("routerKey")) {
                msgExt.put("routerKey", authoredUser.getTenantId());
            }
            if (!msgExt.containsKey("token")) {
                msgExt.put("token", authoredUser.getToken());
            }
            String assistanceCode = this.getRealAssistanceCode(StringUtils.isNotBlank((CharSequence)asaCode) ? asaCode : skillType);
            String lockKey = "ania:lock:conversation:" + tenantId + ":" + userId + ":" + assistanceCode;
            boolean locked = this.redisLock.acquireLock(lockKey, assistanceCode, 10000L, 10000L);
            if (!locked) return new ResultBean(Integer.valueOf(500), Integer.valueOf(500), "\u53d1\u9001\u9891\u7387\u8fc7\u9ad8\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            try {
                String key;
                String chatMessageId;
                String text;
                Conversation conversation = this.queryConversation(assistanceCode, userId, tenantId);
                if (Objects.isNull(conversation)) {
                    Assistant assistant = this.assistantService.getAssistant(assistanceCode, tenantId, null);
                    conversation = this.creatConversation(assistant, userId, tenantId);
                }
                String msgTypeValue = "txt".equalsIgnoreCase(msgType) || ImConstants.ImMsgTypeEnum.TEXT.getTypeChar().equalsIgnoreCase(msgType) ? ImConstants.ImMsgTypeEnum.TEXT.getTypeChar() : ImConstants.ImMsgTypeEnum.CUSTOM.getTypeChar();
                String messageId = IdSnowflake.snowflakeIdStr();
                ConversationMessage conversationMessage = ConversationMessage.builder().msgBody(msgBody).msgType(msgTypeValue).ext(msgExt).msgExt(JSONUtil.toJsonStr(msgExt)).messageId(messageId).feedback(Integer.valueOf(0)).userType(2).status(Integer.valueOf(1)).sectionId(conversation.getSectionId()).createTime(Long.valueOf(System.currentTimeMillis())).conversationId(conversation.getConversationId()).agentId(conversation.getAgentId()).userId(userId).tenantId(tenantId).build();
                if (ImConstants.ImMsgTypeEnum.TEXT.getTypeChar().equalsIgnoreCase(conversationMessage.getMsgType()) && StringUtils.isNotBlank((CharSequence)(text = MapUtils.getString((Map)conversationMessage.getMsgBody(), (Object)"text")))) {
                    HashMap<String, String> textContent = new HashMap<String, String>(2);
                    textContent.put("type", SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType());
                    textContent.put(SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), text);
                    conversationMessage.setContent((List)Lists.newArrayList((Object[])new Map[]{textContent}));
                }
                if (StringUtils.isNotBlank((CharSequence)(chatMessageId = RedisUtils.getCacheStrData((String)(key = "ANIA:ASSISTANT:CHAT:" + conversation.getConversationId()))))) {
                    RedisUtils.convertAndSend((String)"ANIA_SSE_DISCONNECT", (Object)chatMessageId);
                }
                if (RedisUtils.noKey((String)key, (long)5000L)) {
                    this.sendMessage(conversationMessage);
                    ImSendMsgResult sendMsgResult = new ImSendMsgResult();
                    sendMsgResult.setMsgId(Long.valueOf(conversationMessage.getMessageId()));
                    sendMsgResult.setMsgSendTime(conversationMessage.getCreateTime());
                    ResultBean resultBean = ResultBean.success((Object)sendMsgResult);
                    return resultBean;
                }
                ResultBean resultBean = new ResultBean(Integer.valueOf(500), Integer.valueOf(500), "\u6b63\u5728\u5bf9\u8bdd\u4e2d\uff0c\u53d1\u9001\u9891\u7387\u8fc7\u9ad8\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                return resultBean;
            }
            finally {
                this.redisLock.releaseLock(lockKey);
            }
        }
        catch (Exception e) {
            log.error("sendMessage is error message:{}", (Object)BaseUseUtils.toJsonString(message), (Object)e);
            return new ResultBean(Integer.valueOf(500), Integer.valueOf(500), "\u53d1\u9001\u6d88\u606f\u5931\u8d25");
        }
    }

    public List<HisConversationMessageDto> queryMessagesByIds(List<String> messageIdList, AuthoredUser authoredUser) {
        return this.convertImMessageLog(this.conversationMessageDao.queryMessage(messageIdList, authoredUser.getUserId(), authoredUser.getTenantId()));
    }

    public List<HisConversationMessageDto> convertImMessageLog(List<ConversationMessage> messages) {
        if (CollectionUtils.isNotEmpty(messages)) {
            return messages.stream().map(item -> {
                JSONObject msgExt;
                String contentId;
                HisConversationMessageDto imMessageLog = new HisConversationMessageDto(item);
                if (item.getUserType() == 2 && StringUtils.isNotBlank((CharSequence)(contentId = MapUtils.getString((Map)(msgExt = imMessageLog.getMsgExt()), (Object)"contentId")))) {
                    AsaKnowledgeMessage asaKnowledgeMessage = this.asaKnowledgeMessageDao.findById((Object)contentId).orElse(null);
                    imMessageLog.setAnswerWrapper(asaKnowledgeMessage);
                }
                return imMessageLog;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

