/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.notice.impl;

import com.digiwin.athena.ania.common.enums.notice.MessageAction;
import com.digiwin.athena.ania.common.enums.notice.MessageCategory;
import com.digiwin.athena.ania.dto.mqtt.EventMessageData;
import com.digiwin.athena.ania.dto.notice.NoticeDto;
import com.digiwin.athena.ania.mongo.domain.Conversation;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.service.notice.MqttService;
import com.digiwin.athena.ania.service.notice.NoticeService;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NoticeServiceImpl
implements NoticeService {
    private static final Logger log = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Resource
    private MqttService mqttService;

    public void conversationEvent(MessageAction actionType, Conversation conversation) {
        EventMessageData messageData = EventMessageData.build((MessageCategory)MessageCategory.CONVERSATION, (MessageAction)actionType, (String)conversation.getTenantId(), (String)conversation.getUserId(), (Object)conversation);
        this.pushEvent(messageData);
    }

    public void conversationEvent(MessageAction actionType, ConversationMessage message) {
        if (Objects.equals(actionType, MessageAction.CREATED) && Objects.equals(1, message.getSource())) {
            return;
        }
        message.setContent(null);
        message.setHeaderInfos(null);
        EventMessageData messageData = EventMessageData.build((MessageCategory)MessageCategory.MESSAGE, (MessageAction)actionType, (String)message.getTenantId(), (String)message.getUserId(), (Object)message);
        this.pushEvent(messageData);
    }

    public void conversationEvent(MessageAction actionType, Map param) {
        String tenantId = MapUtils.getString((Map)param, (Object)"tenantId");
        String userId = MapUtils.getString((Map)param, (Object)"userId");
        EventMessageData messageData = EventMessageData.build((MessageCategory)MessageCategory.MESSAGE, (MessageAction)actionType, (String)tenantId, (String)userId, (Object)param);
        this.pushEvent(messageData);
    }

    public void noticeMessage(MessageAction actionType, NoticeDto param) {
        EventMessageData messageData = EventMessageData.build((MessageCategory)MessageCategory.NOTICE, (MessageAction)actionType, (String)param.getTenantId(), (String)param.getUserId(), (Object)param);
        this.pushEvent(messageData);
    }

    public void pushEvent(EventMessageData<?> eventData) {
        this.mqttService.pushEvent(eventData);
    }
}

