/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.dto.BusinessCreateProjectDto;
import com.digiwin.athena.ania.dto.chatgpt.command.BaseCommand;
import com.digiwin.athena.ania.helper.AsaHelper;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.BaseUseUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateProjectSceneService
extends AssistantSceneStrategy {
    private static final Logger log = LoggerFactory.getLogger(CreateProjectSceneService.class);
    @Autowired
    private AsaHelper asaHelper;

    public CreateProjectSceneService() {
        super(Integer.valueOf(105));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intentRequestAction(SseEventParams sseEventParam) {
        try {
            log.info("CreateProjectSceneService.intentRequestAction pre sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam));
            this.cacheSceneCode(sseEventParam);
            this.cacheCombinationMsg(sseEventParam);
            SseEventlEnum.SseEventDataTypeEnum verbose = SseEventlEnum.SseEventDataTypeEnum.VERBOSE;
            EventData eventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), verbose.getType(), null, this.sceneActionMessage(sseEventParam));
            this.sendEventData(sseEventParam, eventData);
            ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowStart(sseEventParam);
            BusinessCreateProjectDto businessCreateProjectDto = new BusinessCreateProjectDto();
            businessCreateProjectDto.setTemplateCommand((BaseCommand)sseEventParam.getActionScene().getSceneData());
            businessCreateProjectDto.setQuestion(sseEventParam.getQuestion());
            JSONObject result = this.asaHelper.createProject(businessCreateProjectDto, sseEventParam.getUser().getToken(), sseEventParam.getUser().getTenantId());
            String msg = null;
            if (Objects.nonNull(result) && Objects.nonNull(result.get((Object)"data"))) {
                JSONObject data = result.getJSONObject("data");
                if (data.containsKey((Object)"projectId")) {
                    msg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u5a1c\u5a1c\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u7b49!" : "\u5a1c\u5a1c\u6b63\u5728\u8655\u7406\u4e2d\uff0c\u8acb\u7a0d\u7b49!";
                    ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowEnd(sseEventParam);
                } else if (data.containsKey((Object)"msg")) {
                    msg = data.getString("msg");
                    ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowEnd(sseEventParam, Boolean.valueOf(false));
                }
            } else {
                msg = LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u9879\u76ee\u521b\u5efa\u53d1\u751f\u5f02\u5e38!" : "\u9805\u76ee\u5275\u5efa\u767c\u751f\u7570\u5e38!";
                ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowEnd(sseEventParam, Boolean.valueOf(false));
            }
            EventData actionData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), msg);
            this.sendEventData(sseEventParam, actionData);
            EventData completed = new EventData(SseEventlEnum.CHAT_COMPLETED.getEvent(), null);
            this.sendEventData(sseEventParam, completed);
        }
        catch (Exception ex) {
            log.error("TextReplySceneService.dispatchIntentRequest is error sseEventParam:{},assistantScene:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
        finally {
            this.stop(sseEventParam, true);
        }
    }
}

