/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.AssistantSubTypeEnum;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.configuration.KnowledgeAccountConfig;
import com.digiwin.athena.ania.knowledge.client.sse.EventStreamClient;
import com.digiwin.athena.ania.knowledge.client.sse.PrivateKnowledgeEventSourceListener;
import com.digiwin.athena.ania.knowledge.client.sse.PublicKnowledgeEventSourceListener;
import com.digiwin.athena.ania.knowledge.intentflow.SseFlow;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.HistoryItem;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.mongo.domain.ConversationMessage;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.digiwin.athena.appcore.auth.service.TokenVerifyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KnowledgeSceneService
extends AssistantSceneStrategy {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeSceneService.class);
    @Value(value="${chatFile.digi-kai-api-key}")
    private String digiKaiChatApiKey;
    @Resource
    private TokenVerifyService tokenVerifyService;
    @Resource
    private KnowledgeAccountConfig knowledgeAccountConfig;

    public KnowledgeSceneService() {
        super(Integer.valueOf(2));
    }

    public void intentRequestAction(SseEventParams sseEventParam) {
        try {
            ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowStart(sseEventParam);
            SseEventlEnum.SseEventDataTypeEnum verbose = SseEventlEnum.SseEventDataTypeEnum.VERBOSE;
            EventData eventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), verbose.getType(), null, this.sceneActionMessage(sseEventParam));
            this.sendEventData(sseEventParam, eventData);
            if (AssistantSubTypeEnum.KNOWLEAGE.getType().equals(sseEventParam.getAssistant().getAssistantSubType())) {
                if (!"private".equals(sseEventParam.getAssistant().getKnowledgeType())) {
                    this.publicKnowledgeRequest(sseEventParam);
                } else {
                    this.privateKnowledgeRequest(sseEventParam);
                }
            } else {
                AssistantScene assistantScene = (AssistantScene)sseEventParam.getActionScene().getActionScenes().get(0);
                if (!"private".equals(MapUtils.getString((Map)assistantScene.getKnowledgeBase(), (Object)"type"))) {
                    this.publicKnowledgeRequest(sseEventParam);
                } else {
                    this.privateKnowledgeRequest(sseEventParam);
                }
            }
        }
        catch (Exception ex) {
            ((SseFlow)this.flowMap.get(sseEventParam.getActionScene().getType())).flowEnd(sseEventParam, Boolean.valueOf(false));
            log.error("KnowledgeSceneService.intentRequestAction is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
            this.errorStop(sseEventParam, null);
        }
    }

    private void publicKnowledgeRequest(SseEventParams sseEventParam) {
        String kbAssistantCode;
        JSONObject param = new JSONObject();
        param.put("question", (Object)sseEventParam.getQuestion().getMessage().getText());
        param.put("messageId", (Object)sseEventParam.getId());
        param.put("knowledgeType", (Object)"public");
        AssistantScene assistantScene = (AssistantScene)sseEventParam.getActionScene().getActionScenes().get(0);
        if (this.knowledgeAccountConfig.isReferencedAttachmentSwitch() && this.knowledgeAccountConfig.getReferencedAttachmentAssistants().contains(sseEventParam.getAssistant().getAssistantCode())) {
            param.put("assitantCode", (Object)sseEventParam.getAssistant().getAssistantCode());
            param.put("showFile", (Object)true);
        }
        Integer historyNum = MapUtils.getInteger((Map)assistantScene.getKnowledgeBase(), (Object)"historyNum");
        this.addHistoryParam(sseEventParam, historyNum, param);
        String tenantId = assistantScene.getPublicIdentity().getString("tenantId");
        String token = (String)this.redisTemplate.opsForValue().get((Object)tenantId);
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.tokenVerifyService.queryApiVirtualToken(tenantId);
            this.redisTemplate.opsForValue().set((Object)tenantId, (Object)token, 1L, TimeUnit.DAYS);
        }
        String requestUrl = "daa4e1b1bdfdab04".equals(kbAssistantCode = assistantScene.getKnowledgeBase().getString("assistantCode")) ? this.envProperties.getUtasUri() + "/api/ai/ddbs/" + kbAssistantCode : this.envProperties.getKnowledgeUri() + kbAssistantCode;
        this.cacheSceneCode(sseEventParam);
        log.info("publicKnowledgeRequest sseEventParam:{}\uff0cparam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)BaseUseUtils.toJsonString((Object)param));
        PublicKnowledgeEventSourceListener sseListener = new PublicKnowledgeEventSourceListener(this.knowledgeAccountConfig, sseEventParam, this.sseEventDataService, this.flowMap);
        String callId = sseListener.getCallId();
        EventStreamClient.executeSSE((String)requestUrl, null, (String)token, (EventSourceListener)sseListener, (JSONObject)param, (String)sseEventParam.getLanguage(), (Map)this.getExecuteFunctions(sseEventParam.getUser().getTenantId()));
    }

    private void privateKnowledgeRequest(SseEventParams sseEventParam) {
        JSONObject param = new JSONObject();
        param.put("question", (Object)sseEventParam.getQuestion().getMessage().getText());
        param.put("messageId", (Object)sseEventParam.getId());
        param.put("knowledgeType", (Object)"private");
        param.put("stream", (Object)true);
        List actionScenes = sseEventParam.getActionScene().getActionScenes();
        if (CollectionUtils.isNotEmpty((Collection)actionScenes)) {
            AssistantScene assistantScene = (AssistantScene)actionScenes.get(0);
            Integer historyNum = MapUtils.getInteger((Map)assistantScene.getKnowledgeBase(), (Object)"historyNum");
            this.addHistoryParam(sseEventParam, historyNum, param);
        } else {
            this.addHistoryParam(sseEventParam, Integer.valueOf(3), param);
        }
        param.put("language", (Object)(LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u7b80\u4f53\u4e2d\u6587" : "\u7e41\u9ad4\u4e2d\u6587"));
        param.put("rootDirectory", (Object)3);
        String token = sseEventParam.getUser().getToken();
        String requestUrl = this.envProperties.getQaUri() + "/restful/standard/kcf/isv/api/v2/qa/chatfile";
        this.cacheSceneCode(sseEventParam);
        log.info("privateKnowledgeRequest sseEventParam:{}\uff0cparam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)BaseUseUtils.toJsonString((Object)param));
        PrivateKnowledgeEventSourceListener sseListener = new PrivateKnowledgeEventSourceListener(sseEventParam, this.sseEventDataService, this.flowMap);
        EventStreamClient.executeSSE((String)requestUrl, (String)this.digiKaiChatApiKey, (String)token, (EventSourceListener)sseListener, (JSONObject)param, (String)sseEventParam.getLanguage(), (Map)this.getExecuteFunctions(sseEventParam.getUser().getTenantId()));
    }

    private void addHistoryParam(SseEventParams sseEventParam, Integer historyNum, JSONObject param) {
        ArrayList<HistoryItem> historyList = new ArrayList<HistoryItem>();
        try {
            if (historyNum != null && historyNum > 0) {
                ConversationMessage questionMessage = sseEventParam.getQuestionMessage();
                List imMessageLogList = this.hisConversationMessageService.queryMessage(questionMessage.getUserId(), questionMessage.getTenantId(), questionMessage.getConversationId(), questionMessage.getSectionId(), questionMessage.getIndex(), 10);
                for (ConversationMessage message : imMessageLogList) {
                    if (message.getUserType() != 2 || !CollectionUtils.isNotEmpty((Collection)message.getContent())) continue;
                    String msgText = message.getMsgBody().getString("text");
                    String text = "";
                    List textMap = message.getContent().stream().filter(item -> "text".equalsIgnoreCase(MapUtils.getString((Map)item, (Object)"type"))).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(textMap)) continue;
                    text = MapUtils.getString((Map)((Map)textMap.get(0)), (Object)"text");
                    HistoryItem historyItem = new HistoryItem();
                    historyItem.setQuestion(msgText);
                    historyItem.setAnswer(text);
                    historyList.add(historyItem);
                }
            }
        }
        catch (Exception ex) {
            log.error("KnowledgeSceneService.addHistoryParam is error", (Throwable)ex);
        }
        param.put("historyFlag", (Object)CollectionUtils.isNotEmpty(historyList));
        param.put("historyList", historyList);
    }
}

