/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ania.service.scene;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.ania.common.enums.LocalsEnum;
import com.digiwin.athena.ania.common.enums.SseEventlEnum;
import com.digiwin.athena.ania.helper.KmHelper;
import com.digiwin.athena.ania.helper.MicrosoftHelper;
import com.digiwin.athena.ania.knowledge.server.IntroducerComponent;
import com.digiwin.athena.ania.knowledge.server.dto.EventData;
import com.digiwin.athena.ania.knowledge.server.dto.SseEventParams;
import com.digiwin.athena.ania.mongo.domain.AssistantScene;
import com.digiwin.athena.ania.service.scene.AssistantSceneStrategy;
import com.digiwin.athena.ania.util.BaseUseUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NoneSceneService
extends AssistantSceneStrategy {
    private static final Logger log = LoggerFactory.getLogger(NoneSceneService.class);
    @Autowired
    private IntroducerComponent introducerComponent;
    @Autowired
    private MicrosoftHelper microsoftHelper;
    @Resource
    private KmHelper kmHelper;

    public NoneSceneService() {
        super(Integer.valueOf(88));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intentRequestAction(SseEventParams sseEventParam) {
        boolean success = false;
        try {
            ImmutableMap answerData = ImmutableMap.of((Object)"msg_type", (Object)"scene_action", (Object)"scene_type", (Object)88);
            SseEventlEnum.SseEventDataTypeEnum verbose = SseEventlEnum.SseEventDataTypeEnum.VERBOSE;
            EventData sceneActionEventData = new EventData(SseEventlEnum.MESSAGE_COMPLETED.getEvent(), verbose.getType(), null, JSON.toJSONString((Object)answerData));
            this.sendEventData(sseEventParam, sceneActionEventData);
            if (StringUtils.isNotBlank((CharSequence)sseEventParam.getAiMsg())) {
                success = true;
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), sseEventParam.getAiMsg());
                this.sendEventData(sseEventParam, eventData);
            } else if (CollectionUtils.isNotEmpty((Collection)sseEventParam.getIdentifyAllScenes())) {
                String applicationName;
                AssistantScene assistantScene = (AssistantScene)sseEventParam.getIdentifyAllScenes().get(0);
                if (Objects.equals(2, assistantScene.getType())) {
                    String type = MapUtils.getString((Map)assistantScene.getKnowledgeBase(), (Object)"type");
                    applicationName = "private".equals(type) ? (LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u79c1\u6709\u77e5\u8bc6\u5e93" : "\u79c1\u6709\u77e5\u8b58\u5eab") : assistantScene.getSceneName(sseEventParam.getLanguage());
                } else if (Objects.equals(1, assistantScene.getType())) {
                    String application = assistantScene.getDataMetric().getString("application");
                    JSONObject response = this.kmHelper.applicationByCode(application, sseEventParam.getUser().getTenantId());
                    applicationName = assistantScene.getSceneName(sseEventParam.getLanguage());
                    if (null != response && !response.isEmpty()) {
                        JSONObject lang = response.getJSONObject("lang");
                        JSONObject name = lang.getJSONObject("name");
                        applicationName = MapUtils.getString((Map)name, (Object)sseEventParam.getLanguage(), (String)applicationName);
                    }
                } else {
                    applicationName = Objects.equals(3, assistantScene.getType()) ? sseEventParam.getAssistant().getAssistantName(sseEventParam.getLanguage()) : assistantScene.getSceneName(sseEventParam.getLanguage());
                }
                success = true;
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), this.buildMsg(applicationName, sseEventParam.getLanguage()));
                this.sendEventData(sseEventParam, eventData);
            } else {
                String msg;
                JSONObject jsonObject = this.introducerComponent.introducerLargeModel(sseEventParam);
                msg = "sendMsg".equals(jsonObject.getString("command")) ? (StringUtils.isBlank((CharSequence)(msg = jsonObject.getString("msg"))) ? (LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u6ca1\u6709\u8bc6\u522b\u5230\u5bf9\u5e94\u7684\u610f\u56fe\u3002" : "\u62b1\u6b49\uff0c\u6c92\u6709\u8b58\u5225\u5230\u5c0d\u61c9\u7684\u610f\u5716\u3002") : (LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? msg : this.microsoftHelper.translateText(msg, true, sseEventParam.getUser().getToken()))) : (LocalsEnum.isCn((String)sseEventParam.getLanguage()) ? "\u62b1\u6b49\uff0c\u6ca1\u6709\u8bc6\u522b\u5230\u5bf9\u5e94\u7684\u610f\u56fe\u3002" : "\u62b1\u6b49\uff0c\u6c92\u6709\u8b58\u5225\u5230\u5c0d\u61c9\u7684\u610f\u5716\u3002");
                EventData eventData = new EventData(SseEventlEnum.MESSAGE_DELTA.getEvent(), SseEventlEnum.SseEventDataTypeEnum.ANSWER.getType(), SseEventlEnum.EventDataMessageEnum.TEXT.getMessageType(), msg);
                this.sendEventData(sseEventParam, eventData);
            }
        }
        catch (Exception ex) {
            log.error("NoneSceneService.intentRequestAction is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)ex);
        }
        finally {
            try {
                this.stop(sseEventParam, success);
            }
            catch (Exception e) {
                log.error("stopIntentRequest is error sseEventParam:{}", (Object)BaseUseUtils.toJsonString((Object)sseEventParam), (Object)e);
            }
        }
    }

    private String buildMsg(String applicationName, String language) {
        return "\u62b1\u6b49,\u3010" + applicationName + (LocalsEnum.isCn((String)language) ? "\u3011\u6ca1\u6709\u6743\u9650\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458" : "\u3011\u6c92\u6709\u6b0a\u9650\u3002\u8acb\u806f\u4fc2\u7ba1\u7406\u54e1");
    }
}

